/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.repeater.data.table;

import org.apache.wicket.Component;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.behavior.SimpleAttributeModifier;
import org.apache.wicket.extensions.markup.html.repeater.data.grid.DataGridView;
import org.apache.wicket.extensions.markup.html.repeater.data.table.AbstractToolbar;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IColumn;
import org.apache.wicket.extensions.markup.html.repeater.data.table.IStyledColumn;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.MarkupStream;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.IItemReuseStrategy;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.RepeatingView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.string.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataTable<T>
extends Panel
implements IPageable {
    public static final String TOOLBAR_COMPONENT_ID = "toolbar";
    private static final long serialVersionUID = 1L;
    private final DataGridView<T> datagrid;
    private final WebMarkupContainer body;
    private final IColumn<?>[] columns;
    private final RepeatingView topToolbars;
    private final RepeatingView bottomToolbars;

    public DataTable(String id, IColumn<T>[] columns, IDataProvider<T> dataProvider, int rowsPerPage) {
        super(id);
        if (columns == null || columns.length < 1) {
            throw new IllegalArgumentException("Argument `columns` cannot be null or empty");
        }
        this.columns = columns;
        this.body = this.newBodyContainer("body");
        this.datagrid = new DataGridView<T>("rows", columns, dataProvider){
            private static final long serialVersionUID = 1L;

            @Override
            protected Item newCellItem(String id, int index, IModel model) {
                Item item = DataTable.this.newCellItem(id, index, model);
                final IColumn column = DataTable.this.columns[index];
                if (column instanceof IStyledColumn) {
                    item.add(new IBehavior[]{new CssAttributeBehavior(){
                        private static final long serialVersionUID = 1L;

                        protected String getCssClass() {
                            return ((IStyledColumn)column).getCssClass();
                        }
                    }});
                }
                return item;
            }

            @Override
            protected Item<T> newRowItem(String id, int index, IModel<T> model) {
                return DataTable.this.newRowItem(id, index, model);
            }
        };
        this.datagrid.setRowsPerPage(rowsPerPage);
        this.body.add(new Component[]{this.datagrid});
        this.add(new Component[]{this.body});
        this.topToolbars = new ToolbarsContainer("topToolbars");
        this.bottomToolbars = new ToolbarsContainer("bottomToolbars");
        this.add(new Component[]{this.topToolbars});
        this.add(new Component[]{this.bottomToolbars});
    }

    protected WebMarkupContainer newBodyContainer(String id) {
        return new WebMarkupContainer(id);
    }

    public final void setTableBodyCss(String cssStyle) {
        this.body.add(new IBehavior[]{new SimpleAttributeModifier("class", (CharSequence)cssStyle)});
    }

    public void addBottomToolbar(AbstractToolbar toolbar) {
        this.addToolbar(toolbar, this.bottomToolbars);
    }

    public void addTopToolbar(AbstractToolbar toolbar) {
        this.addToolbar(toolbar, this.topToolbars);
    }

    public final IDataProvider<T> getDataProvider() {
        return this.datagrid.getDataProvider();
    }

    public final IColumn<?>[] getColumns() {
        return this.columns;
    }

    public final int getCurrentPage() {
        return this.datagrid.getCurrentPage();
    }

    public final int getPageCount() {
        return this.datagrid.getPageCount();
    }

    public final int getRowCount() {
        return this.datagrid.getRowCount();
    }

    public final int getRowsPerPage() {
        return this.datagrid.getRowsPerPage();
    }

    public final void setCurrentPage(int page) {
        this.datagrid.setCurrentPage(page);
        this.onPageChanged();
    }

    public final DataTable<T> setItemReuseStrategy(IItemReuseStrategy strategy) {
        this.datagrid.setItemReuseStrategy(strategy);
        return this;
    }

    public void setRowsPerPage(int items) {
        this.datagrid.setRowsPerPage(items);
    }

    private void addToolbar(AbstractToolbar toolbar, RepeatingView container) {
        if (toolbar == null) {
            throw new IllegalArgumentException("argument [toolbar] cannot be null");
        }
        if (!toolbar.getId().equals(TOOLBAR_COMPONENT_ID)) {
            throw new IllegalArgumentException("Toolbar must have component id equal to AbstractDataTable.TOOLBAR_COMPONENT_ID");
        }
        ToolbarContainer item = new ToolbarContainer(container.newChildId());
        item.add(new Component[]{toolbar});
        container.add(new Component[]{item});
    }

    protected Item<T> newCellItem(String id, int index, IModel<T> model) {
        return new Item(id, index, model);
    }

    protected Item<T> newRowItem(String id, int index, IModel<T> model) {
        return new Item(id, index, model);
    }

    protected void onDetach() {
        super.onDetach();
        if (this.columns != null) {
            for (int i = 0; i < this.columns.length; ++i) {
                this.columns[i].detach();
            }
        }
    }

    protected void onPageChanged() {
    }

    private static class ToolbarsContainer
    extends RepeatingView {
        private static final long serialVersionUID = 1L;

        private ToolbarsContainer(String id) {
            super(id);
        }
    }

    private static final class ToolbarContainer
    extends WebMarkupContainer {
        private static final long serialVersionUID = 1L;

        private ToolbarContainer(String id) {
            super(id);
        }

        protected void onRender(MarkupStream markupStream) {
            this.get(0).render(markupStream);
        }
    }

    static abstract class CssAttributeBehavior
    extends AbstractBehavior {
        private static final long serialVersionUID = 1L;

        CssAttributeBehavior() {
        }

        protected abstract String getCssClass();

        public void onComponentTag(Component component, ComponentTag tag) {
            String className = this.getCssClass();
            if (!Strings.isEmpty((CharSequence)className)) {
                CharSequence oldClassName = tag.getString("class");
                if (Strings.isEmpty((CharSequence)oldClassName)) {
                    tag.put("class", (CharSequence)className);
                } else {
                    tag.put("class", (CharSequence)(oldClassName + " " + className));
                }
            }
        }
    }
}

