/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree;

import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Component;
import org.apache.wicket.MarkupContainer;
import org.apache.wicket.behavior.AbstractBehavior;
import org.apache.wicket.behavior.IBehavior;
import org.apache.wicket.extensions.markup.html.tree.DefaultAbstractTree;
import org.apache.wicket.markup.ComponentTag;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IModel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Tree
extends DefaultAbstractTree {
    private static final long serialVersionUID = 1L;

    public Tree(String id) {
        super(id);
    }

    public Tree(String id, IModel<TreeModel> model) {
        super(id, model);
    }

    public Tree(String id, TreeModel model) {
        super(id, model);
    }

    protected void populateTreeItem(WebMarkupContainer item, int level) {
        final TreeNode node = (TreeNode)item.getDefaultModelObject();
        item.add(new Component[]{this.newIndentation((MarkupContainer)item, "indent", (TreeNode)item.getDefaultModelObject(), level)});
        item.add(new Component[]{this.newJunctionLink((MarkupContainer)item, "link", "image", node)});
        MarkupContainer nodeLink = this.newNodeLink((MarkupContainer)item, "nodeLink", node);
        item.add(new Component[]{nodeLink});
        nodeLink.add(new Component[]{this.newNodeIcon(nodeLink, "icon", node)});
        nodeLink.add(new Component[]{new Label("label", (IModel)new AbstractReadOnlyModel<String>(){
            private static final long serialVersionUID = 1L;

            public String getObject() {
                return Tree.this.renderNode(node);
            }
        })});
        item.add(new IBehavior[]{new AbstractBehavior(){
            private static final long serialVersionUID = 1L;

            public void onComponentTag(Component component, ComponentTag tag) {
                super.onComponentTag(component, tag);
                if (Tree.this.getTreeState().isNodeSelected((Object)node)) {
                    tag.put("class", (CharSequence)"row-selected");
                } else {
                    tag.put("class", (CharSequence)"row");
                }
            }
        }});
    }

    protected String renderNode(TreeNode node) {
        return node.toString();
    }
}

