/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree.table;

import java.util.Locale;
import javax.swing.tree.TreeNode;
import org.apache.wicket.Application;
import org.apache.wicket.Session;
import org.apache.wicket.extensions.markup.html.tree.table.AbstractColumn;
import org.apache.wicket.extensions.markup.html.tree.table.ColumnLocation;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.lang.PropertyResolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractPropertyColumn<T>
extends AbstractColumn {
    private static final long serialVersionUID = 1L;
    private IConverter<T> converter;
    private Locale locale;
    private final String propertyExpression;

    public AbstractPropertyColumn(ColumnLocation location, String header, String propertyExpression) {
        super(location, header);
        this.propertyExpression = propertyExpression;
    }

    public IConverter<T> getConverter() {
        return this.converter;
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setConverter(IConverter<T> converter) {
        this.converter = converter;
    }

    public void setLocale(Locale locale) {
        this.locale = locale;
    }

    protected String getPropertyExpression() {
        return this.propertyExpression;
    }

    public String getNodeValue(TreeNode node) {
        Object result = PropertyResolver.getValue((String)this.propertyExpression, (Object)node);
        IConverter converter = this.getConverter();
        if (converter == null && result != null) {
            converter = Application.get().getConverterLocator().getConverter(result.getClass());
        }
        if (converter != null) {
            Locale locale = this.locale;
            if (locale == null) {
                locale = Session.get().getLocale();
            }
            String string = converter.convertToString(result, locale);
            return string;
        }
        return result != null ? result.toString() : null;
    }
}

