/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.extensions.markup.html.tree;

import javax.swing.tree.TreeModel;
import org.apache.wicket.Component;
import org.apache.wicket.extensions.markup.html.tree.BaseTree;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.image.Image;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.resource.PackageResourceReference;
import org.apache.wicket.request.resource.ResourceReference;

public class LabelIconPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private static final ResourceReference RESOURCE_FOLDER_OPEN = new PackageResourceReference(LabelIconPanel.class, "res/folder-open.gif");
    private static final ResourceReference RESOURCE_FOLDER_CLOSED = new PackageResourceReference(LabelIconPanel.class, "res/folder-closed.gif");
    private static final ResourceReference RESOURCE_ITEM = new PackageResourceReference(LabelIconPanel.class, "res/item.gif");

    public LabelIconPanel(String id, IModel<Object> model, BaseTree tree) {
        super(id, model);
        this.addComponents(model, tree);
    }

    protected void addComponents(IModel<Object> model, BaseTree tree) {
        this.add(new Component[]{this.newImageComponent("icon", tree, model)});
        this.add(new Component[]{this.newContentComponent("content", tree, model)});
    }

    protected Component newImageComponent(String componentId, final BaseTree tree, final IModel<Object> model) {
        return new Image(componentId){
            private static final long serialVersionUID = 1L;

            protected ResourceReference getImageResourceReference() {
                return LabelIconPanel.this.getImageResourceReference(tree, model.getObject());
            }

            protected boolean shouldAddAntiCacheParameter() {
                return false;
            }
        };
    }

    protected Component newContentComponent(String componentId, BaseTree tree, IModel<?> model) {
        return new Label(componentId, model);
    }

    protected ResourceReference getImageResourceReference(BaseTree tree, Object node) {
        TreeModel model = (TreeModel)tree.getDefaultModelObject();
        if (model.isLeaf(node)) {
            return this.getResourceItemLeaf(node);
        }
        if (tree.getTreeState().isNodeExpanded(node)) {
            return this.getResourceFolderOpen(node);
        }
        return this.getResourceFolderClosed(node);
    }

    protected IModel<Object> wrapNodeModel(IModel<Object> nodeModel) {
        return nodeModel;
    }

    protected ResourceReference getResourceFolderClosed(Object node) {
        return RESOURCE_FOLDER_CLOSED;
    }

    protected ResourceReference getResourceFolderOpen(Object node) {
        return RESOURCE_FOLDER_OPEN;
    }

    protected ResourceReference getResourceItemLeaf(Object node) {
        return RESOURCE_ITEM;
    }
}

