/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.Principal;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletInputStream;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.wicket.protocol.ws.api.HttpSessionCopy;

public class ServletRequestCopy
implements HttpServletRequest {
    private final String contextPath;
    private final String servletPath;
    private final String pathInfo;
    private final String requestUri;
    private final HttpSessionCopy httpSession;
    private final StringBuffer requestURL;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private final Map<String, String> headers = new HashMap<String, String>();
    private final Map<String, String[]> parameters = new HashMap<String, String[]>();
    private final String method;
    private final String serverName;
    private final int serverPort;

    public ServletRequestCopy(HttpServletRequest request) {
        String s;
        this.servletPath = request.getServletPath();
        this.contextPath = request.getContextPath();
        this.pathInfo = request.getPathInfo();
        this.requestUri = request.getRequestURI();
        this.requestURL = request.getRequestURL();
        this.method = request.getMethod();
        this.serverName = request.getServerName();
        this.serverPort = request.getServerPort();
        HttpSession session = request.getSession(true);
        this.httpSession = new HttpSessionCopy(session);
        Enumeration e = request.getHeaderNames();
        while (e != null && e.hasMoreElements()) {
            s = (String)e.nextElement();
            this.headers.put(s, request.getHeader(s));
        }
        e = request.getAttributeNames();
        while (e != null && e.hasMoreElements()) {
            s = (String)e.nextElement();
            this.attributes.put(s, request.getAttribute(s));
        }
        e = request.getParameterNames();
        while (e != null && e.hasMoreElements()) {
            s = (String)e.nextElement();
            this.parameters.put(s, request.getParameterValues(s));
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public int getServerPort() {
        return this.serverPort;
    }

    public BufferedReader getReader() throws IOException {
        return null;
    }

    public String getRemoteAddr() {
        return null;
    }

    public String getRemoteHost() {
        return null;
    }

    public HttpSession getSession(boolean create) {
        return this.httpSession;
    }

    public String getMethod() {
        return this.method;
    }

    public String getAuthType() {
        return null;
    }

    public Cookie[] getCookies() {
        return new Cookie[0];
    }

    public long getDateHeader(String name) {
        return 0L;
    }

    public String getHeader(String name) {
        return this.headers.get(name);
    }

    public Enumeration<String> getHeaders(final String name) {
        return new Enumeration<String>(){
            boolean hasNext = true;

            @Override
            public boolean hasMoreElements() {
                return this.hasNext && ServletRequestCopy.this.headers.get(name) != null;
            }

            @Override
            public String nextElement() {
                this.hasNext = false;
                return (String)ServletRequestCopy.this.headers.get(name);
            }
        };
    }

    public Enumeration<String> getParameterNames() {
        return Collections.enumeration(this.parameters.keySet());
    }

    public String getParameter(String name) {
        return this.parameters.get(name) != null ? this.parameters.get(name)[0] : null;
    }

    public String[] getParameterValues(String name) {
        return this.parameters.get(name);
    }

    public Map getParameterMap() {
        return null;
    }

    public String getProtocol() {
        return null;
    }

    public String getScheme() {
        return null;
    }

    public Enumeration<String> getHeaderNames() {
        return Collections.enumeration(this.headers.keySet());
    }

    public int getIntHeader(String name) {
        return 0;
    }

    public Object getAttribute(String name) {
        return this.attributes.get(name);
    }

    public Enumeration<String> getAttributeNames() {
        return Collections.enumeration(this.attributes.keySet());
    }

    public String getCharacterEncoding() {
        return null;
    }

    public void setCharacterEncoding(String env) throws UnsupportedEncodingException {
    }

    public int getContentLength() {
        return 0;
    }

    public String getContentType() {
        return null;
    }

    public ServletInputStream getInputStream() throws IOException {
        return null;
    }

    public void setAttribute(String name, Object o) {
        this.attributes.put(name, o);
    }

    public void removeAttribute(String name) {
        this.attributes.remove(name);
    }

    public Locale getLocale() {
        return null;
    }

    public Enumeration getLocales() {
        return null;
    }

    public boolean isSecure() {
        return false;
    }

    public RequestDispatcher getRequestDispatcher(String path) {
        return null;
    }

    public String getRealPath(String path) {
        return null;
    }

    public int getRemotePort() {
        return 0;
    }

    public String getLocalName() {
        return null;
    }

    public String getLocalAddr() {
        return null;
    }

    public int getLocalPort() {
        return 0;
    }

    public String getContextPath() {
        return this.contextPath;
    }

    public String getQueryString() {
        return null;
    }

    public String getRemoteUser() {
        return null;
    }

    public boolean isUserInRole(String role) {
        return false;
    }

    public Principal getUserPrincipal() {
        return null;
    }

    public String getRequestedSessionId() {
        return null;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public String getPathInfo() {
        return this.pathInfo;
    }

    public String getPathTranslated() {
        return null;
    }

    public String getRequestURI() {
        return this.requestUri;
    }

    public HttpSession getSession() {
        return this.httpSession;
    }

    public boolean isRequestedSessionIdValid() {
        return false;
    }

    public boolean isRequestedSessionIdFromCookie() {
        return false;
    }

    public boolean isRequestedSessionIdFromURL() {
        return false;
    }

    public boolean isRequestedSessionIdFromUrl() {
        return false;
    }

    public StringBuffer getRequestURL() {
        return this.requestURL;
    }
}

