/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.protocol.ws.api;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import org.apache.wicket.protocol.http.RequestUtils;
import org.apache.wicket.protocol.http.servlet.ServletWebRequest;
import org.apache.wicket.request.Url;
import org.apache.wicket.util.lang.Generics;
import org.apache.wicket.util.time.Time;

public class WebSocketRequest
extends ServletWebRequest {
    public WebSocketRequest(HttpServletRequest req, String filterPrefix) {
        super(req, filterPrefix);
    }

    public List<Cookie> getCookies() {
        List<Cookie> cookies = Arrays.asList(this.getContainerRequest().getCookies());
        return cookies;
    }

    public List<String> getHeaders(String name) {
        Enumeration headers = this.getContainerRequest().getHeaders(name);
        ArrayList h = Generics.newArrayList();
        while (headers.hasMoreElements()) {
            h.add(headers.nextElement());
        }
        return h;
    }

    public String getHeader(String name) {
        return this.getContainerRequest().getHeader(name);
    }

    public Time getDateHeader(String name) {
        long dateHeader = this.getContainerRequest().getDateHeader(name);
        return Time.millis((long)dateHeader);
    }

    public Url getUrl() {
        return null;
    }

    public Url getClientUrl() {
        return null;
    }

    public Locale getLocale() {
        return this.getContainerRequest().getLocale();
    }

    public Charset getCharset() {
        return RequestUtils.getCharset((HttpServletRequest)this.getContainerRequest());
    }

    public boolean isAjax() {
        return true;
    }
}

