/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.request.mapper;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import org.apache.wicket.request.IRequestHandler;
import org.apache.wicket.request.IRequestMapper;
import org.apache.wicket.request.Request;
import org.apache.wicket.request.Url;
import org.apache.wicket.request.mapper.ICompoundRequestMapper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CompoundRequestMapper
implements ICompoundRequestMapper {
    private final List<IRequestMapper> mappers = new CopyOnWriteArrayList<IRequestMapper>();

    @Override
    public CompoundRequestMapper add(IRequestMapper encoder) {
        this.mappers.add(0, encoder);
        return this;
    }

    @Override
    public CompoundRequestMapper remove(IRequestMapper encoder) {
        this.mappers.remove(encoder);
        return this;
    }

    @Override
    public IRequestHandler mapRequest(Request request) {
        ArrayList<EncoderWithSegmentsCount> list = new ArrayList<EncoderWithSegmentsCount>(this.mappers.size());
        for (IRequestMapper iRequestMapper : this.mappers) {
            list.add(new EncoderWithSegmentsCount(iRequestMapper, iRequestMapper.getCompatibilityScore(request)));
        }
        Collections.sort(list);
        for (EncoderWithSegmentsCount encoderWithSegmentsCount : list) {
            IRequestHandler handler = encoderWithSegmentsCount.getMapper().mapRequest(request);
            if (handler == null) continue;
            return handler;
        }
        return null;
    }

    @Override
    public Url mapHandler(IRequestHandler handler) {
        for (IRequestMapper encoder : this.mappers) {
            Url url = encoder.mapHandler(handler);
            if (url == null) continue;
            return url;
        }
        return null;
    }

    @Override
    public int getCompatibilityScore(Request request) {
        int score = Integer.MIN_VALUE;
        for (IRequestMapper mapper : this.mappers) {
            score = Math.max(score, mapper.getCompatibilityScore(request));
        }
        return score;
    }

    @Override
    public Iterator<IRequestMapper> iterator() {
        return this.mappers.iterator();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class EncoderWithSegmentsCount
    implements Comparable<EncoderWithSegmentsCount> {
        private final IRequestMapper mapper;
        private final int compatibilityScore;

        public EncoderWithSegmentsCount(IRequestMapper encoder, int compatibilityScore) {
            this.mapper = encoder;
            this.compatibilityScore = compatibilityScore;
        }

        @Override
        public int compareTo(EncoderWithSegmentsCount o) {
            return o.compatibilityScore - this.compatibilityScore;
        }

        public IRequestMapper getMapper() {
            return this.mapper;
        }

        public String toString() {
            return "Mapper: " + this.mapper.getClass().getName() + "; Score: " + this.compatibilityScore;
        }
    }
}

