/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wicket.util.convert.converter;

import java.math.BigDecimal;
import java.util.Locale;
import org.apache.wicket.util.convert.IConverter;
import org.apache.wicket.util.convert.converter.AbstractDecimalConverter;

public class DoubleConverter
extends AbstractDecimalConverter<Double> {
    private static final long serialVersionUID = 1L;
    private static final BigDecimal MIN_VALUE = new BigDecimal(-1.7976931348623157E308);
    private static final BigDecimal MAX_VALUE = new BigDecimal(Double.MAX_VALUE);
    public static final IConverter<Double> INSTANCE = new DoubleConverter();

    @Override
    public Double convertToObject(String value, Locale locale) {
        BigDecimal number = this.parse(value, MIN_VALUE, MAX_VALUE, locale);
        if (number == null) {
            return null;
        }
        return number.doubleValue();
    }

    @Override
    protected Class<Double> getTargetType() {
        return Double.class;
    }
}

