/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.Writer;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.apache.axiom.util.stax.XMLEventUtils;
import org.apache.axiom.util.stax.dialect.StAXDialect;
import org.apache.axiom.util.stax.dialect.StAXDialectDetector;
import org.apache.axiom.util.stax.wrapper.ImmutableXMLInputFactory;
import org.apache.axiom.util.stax.wrapper.ImmutableXMLOutputFactory;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class StAXUtils {
    private static Log log = LogFactory.getLog((Class)(class$org$apache$axiom$om$util$StAXUtils == null ? (class$org$apache$axiom$om$util$StAXUtils = StAXUtils.class$("org.apache.axiom.om.util.StAXUtils")) : class$org$apache$axiom$om$util$StAXUtils));
    private static boolean isDebugEnabled = log.isDebugEnabled();
    private static boolean isFactoryPerClassLoader = true;
    private static final Map inputFactoryMap = Collections.synchronizedMap(new WeakHashMap());
    private static XMLOutputFactory outputFactory = null;
    private static final Map inputFactoryPerCLMap = Collections.synchronizedMap(new WeakHashMap());
    private static Map outputFactoryPerCL = Collections.synchronizedMap(new WeakHashMap());
    static /* synthetic */ Class class$org$apache$axiom$om$util$StAXUtils;
    static /* synthetic */ Class class$javax$xml$stream$XMLInputFactory;
    static /* synthetic */ Class class$javax$xml$stream$XMLOutputFactory;

    public static XMLInputFactory getXMLInputFactory() {
        return StAXUtils.getXMLInputFactory(null, isFactoryPerClassLoader);
    }

    public static XMLInputFactory getXMLInputFactory(StAXParserConfiguration configuration) {
        return StAXUtils.getXMLInputFactory(configuration, isFactoryPerClassLoader);
    }

    public static XMLInputFactory getXMLInputFactory(boolean factoryPerClassLoaderPolicy) {
        return StAXUtils.getXMLInputFactory(null, factoryPerClassLoaderPolicy);
    }

    public static XMLInputFactory getXMLInputFactory(StAXParserConfiguration configuration, boolean factoryPerClassLoaderPolicy) {
        if (factoryPerClassLoaderPolicy) {
            return StAXUtils.getXMLInputFactory_perClassLoader(configuration);
        }
        return StAXUtils.getXMLInputFactory_singleton(configuration);
    }

    public static void releaseXMLInputFactory(XMLInputFactory factory) {
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in, String encoding) throws XMLStreamException {
        return StAXUtils.createXMLStreamReader(null, in, encoding);
    }

    public static XMLStreamReader createXMLStreamReader(StAXParserConfiguration configuration, final InputStream in, final String encoding) throws XMLStreamException {
        final XMLInputFactory inputFactory = StAXUtils.getXMLInputFactory(configuration);
        try {
            XMLStreamReader reader = (XMLStreamReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws XMLStreamException {
                    return inputFactory.createXMLStreamReader(in, encoding);
                }
            });
            if (isDebugEnabled) {
                log.debug((Object)("XMLStreamReader is " + reader.getClass().getName()));
            }
            return reader;
        }
        catch (PrivilegedActionException pae) {
            throw (XMLStreamException)pae.getException();
        }
    }

    public static XMLStreamReader createXMLStreamReader(InputStream in) throws XMLStreamException {
        return StAXUtils.createXMLStreamReader(null, in);
    }

    public static XMLStreamReader createXMLStreamReader(StAXParserConfiguration configuration, final InputStream in) throws XMLStreamException {
        final XMLInputFactory inputFactory = StAXUtils.getXMLInputFactory(configuration);
        try {
            XMLStreamReader reader = (XMLStreamReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws XMLStreamException {
                    return inputFactory.createXMLStreamReader(in);
                }
            });
            if (isDebugEnabled) {
                log.debug((Object)("XMLStreamReader is " + reader.getClass().getName()));
            }
            return reader;
        }
        catch (PrivilegedActionException pae) {
            throw (XMLStreamException)pae.getException();
        }
    }

    public static XMLStreamReader createXMLStreamReader(Reader in) throws XMLStreamException {
        return StAXUtils.createXMLStreamReader(null, in);
    }

    public static XMLStreamReader createXMLStreamReader(StAXParserConfiguration configuration, final Reader in) throws XMLStreamException {
        final XMLInputFactory inputFactory = StAXUtils.getXMLInputFactory(configuration);
        try {
            XMLStreamReader reader = (XMLStreamReader)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws XMLStreamException {
                    return inputFactory.createXMLStreamReader(in);
                }
            });
            if (isDebugEnabled) {
                log.debug((Object)("XMLStreamReader is " + reader.getClass().getName()));
            }
            return reader;
        }
        catch (PrivilegedActionException pae) {
            throw (XMLStreamException)pae.getException();
        }
    }

    public static XMLOutputFactory getXMLOutputFactory() {
        if (isFactoryPerClassLoader) {
            return StAXUtils.getXMLOutputFactory_perClassLoader();
        }
        return StAXUtils.getXMLOutputFactory_singleton();
    }

    public static XMLOutputFactory getXMLOutputFactory(boolean factoryPerClassLoaderPolicy) {
        if (factoryPerClassLoaderPolicy) {
            return StAXUtils.getXMLOutputFactory_perClassLoader();
        }
        return StAXUtils.getXMLOutputFactory_singleton();
    }

    public static void setFactoryPerClassLoader(boolean value) {
        isFactoryPerClassLoader = value;
    }

    public static void releaseXMLOutputFactory(XMLOutputFactory factory) {
    }

    public static XMLStreamWriter createXMLStreamWriter(final OutputStream out) throws XMLStreamException {
        final XMLOutputFactory outputFactory = StAXUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter writer = (XMLStreamWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws XMLStreamException {
                    return outputFactory.createXMLStreamWriter(out, "utf-8");
                }
            });
            if (isDebugEnabled) {
                log.debug((Object)("XMLStreamWriter is " + writer.getClass().getName()));
            }
            return writer;
        }
        catch (PrivilegedActionException pae) {
            throw (XMLStreamException)pae.getException();
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(final OutputStream out, final String encoding) throws XMLStreamException {
        final XMLOutputFactory outputFactory = StAXUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter writer = (XMLStreamWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws XMLStreamException {
                    return outputFactory.createXMLStreamWriter(out, encoding);
                }
            });
            if (isDebugEnabled) {
                log.debug((Object)("XMLStreamWriter is " + writer.getClass().getName()));
            }
            return writer;
        }
        catch (PrivilegedActionException pae) {
            throw (XMLStreamException)pae.getException();
        }
    }

    public static XMLStreamWriter createXMLStreamWriter(final Writer out) throws XMLStreamException {
        final XMLOutputFactory outputFactory = StAXUtils.getXMLOutputFactory();
        try {
            XMLStreamWriter writer = (XMLStreamWriter)AccessController.doPrivileged(new PrivilegedExceptionAction(){

                public Object run() throws XMLStreamException {
                    return outputFactory.createXMLStreamWriter(out);
                }
            });
            if (isDebugEnabled) {
                log.debug((Object)("XMLStreamWriter is " + writer.getClass().getName()));
            }
            return writer;
        }
        catch (PrivilegedActionException pae) {
            throw (XMLStreamException)pae.getException();
        }
    }

    public static void reset() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static Map loadFactoryProperties(String name) {
        ClassLoader cl = StAXUtils.getContextClassLoader();
        InputStream in = cl.getResourceAsStream(name);
        if (in == null) {
            return null;
        }
        try {
            Properties rawProps = new Properties();
            HashMap<Object, Boolean> props = new HashMap<Object, Boolean>();
            rawProps.load(in);
            Object it = rawProps.entrySet().iterator();
            while (it.hasNext()) {
                Object value;
                Map.Entry<Object, Object> entry = it.next();
                String strValue = (String)entry.getValue();
                if (strValue.equals("true")) {
                    value = Boolean.TRUE;
                } else if (strValue.equals("false")) {
                    value = Boolean.FALSE;
                } else {
                    try {
                        value = Integer.valueOf(strValue);
                    }
                    catch (NumberFormatException ex) {
                        value = strValue;
                    }
                }
                props.put(entry.getKey(), (Boolean)value);
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Loaded factory properties from " + name + ": " + props));
            }
            it = props;
            return it;
        }
        catch (IOException ex) {
            log.error((Object)("Failed to read " + name), (Throwable)ex);
            Map map = null;
            return map;
        }
        finally {
            try {
                in.close();
            }
            catch (IOException ex) {}
        }
    }

    private static XMLInputFactory newXMLInputFactory(final ClassLoader classLoader, final StAXParserConfiguration configuration) {
        return (XMLInputFactory)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ClassLoader savedClassLoader;
                if (classLoader == null) {
                    savedClassLoader = null;
                } else {
                    savedClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                try {
                    XMLInputFactory factory = XMLInputFactory.newInstance();
                    factory.setProperty("javax.xml.stream.isCoalescing", Boolean.TRUE);
                    Map props = StAXUtils.loadFactoryProperties("XMLInputFactory.properties");
                    if (props != null) {
                        Iterator it = props.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            factory.setProperty((String)entry.getKey(), entry.getValue());
                        }
                    }
                    StAXDialect dialect = StAXDialectDetector.getDialect(factory.getClass());
                    if (configuration != null) {
                        factory = configuration.configure(factory, dialect);
                    }
                    ImmutableXMLInputFactory immutableXMLInputFactory = new ImmutableXMLInputFactory(dialect.normalize(dialect.makeThreadSafe(factory)));
                    return immutableXMLInputFactory;
                }
                finally {
                    if (savedClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(savedClassLoader);
                    }
                }
            }
        });
    }

    private static XMLInputFactory getXMLInputFactory_perClassLoader(StAXParserConfiguration configuration) {
        XMLInputFactory factory;
        ClassLoader cl = StAXUtils.getContextClassLoader();
        if (cl == null) {
            factory = StAXUtils.getXMLInputFactory_singleton(configuration);
        } else {
            Map<ClassLoader, XMLInputFactory> map;
            if (configuration == null) {
                configuration = StAXParserConfiguration.DEFAULT;
            }
            if ((map = (Map<ClassLoader, XMLInputFactory>)inputFactoryPerCLMap.get(configuration)) == null) {
                map = Collections.synchronizedMap(new WeakHashMap());
                inputFactoryPerCLMap.put(configuration, map);
                factory = null;
            } else {
                factory = (XMLInputFactory)map.get(cl);
            }
            if (factory == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("About to create XMLInputFactory implementation with classloader=" + cl));
                    log.debug((Object)("The classloader for javax.xml.stream.XMLInputFactory is: " + (class$javax$xml$stream$XMLInputFactory == null ? (class$javax$xml$stream$XMLInputFactory = StAXUtils.class$("javax.xml.stream.XMLInputFactory")) : class$javax$xml$stream$XMLInputFactory).getClassLoader()));
                }
                factory = null;
                try {
                    factory = StAXUtils.newXMLInputFactory(null, configuration);
                }
                catch (ClassCastException cce) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed creation of XMLInputFactory implementation with classloader=" + cl));
                        log.debug((Object)("Exception is=" + cce));
                        log.debug((Object)("Attempting with classloader: " + (class$javax$xml$stream$XMLInputFactory == null ? (class$javax$xml$stream$XMLInputFactory = StAXUtils.class$("javax.xml.stream.XMLInputFactory")) : class$javax$xml$stream$XMLInputFactory).getClassLoader()));
                    }
                    factory = StAXUtils.newXMLInputFactory((class$javax$xml$stream$XMLInputFactory == null ? (class$javax$xml$stream$XMLInputFactory = StAXUtils.class$("javax.xml.stream.XMLInputFactory")) : class$javax$xml$stream$XMLInputFactory).getClassLoader(), configuration);
                }
                if (factory != null) {
                    map.put(cl, factory);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Created XMLInputFactory = " + factory.getClass() + " with classloader=" + cl));
                        log.debug((Object)("Configuration = " + configuration));
                        log.debug((Object)("Size of XMLInputFactory map for this configuration = " + map.size()));
                        log.debug((Object)("Configurations for which factories have been cached = " + inputFactoryPerCLMap.keySet()));
                    }
                } else {
                    factory = StAXUtils.getXMLInputFactory_singleton(configuration);
                }
            }
        }
        return factory;
    }

    private static XMLInputFactory getXMLInputFactory_singleton(StAXParserConfiguration configuration) {
        XMLInputFactory f;
        if (configuration == null) {
            configuration = StAXParserConfiguration.DEFAULT;
        }
        if ((f = (XMLInputFactory)inputFactoryMap.get(configuration)) == null) {
            f = StAXUtils.newXMLInputFactory((class$org$apache$axiom$om$util$StAXUtils == null ? (class$org$apache$axiom$om$util$StAXUtils = StAXUtils.class$("org.apache.axiom.om.util.StAXUtils")) : class$org$apache$axiom$om$util$StAXUtils).getClassLoader(), configuration);
            inputFactoryMap.put(configuration, f);
            if (log.isDebugEnabled() && f != null) {
                log.debug((Object)("Created singleton XMLInputFactory " + f.getClass() + " with configuration " + configuration));
            }
        }
        return f;
    }

    private static XMLOutputFactory newXMLOutputFactory(final ClassLoader classLoader) {
        return (XMLOutputFactory)AccessController.doPrivileged(new PrivilegedAction(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public Object run() {
                ClassLoader savedClassLoader;
                if (classLoader == null) {
                    savedClassLoader = null;
                } else {
                    savedClassLoader = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(classLoader);
                }
                try {
                    XMLOutputFactory factory = XMLOutputFactory.newInstance();
                    factory.setProperty("javax.xml.stream.isRepairingNamespaces", Boolean.FALSE);
                    Map props = StAXUtils.loadFactoryProperties("XMLOutputFactory.properties");
                    if (props != null) {
                        Iterator it = props.entrySet().iterator();
                        while (it.hasNext()) {
                            Map.Entry entry = it.next();
                            factory.setProperty((String)entry.getKey(), entry.getValue());
                        }
                    }
                    StAXDialect dialect = StAXDialectDetector.getDialect(factory.getClass());
                    ImmutableXMLOutputFactory immutableXMLOutputFactory = new ImmutableXMLOutputFactory(dialect.normalize(dialect.makeThreadSafe(factory)));
                    return immutableXMLOutputFactory;
                }
                finally {
                    if (savedClassLoader != null) {
                        Thread.currentThread().setContextClassLoader(savedClassLoader);
                    }
                }
            }
        });
    }

    public static XMLOutputFactory getXMLOutputFactory_perClassLoader() {
        XMLOutputFactory factory;
        ClassLoader cl = StAXUtils.getContextClassLoader();
        if (cl == null) {
            factory = StAXUtils.getXMLOutputFactory_singleton();
        } else {
            factory = (XMLOutputFactory)outputFactoryPerCL.get(cl);
            if (factory == null) {
                if (log.isDebugEnabled()) {
                    log.debug((Object)("About to create XMLOutputFactory implementation with classloader=" + cl));
                    log.debug((Object)("The classloader for javax.xml.stream.XMLOutputFactory is: " + (class$javax$xml$stream$XMLOutputFactory == null ? (class$javax$xml$stream$XMLOutputFactory = StAXUtils.class$("javax.xml.stream.XMLOutputFactory")) : class$javax$xml$stream$XMLOutputFactory).getClassLoader()));
                }
                try {
                    factory = StAXUtils.newXMLOutputFactory(null);
                }
                catch (ClassCastException cce) {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Failed creation of XMLOutputFactory implementation with classloader=" + cl));
                        log.debug((Object)("Exception is=" + cce));
                        log.debug((Object)("Attempting with classloader: " + (class$javax$xml$stream$XMLOutputFactory == null ? (class$javax$xml$stream$XMLOutputFactory = StAXUtils.class$("javax.xml.stream.XMLOutputFactory")) : class$javax$xml$stream$XMLOutputFactory).getClassLoader()));
                    }
                    factory = StAXUtils.newXMLOutputFactory((class$javax$xml$stream$XMLOutputFactory == null ? (class$javax$xml$stream$XMLOutputFactory = StAXUtils.class$("javax.xml.stream.XMLOutputFactory")) : class$javax$xml$stream$XMLOutputFactory).getClassLoader());
                }
                if (factory != null) {
                    outputFactoryPerCL.put(cl, factory);
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("Created XMLOutputFactory = " + factory.getClass() + " for classloader=" + cl));
                        log.debug((Object)("Size of XMLOutputFactory map =" + outputFactoryPerCL.size()));
                    }
                } else {
                    factory = StAXUtils.getXMLOutputFactory_singleton();
                }
            }
        }
        return factory;
    }

    public static XMLOutputFactory getXMLOutputFactory_singleton() {
        if (outputFactory == null) {
            outputFactory = StAXUtils.newXMLOutputFactory((class$org$apache$axiom$om$util$StAXUtils == null ? (class$org$apache$axiom$om$util$StAXUtils = StAXUtils.class$("org.apache.axiom.om.util.StAXUtils")) : class$org$apache$axiom$om$util$StAXUtils).getClassLoader());
            if (log.isDebugEnabled() && outputFactory != null) {
                log.debug((Object)("Created singleton XMLOutputFactory = " + outputFactory.getClass()));
            }
        }
        return outputFactory;
    }

    private static ClassLoader getContextClassLoader() {
        ClassLoader cl = (ClassLoader)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
        return cl;
    }

    public static XMLStreamReader createNetworkDetachedXMLStreamReader(InputStream in, String encoding) throws XMLStreamException {
        return StAXUtils.createXMLStreamReader(StAXParserConfiguration.STANDALONE, in, encoding);
    }

    public static XMLInputFactory getNetworkDetachedXMLInputFactory() {
        return StAXUtils.getXMLInputFactory(StAXParserConfiguration.STANDALONE);
    }

    public static XMLStreamReader createNetworkDetachedXMLStreamReader(InputStream in) throws XMLStreamException {
        return StAXUtils.createXMLStreamReader(StAXParserConfiguration.STANDALONE, in);
    }

    public static XMLStreamReader createNetworkDetachedXMLStreamReader(Reader in) throws XMLStreamException {
        return StAXUtils.createXMLStreamReader(StAXParserConfiguration.STANDALONE, in);
    }

    public static String getEventTypeString(int event) {
        return XMLEventUtils.getEventTypeString(event);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

