/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.util.namespace;

import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import org.apache.axiom.util.namespace.AbstractNamespaceContext;

public class MapBasedNamespaceContext
extends AbstractNamespaceContext {
    private final Map<String, String> namespaces;

    public MapBasedNamespaceContext(Map<String, String> map) {
        this.namespaces = map;
    }

    @Override
    protected String doGetNamespaceURI(String prefix) {
        String namespaceURI = this.namespaces.get(prefix);
        return namespaceURI == null ? "" : namespaceURI;
    }

    @Override
    protected String doGetPrefix(String nsURI) {
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            String uri = entry.getValue();
            if (!uri.equals(nsURI)) continue;
            return entry.getKey();
        }
        if (nsURI.length() == 0) {
            return "";
        }
        return null;
    }

    @Override
    protected Iterator<String> doGetPrefixes(String nsURI) {
        HashSet<String> prefixes = null;
        for (Map.Entry<String, String> entry : this.namespaces.entrySet()) {
            String uri = entry.getValue();
            if (!uri.equals(nsURI)) continue;
            if (prefixes == null) {
                prefixes = new HashSet<String>();
            }
            prefixes.add(entry.getKey());
        }
        if (prefixes != null) {
            return Collections.unmodifiableSet(prefixes).iterator();
        }
        if (nsURI.length() == 0) {
            return Collections.singleton("").iterator();
        }
        return Collections.emptyList().iterator();
    }
}

