/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.dom;

import javax.xml.namespace.QName;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMCloneOptions;
import org.apache.axiom.om.OMDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.common.OMNamespaceImpl;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.ParentNode;
import org.apache.axiom.soap.SOAPCloneOptions;
import org.apache.axiom.soap.SOAPHeaderBlock;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.impl.common.SOAPHelper;

public abstract class SOAPHeaderBlockImpl
extends ElementImpl
implements SOAPHeaderBlock {
    private boolean processed = false;

    public SOAPHeaderBlockImpl(ParentNode parentNode, String localName, OMNamespace ns, OMXMLParserWrapper builder, OMFactory factory, boolean generateNSDecl) {
        super(parentNode, localName, ns, builder, factory, generateNSDecl);
    }

    protected void setAttribute(String attributeName, String attrValue, String soapEnvelopeNamespaceURI) {
        OMAttribute omAttribute = this.getAttribute(new QName(soapEnvelopeNamespaceURI, attributeName));
        if (omAttribute != null) {
            omAttribute.setAttributeValue(attrValue);
        } else {
            AttrImpl attribute = new AttrImpl((DocumentImpl)this.getOwnerDocument(), attributeName, new OMNamespaceImpl(soapEnvelopeNamespaceURI, "soapenv"), attrValue, this.getOMFactory());
            this.addAttribute(attribute);
        }
    }

    protected String getAttribute(String attrName, String soapEnvelopeNamespaceURI) {
        OMAttribute omAttribute = this.getAttribute(new QName(soapEnvelopeNamespaceURI, attrName));
        return omAttribute != null ? omAttribute.getAttributeValue() : null;
    }

    public boolean isProcessed() {
        return this.processed;
    }

    public void setProcessed() {
        this.processed = true;
    }

    public OMDataSource getDataSource() {
        throw new UnsupportedOperationException();
    }

    public boolean isExpanded() {
        return true;
    }

    public OMDataSource setDataSource(OMDataSource dataSource) {
        throw new UnsupportedOperationException();
    }

    public Object getObject(Class dataSourceClass) {
        throw new UnsupportedOperationException();
    }

    protected abstract void checkParent(OMElement var1) throws SOAPProcessingException;

    protected final void copyData(OMCloneOptions options, SOAPHeaderBlock targetSHB) {
        Boolean processedFlag;
        Boolean bl = processedFlag = options instanceof SOAPCloneOptions ? ((SOAPCloneOptions)options).getProcessedFlag() : null;
        if (processedFlag == null && this.isProcessed() || processedFlag != null && processedFlag.booleanValue()) {
            targetSHB.setProcessed();
        }
    }

    protected abstract SOAPHelper getSOAPHelper();

    public final void setMustUnderstand(String mustUnderstand) throws SOAPProcessingException {
        Boolean value = this.getSOAPHelper().parseBoolean(mustUnderstand);
        if (value == null) {
            throw new SOAPProcessingException("Invalid value for mustUnderstand attribute");
        }
        this.setAttribute("mustUnderstand", mustUnderstand, this.getVersion().getEnvelopeURI());
    }

    public final boolean getMustUnderstand() throws SOAPProcessingException {
        String mustUnderstand = this.getAttribute("mustUnderstand", this.getVersion().getEnvelopeURI());
        if (mustUnderstand != null) {
            Boolean value = this.getSOAPHelper().parseBoolean(mustUnderstand);
            if (value != null) {
                return value;
            }
            throw new SOAPProcessingException("Invalid value found in mustUnderstand value of " + this.getLocalName() + " header block");
        }
        return false;
    }
}

