/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom;

import java.util.Vector;
import org.apache.axiom.dom.DOMExceptionUtil;
import org.apache.axiom.om.impl.common.AxiomNamedInformationItemSupport;
import org.apache.axiom.om.impl.dom.AttrImpl;
import org.apache.axiom.om.impl.dom.ElementImpl;
import org.apache.axiom.om.impl.dom.NodeImpl;
import org.w3c.dom.DOMException;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;

public class AttributeMap
implements NamedNodeMap {
    private Vector nodes;
    private ElementImpl ownerNode;

    AttributeMap(ElementImpl ownerNode) {
        this.ownerNode = ownerNode;
    }

    public Node getNamedItem(String name) {
        int i = this.findNamePoint(name, 0);
        return i < 0 ? null : (Node)this.nodes.elementAt(i);
    }

    public Node item(int index) {
        return this.nodes != null && index < this.nodes.size() ? (Node)this.nodes.elementAt(index) : null;
    }

    public int getLength() {
        return this.nodes != null ? this.nodes.size() : 0;
    }

    public Node getNamedItemNS(String namespaceURI, String localName) {
        int i = this.findNamePoint(namespaceURI, localName);
        return i < 0 ? null : (Node)this.nodes.elementAt(i);
    }

    public Node removeNamedItem(String name) throws DOMException {
        int i = this.findNamePoint(name, 0);
        if (i < 0) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        NodeImpl n = (NodeImpl)this.nodes.elementAt(i);
        this.nodes.removeElementAt(i);
        return n;
    }

    public Node removeNamedItemNS(String namespaceURI, String name) throws DOMException {
        int i = this.findNamePoint(namespaceURI, name);
        if (i < 0) {
            throw DOMExceptionUtil.newDOMException((short)8);
        }
        NodeImpl n = (NodeImpl)this.nodes.elementAt(i);
        this.nodes.removeElementAt(i);
        return n;
    }

    public Node setNamedItem(Node attribute) throws DOMException {
        this.ownerNode.checkSameOwnerDocument(attribute);
        if (attribute.getNodeType() != 2) {
            throw DOMExceptionUtil.newDOMException((short)3);
        }
        AttrImpl attr = (AttrImpl)attribute;
        if (attr.getOwnerElement() != null) {
            if (attr.getOwnerElement() != this.ownerNode) {
                throw DOMExceptionUtil.newDOMException((short)10);
            }
            return attr;
        }
        attr.setOwnerElement(this.ownerNode, true);
        int i = this.findNamePoint(attr.getNodeName(), 0);
        AttrImpl previous = null;
        if (i >= 0) {
            previous = (AttrImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(attr, i);
            previous.setOwnerElement(null, true);
            previous.setSpecified(true);
        } else {
            i = -1 - i;
            if (this.nodes == null) {
                this.nodes = new Vector(5, 10);
            }
            this.nodes.insertElementAt(attr, i);
        }
        return previous;
    }

    public Node setNamedItemNS(Node attribute) throws DOMException {
        this.ownerNode.checkSameOwnerDocument(attribute);
        return this.setAttribute(attribute, true);
    }

    Node setAttribute(Node attribute, boolean useDomSemantics) throws DOMException {
        if (attribute.getNodeType() != 2) {
            throw DOMExceptionUtil.newDOMException((short)3);
        }
        AttrImpl attr = (AttrImpl)attribute;
        if (attr.getOwnerElement() != null) {
            if (attr.getOwnerElement() != this.ownerNode) {
                throw DOMExceptionUtil.newDOMException((short)10);
            }
            return attr;
        }
        attr.setOwnerElement(this.ownerNode, useDomSemantics);
        int i = this.findNamePoint(attr.getNamespaceURI(), AxiomNamedInformationItemSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomNamedInformationItemSupport$org_apache_axiom_om_impl_common_AxiomNamedInformationItem$getLocalName(attr));
        AttrImpl previous = null;
        if (i >= 0) {
            previous = (AttrImpl)this.nodes.elementAt(i);
            this.nodes.setElementAt(attr, i);
            previous.setOwnerElement(null, useDomSemantics);
            previous.setSpecified(true);
        } else {
            i = this.findNamePoint(attr.getNodeName(), 0);
            if (i >= 0) {
                previous = (AttrImpl)this.nodes.elementAt(i);
                this.nodes.insertElementAt(attr, i);
            } else {
                i = -1 - i;
                if (this.nodes == null) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(attr, i);
            }
        }
        return previous;
    }

    protected int findNamePoint(String name, int start) {
        int i = 0;
        if (this.nodes != null) {
            int first = start;
            int last = this.nodes.size() - 1;
            while (first <= last) {
                i = (first + last) / 2;
                int test = name.compareTo(((Node)this.nodes.elementAt(i)).getNodeName());
                if (test == 0) {
                    return i;
                }
                if (test < 0) {
                    last = i - 1;
                    continue;
                }
                first = i + 1;
            }
            if (first > i) {
                i = first;
            }
        }
        return -1 - i;
    }

    protected int findNamePoint(String namespaceURI, String name) {
        if (this.nodes == null) {
            return -1;
        }
        if (name == null) {
            return -1;
        }
        int i = 0;
        while (i < this.nodes.size()) {
            NodeImpl a = (NodeImpl)this.nodes.elementAt(i);
            String aNamespaceURI = a.getNamespaceURI();
            String aLocalName = a.getLocalName();
            if (namespaceURI == null ? aNamespaceURI == null && (name.equals(aLocalName) || aLocalName == null && name.equals(a.getNodeName())) : namespaceURI.equals(aNamespaceURI) && name.equals(aLocalName)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    protected boolean precedes(Node a, Node b) {
        if (this.nodes != null) {
            int i = 0;
            while (i < this.nodes.size()) {
                Node n = (Node)this.nodes.elementAt(i);
                if (n == a) {
                    return true;
                }
                if (n == b) {
                    return false;
                }
                ++i;
            }
        }
        return false;
    }

    protected void removeItem(int index) {
        if (this.nodes != null && index < this.nodes.size()) {
            this.nodes.removeElementAt(index);
        }
    }

    protected Object getItem(int index) {
        if (this.nodes != null) {
            return this.nodes.elementAt(index);
        }
        return null;
    }

    protected int addItem(Node arg) {
        int i = this.findNamePoint(arg.getNamespaceURI(), arg.getLocalName());
        if (i >= 0) {
            this.nodes.setElementAt(arg, i);
        } else {
            i = this.findNamePoint(arg.getNodeName(), 0);
            if (i >= 0) {
                this.nodes.insertElementAt(arg, i);
            } else {
                i = -1 - i;
                if (this.nodes == null) {
                    this.nodes = new Vector(5, 10);
                }
                this.nodes.insertElementAt(arg, i);
            }
        }
        return i;
    }

    protected Vector cloneMap(Vector list) {
        if (list == null) {
            list = new Vector(5, 10);
        }
        list.setSize(0);
        if (this.nodes != null) {
            int i = 0;
            while (i < this.nodes.size()) {
                list.insertElementAt(this.nodes.elementAt(i), i);
                ++i;
            }
        }
        return list;
    }

    protected int getNamedItemIndex(String namespaceURI, String localName) {
        return this.findNamePoint(namespaceURI, localName);
    }

    public void removeAll() {
        if (this.nodes != null) {
            this.nodes.removeAllElements();
        }
    }

    void remove(AttrImpl attr, boolean useDomSemantics) {
        if (this.nodes.remove(attr)) {
            attr.setOwnerElement(null, useDomSemantics);
        }
    }
}

