/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.dom.jaxp;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.validation.Schema;
import org.apache.axiom.dom.DOMDocument;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.dom.DOMMetaFactory;
import org.apache.axiom.om.impl.dom.DocumentImpl;
import org.apache.axiom.om.impl.dom.factory.DOOMNodeFactory;
import org.apache.axiom.om.util.StAXParserConfiguration;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.xml.sax.EntityResolver;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class DOOMDocumentBuilder
extends DocumentBuilder {
    private final OMFactory factory;
    private final StAXParserConfiguration parserConfiguration;
    private final Schema schema;

    DOOMDocumentBuilder(OMFactory factory, StAXParserConfiguration parserConfiguration, Schema schema) {
        this.factory = factory;
        this.parserConfiguration = parserConfiguration;
        this.schema = schema;
    }

    public boolean isNamespaceAware() {
        return true;
    }

    public boolean isValidating() {
        return true;
    }

    public Schema getSchema() {
        return this.schema;
    }

    public DOMImplementation getDOMImplementation() {
        return ((DOMMetaFactory)this.factory.getMetaFactory()).getDOMImplementation();
    }

    public Document newDocument() {
        return DOOMNodeFactory.INSTANCE.createNode(DOMDocument.class);
    }

    public void setEntityResolver(EntityResolver er) {
    }

    public void setErrorHandler(ErrorHandler eh) {
    }

    public Document parse(InputSource inputSource) throws SAXException, IOException {
        OMXMLParserWrapper builder = this.factory.getMetaFactory().createOMBuilder(this.factory, this.parserConfiguration, inputSource);
        DocumentImpl doc = (DocumentImpl)builder.getDocument();
        doc.close(true);
        return doc;
    }

    public Document parse(InputStream is) throws SAXException, IOException {
        return this.parse(new InputSource(is));
    }

    public Document parse(File file) throws SAXException, IOException {
        FileInputStream in = new FileInputStream(file);
        try {
            Document document = this.parse(in);
            return document;
        }
        finally {
            in.close();
        }
    }

    public Document parse(InputStream is, String systemId) throws SAXException, IOException {
        InputSource inputSource = new InputSource(is);
        inputSource.setSystemId(systemId);
        return this.parse(inputSource);
    }

    public Document parse(String uri) throws SAXException, IOException {
        return this.parse(new InputSource(uri));
    }
}

