/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom;

import org.apache.axiom.core.AttributeMatcher;
import org.apache.axiom.core.ClonePolicy;
import org.apache.axiom.core.CoreAttribute;
import org.apache.axiom.core.CoreDocument;
import org.apache.axiom.core.CoreElement;
import org.apache.axiom.core.CoreNSUnawareAttribute;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNode;
import org.apache.axiom.core.DetachPolicy;
import org.apache.axiom.core.NSAwareAttributeMatcher;
import org.apache.axiom.core.NamespaceDeclarationMatcher;
import org.apache.axiom.core.NodeMigrationPolicy;
import org.apache.axiom.core.NodeType;
import org.apache.axiom.dom.DOMAttribute;

public final class Policies {
    public static final DetachPolicy DETACH_POLICY = new DetachPolicy(){

        public CoreDocument getNewOwnerDocument(CoreParentNode owner) {
            return owner.coreGetOwnerDocument(true);
        }
    };
    public static final AttributeMatcher DOM1_ATTRIBUTE_MATCHER = new AttributeMatcher(){

        public boolean matches(CoreAttribute attr, String namespaceURI, String name) {
            return name.equals(((DOMAttribute)attr).getName());
        }

        public String getNamespaceURI(CoreAttribute attr) {
            return null;
        }

        public String getName(CoreAttribute attr) {
            return ((DOMAttribute)attr).getName();
        }

        public CoreAttribute createAttribute(CoreElement element, String namespaceURI, String name, String prefix, String value) {
            CoreNSUnawareAttribute attr = element.coreCreateNode(CoreNSUnawareAttribute.class);
            attr.coreSetName(name);
            attr.coreSetCharacterData(value, null);
            return attr;
        }

        public void update(CoreAttribute attr, String prefix, String value) {
            attr.coreSetCharacterData(value, DETACH_POLICY);
        }
    };
    public static final AttributeMatcher DOM2_ATTRIBUTE_MATCHER = new NSAwareAttributeMatcher(DETACH_POLICY, true, true);
    public static final AttributeMatcher NAMESPACE_DECLARATION_MATCHER = new NamespaceDeclarationMatcher(DETACH_POLICY);
    public static final NodeMigrationPolicy ATTRIBUTE_MIGRATION_POLICY = new NodeMigrationPolicy(){

        public NodeMigrationPolicy.Action getAction(boolean hasParent, boolean isForeignDocument, boolean isForeignModel) {
            return NodeMigrationPolicy.Action.REJECT;
        }
    };
    public static final NodeMigrationPolicy NODE_MIGRATION_POLICY = new NodeMigrationPolicy(){

        public NodeMigrationPolicy.Action getAction(boolean hasParent, boolean isForeignDocument, boolean isForeignModel) {
            return isForeignDocument ? NodeMigrationPolicy.Action.REJECT : NodeMigrationPolicy.Action.MOVE;
        }
    };
    public static final ClonePolicy<Void> DEEP_CLONE = new ClonePolicy<Void>(){

        @Override
        public Class<? extends CoreNode> getTargetNodeClass(Void options, CoreNode node) {
            return node.coreGetNodeClass();
        }

        @Override
        public boolean repairNamespaces(Void options) {
            return false;
        }

        @Override
        public boolean cloneAttributes(Void options) {
            return true;
        }

        @Override
        public boolean cloneChildren(Void options, NodeType nodeType) {
            return true;
        }

        @Override
        public void postProcess(Void options, CoreNode clone) {
        }
    };
    public static final ClonePolicy<Void> SHALLOW_CLONE = new ClonePolicy<Void>(){

        @Override
        public Class<? extends CoreNode> getTargetNodeClass(Void options, CoreNode node) {
            return node.coreGetNodeClass();
        }

        @Override
        public boolean repairNamespaces(Void options) {
            return false;
        }

        @Override
        public boolean cloneAttributes(Void options) {
            return true;
        }

        @Override
        public boolean cloneChildren(Void options, NodeType nodeType) {
            return nodeType == NodeType.NS_UNAWARE_ATTRIBUTE || nodeType == NodeType.NS_AWARE_ATTRIBUTE;
        }

        @Override
        public void postProcess(Void options, CoreNode clone) {
        }
    };

    private Policies() {
    }
}

