/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.dom;

import java.util.Iterator;
import org.apache.axiom.core.Axis;
import org.apache.axiom.core.ElementMatcher;
import org.apache.axiom.dom.DOMElement;
import org.apache.axiom.dom.DOMExceptionTranslator;
import org.apache.axiom.dom.DOMNSAwareElement;
import org.apache.axiom.dom.DOMParentNode;
import org.apache.axiom.dom.DOMSemantics;
import org.apache.axiom.dom.NodeListImpl;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ElementsByTagNameNS
extends NodeListImpl {
    private final DOMParentNode node;
    private final String namespaceURI;
    private final String localName;

    public ElementsByTagNameNS(DOMParentNode node, String namespaceURI, String localName) {
        this.node = node;
        this.namespaceURI = namespaceURI == null ? "" : namespaceURI;
        this.localName = localName;
    }

    @Override
    protected Iterator<? extends Node> createIterator() {
        boolean nsWildcard = "*".equals(this.namespaceURI);
        boolean localNameWildcard = this.localName.equals("*");
        if (nsWildcard && localNameWildcard) {
            return this.node.coreGetElements(Axis.DESCENDANTS, DOMElement.class, ElementMatcher.ANY, null, null, DOMExceptionTranslator.INSTANCE, DOMSemantics.INSTANCE);
        }
        if (nsWildcard) {
            return this.node.coreGetElements(Axis.DESCENDANTS, DOMNSAwareElement.class, ElementMatcher.BY_LOCAL_NAME, null, this.localName, DOMExceptionTranslator.INSTANCE, DOMSemantics.INSTANCE);
        }
        if (localNameWildcard) {
            return this.node.coreGetElements(Axis.DESCENDANTS, DOMNSAwareElement.class, ElementMatcher.BY_NAMESPACE_URI, this.namespaceURI, null, DOMExceptionTranslator.INSTANCE, DOMSemantics.INSTANCE);
        }
        return this.node.coreGetElements(Axis.DESCENDANTS, DOMNSAwareElement.class, ElementMatcher.BY_QNAME, this.namespaceURI, this.localName, DOMExceptionTranslator.INSTANCE, DOMSemantics.INSTANCE);
    }
}

