/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.om.impl.llom;

import java.io.OutputStream;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.impl.MTOMXMLStreamWriter;
import org.apache.axiom.om.impl.common.AxiomSerializable;
import org.apache.axiom.om.impl.common.AxiomSerializableSupport;
import org.apache.axiom.om.impl.common.serializer.push.OutputException;
import org.apache.axiom.om.impl.common.serializer.push.stax.StAXSerializer;
import org.apache.axiom.om.impl.llom.OMInformationItemImpl;
import org.apache.axiom.om.util.StAXUtils;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public abstract class OMSerializableImpl
extends OMInformationItemImpl
implements AxiomSerializable {
    private static final Log log = LogFactory.getLog(OMSerializableImpl.class);
    private OMFactory factory;

    public OMSerializableImpl(OMFactory factory) {
        this.factory = factory;
    }

    public final OMFactory getOMFactory() {
        if (this.factory == null) {
            this.factory = ((StAXSOAPModelBuilder)this.getBuilder()).getSOAPFactory();
        }
        return this.factory;
    }

    public void serialize(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.serialize(xmlWriter, true);
    }

    public void serializeAndConsume(XMLStreamWriter xmlWriter) throws XMLStreamException {
        this.serialize(xmlWriter, false);
    }

    public void serialize(XMLStreamWriter xmlWriter, boolean cache) throws XMLStreamException {
        MTOMXMLStreamWriter writer = xmlWriter instanceof MTOMXMLStreamWriter ? (MTOMXMLStreamWriter)xmlWriter : new MTOMXMLStreamWriter(xmlWriter);
        try {
            this.internalSerialize(new StAXSerializer(this, (XMLStreamWriter)writer), writer.getOutputFormat(), cache);
        }
        catch (OutputException ex) {
            throw (XMLStreamException)ex.getCause();
        }
        writer.flush();
    }

    public void serialize(OutputStream output) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((OutputStream)output);
        try {
            this.serialize(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    public void serialize(Writer writer) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((Writer)writer);
        try {
            this.serialize(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    public void serializeAndConsume(OutputStream output) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((OutputStream)output);
        try {
            this.serializeAndConsume(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    public void serializeAndConsume(Writer writer) throws XMLStreamException {
        XMLStreamWriter xmlStreamWriter = StAXUtils.createXMLStreamWriter((Writer)writer);
        try {
            this.serializeAndConsume(xmlStreamWriter);
        }
        finally {
            xmlStreamWriter.close();
        }
    }

    public void serialize(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format, true);
        try {
            try {
                this.internalSerialize(new StAXSerializer(this, (XMLStreamWriter)writer), format, true);
            }
            catch (OutputException ex) {
                throw (XMLStreamException)ex.getCause();
            }
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public void serialize(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter((Writer)writer2));
        writer.setOutputFormat(format);
        try {
            try {
                this.internalSerialize(new StAXSerializer(this, (XMLStreamWriter)writer), format, true);
            }
            catch (OutputException ex) {
                throw (XMLStreamException)ex.getCause();
            }
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public void serializeAndConsume(OutputStream output, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(output, format, false);
        try {
            try {
                this.internalSerialize(new StAXSerializer(this, (XMLStreamWriter)writer), format, false);
            }
            catch (OutputException ex) {
                throw (XMLStreamException)ex.getCause();
            }
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public void serializeAndConsume(Writer writer2, OMOutputFormat format) throws XMLStreamException {
        MTOMXMLStreamWriter writer = new MTOMXMLStreamWriter(StAXUtils.createXMLStreamWriter((Writer)writer2));
        writer.setOutputFormat(format);
        try {
            try {
                this.internalSerialize(new StAXSerializer(this, (XMLStreamWriter)writer), format, false);
            }
            catch (OutputException ex) {
                throw (XMLStreamException)ex.getCause();
            }
            writer.flush();
        }
        finally {
            writer.close();
        }
    }

    public void close(boolean bl) {
        AxiomSerializableSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomSerializableSupport$org_apache_axiom_om_impl_common_AxiomSerializable$close(this, bl);
    }
}

