/*
 * Decompiled with CFR 0.152.
 */
package org.apache.axiom.soap.impl.llom;

import javax.xml.namespace.QName;
import org.apache.axiom.core.CoreNode;
import org.apache.axiom.core.CoreParentNodeSupport;
import org.apache.axiom.core.DeferringParentNodeSupport;
import org.apache.axiom.om.OMConstants;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMException;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMOutputFormat;
import org.apache.axiom.om.OMXMLParserWrapper;
import org.apache.axiom.om.impl.builder.StAXBuilder;
import org.apache.axiom.om.impl.common.AxiomContainerSupport;
import org.apache.axiom.om.impl.common.AxiomElementSupport;
import org.apache.axiom.om.impl.common.serializer.push.OutputException;
import org.apache.axiom.om.impl.common.serializer.push.Serializer;
import org.apache.axiom.soap.SOAP12Version;
import org.apache.axiom.soap.SOAPBody;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axiom.soap.SOAPHeader;
import org.apache.axiom.soap.SOAPProcessingException;
import org.apache.axiom.soap.SOAPVersion;
import org.apache.axiom.soap.impl.builder.StAXSOAPModelBuilder;
import org.apache.axiom.soap.impl.common.AxiomSOAPEnvelope;
import org.apache.axiom.soap.impl.common.AxiomSOAPEnvelopeSupport;
import org.apache.axiom.soap.impl.llom.SOAPElement;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SOAPEnvelopeImpl
extends SOAPElement
implements AxiomSOAPEnvelope,
OMConstants {
    private static final Log log = LogFactory.getLog(SOAPEnvelopeImpl.class);

    public SOAPEnvelopeImpl(OMFactory factory) {
        super(factory);
    }

    public SOAPVersion getVersion() {
        return ((SOAPFactory)this.getOMFactory()).getSOAPVersion();
    }

    public SOAPHeader getHeader() {
        OMElement e = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$getFirstElement(this);
        if (e instanceof SOAPHeader) {
            return (SOAPHeader)e;
        }
        return null;
    }

    public SOAPHeader getOrCreateHeader() {
        SOAPHeader header = this.getHeader();
        return header != null ? header : ((SOAPFactory)this.getOMFactory()).createSOAPHeader((SOAPEnvelope)this);
    }

    private void internalCheckChild(OMNode child) {
        if (child instanceof OMElement && !(child instanceof SOAPHeader) && !(child instanceof SOAPBody)) {
            throw new SOAPProcessingException("SOAP Envelope can not have children other than SOAP Header and Body", "Sender");
        }
    }

    @Override
    public void addChild(OMNode child, boolean fromBuilder) {
        if (this.getVersion() instanceof SOAP12Version) {
            this.internalCheckChild(child);
        }
        if (child instanceof SOAPHeader) {
            if (CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$getState(this) == 0) {
                SOAPBody body = this.getBody();
                if (body != null) {
                    body.insertSiblingBefore(child);
                    return;
                }
            } else {
                OMNode node = (OMNode)CoreParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_CoreParentNodeSupport$org_apache_axiom_core_CoreParentNode$coreGetLastKnownChild(this);
                while (node != null) {
                    if (node instanceof SOAPBody) {
                        node.insertSiblingBefore(child);
                        return;
                    }
                    node = node.getPreviousOMSibling();
                }
            }
        }
        AxiomContainerSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomContainerSupport$org_apache_axiom_om_impl_common_AxiomContainer$addChild(this, child, fromBuilder);
    }

    public SOAPBody getBody() throws OMException {
        OMElement element = AxiomElementSupport.ajc$interMethodDispatch1$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$getFirstElement(this);
        if (element != null) {
            if ("Body".equals(element.getLocalName())) {
                return (SOAPBody)element;
            }
            OMNode node = element.getNextOMSibling();
            while (node != null && node.getType() != 1) {
                node = node.getNextOMSibling();
            }
            if (node == null) {
                return null;
            }
            if ("Body".equals(((OMElement)node).getLocalName())) {
                return (SOAPBody)node;
            }
            throw new OMException("SOAPEnvelope must contain a body element which is either first or second child element of the SOAPEnvelope.");
        }
        return null;
    }

    @Override
    public void checkParent(OMElement parent) throws SOAPProcessingException {
    }

    @Override
    public void internalSerialize(Serializer serializer, OMOutputFormat format, boolean cache) throws OutputException {
        if (!format.isIgnoreXMLDeclaration()) {
            String charSetEncoding = format.getCharSetEncoding();
            String xmlVersion = format.getXmlVersion();
            serializer.writeStartDocument(charSetEncoding == null ? "utf-8" : charSetEncoding, xmlVersion == null ? "1.0" : xmlVersion);
        }
        AxiomElementSupport.ajc$interMethod$org_apache_axiom_om_impl_common_AxiomElementSupport$org_apache_axiom_om_impl_common_AxiomElement$internalSerialize(this, serializer, format, cache);
        serializer.writeEndDocument();
        if (!cache) {
            OMXMLParserWrapper builder = DeferringParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$getBuilder(this);
            if (builder != null && builder instanceof StAXBuilder) {
                try {
                    if (log.isDebugEnabled()) {
                        log.debug((Object)("closing builder: " + builder));
                    }
                    StAXBuilder staxBuilder = (StAXBuilder)builder;
                    staxBuilder.close();
                }
                catch (Exception e) {
                    if (log.isDebugEnabled()) {
                        log.error((Object)"Could not close builder or parser due to: ", (Throwable)e);
                    }
                }
            } else if (log.isDebugEnabled()) {
                log.debug((Object)"Could not close builder or parser due to:");
                if (builder == null) {
                    log.debug((Object)"builder is null");
                }
                if (builder != null && !(builder instanceof StAXBuilder)) {
                    log.debug((Object)("builder is not instance of " + StAXBuilder.class.getName()));
                }
            }
        }
    }

    public boolean hasFault() {
        QName payloadQName = this.getPayloadQName_Optimized();
        if (payloadQName != null && "Fault".equals(payloadQName.getLocalPart())) {
            String ns = payloadQName.getNamespaceURI();
            return "http://schemas.xmlsoap.org/soap/envelope/".equals(ns) || "http://www.w3.org/2003/05/soap-envelope".equals(ns);
        }
        SOAPBody body = this.getBody();
        return body == null ? false : body.hasFault();
    }

    public String getSOAPBodyFirstElementLocalName() {
        QName payloadQName = this.getPayloadQName_Optimized();
        if (payloadQName != null) {
            return payloadQName.getLocalPart();
        }
        SOAPBody body = this.getBody();
        return body == null ? null : body.getFirstElementLocalName();
    }

    public OMNamespace getSOAPBodyFirstElementNS() {
        QName payloadQName = this.getPayloadQName_Optimized();
        if (payloadQName != null) {
            return this.getOMFactory().createOMNamespace(payloadQName.getNamespaceURI(), payloadQName.getPrefix());
        }
        SOAPBody body = this.getBody();
        return body == null ? null : body.getFirstElementNS();
    }

    private QName getPayloadQName_Optimized() {
        OMXMLParserWrapper builder = DeferringParentNodeSupport.ajc$interMethodDispatch1$org_apache_axiom_core_DeferringParentNodeSupport$org_apache_axiom_core_DeferringParentNode$getBuilder(this);
        if (builder instanceof StAXSOAPModelBuilder) {
            try {
                QName payloadQName = (QName)((StAXSOAPModelBuilder)builder).getReaderProperty("org.apache.axiom.SOAPBodyFirstChildElementQName");
                return payloadQName;
            }
            catch (Throwable throwable) {}
        }
        return null;
    }

    @Override
    public final Class<? extends CoreNode> coreGetNodeClass() {
        return AxiomSOAPEnvelopeSupport.ajc$interMethod$org_apache_axiom_soap_impl_common_AxiomSOAPEnvelopeSupport$org_apache_axiom_soap_impl_common_AxiomSOAPEnvelope$coreGetNodeClass(this);
    }
}

