/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.area;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.PageViewport;
import org.apache.fop.area.Resolvable;

public class IDTracker {
    private static Log log = LogFactory.getLog((Class)IDTracker.class);
    private Map idLocations = new HashMap();
    private Map unresolvedIDRefs = new HashMap();
    private Set unfinishedIDs = new HashSet();
    private Set alreadyResolvedIDs = new HashSet();

    public void associateIDWithPageViewport(String id, PageViewport pv) {
        ArrayList<PageViewport> pvList;
        if (log.isDebugEnabled()) {
            log.debug((Object)("associateIDWithPageViewport(" + id + ", " + pv + ")"));
        }
        if ((pvList = (ArrayList<PageViewport>)this.idLocations.get(id)) == null) {
            pvList = new ArrayList<PageViewport>();
            this.idLocations.put(id, pvList);
            pvList.add(pv);
            pv.setFirstWithID(id);
            if (!this.unfinishedIDs.contains(id)) {
                this.tryIDResolution(id, pv, pvList);
            }
        } else {
            pvList.add(pv);
        }
    }

    public void signalPendingID(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("signalPendingID(" + id + ")"));
        }
        this.unfinishedIDs.add(id);
    }

    public void signalIDProcessed(String id) {
        if (log.isDebugEnabled()) {
            log.debug((Object)("signalIDProcessed(" + id + ")"));
        }
        this.alreadyResolvedIDs.add(id);
        if (!this.unfinishedIDs.contains(id)) {
            return;
        }
        this.unfinishedIDs.remove(id);
        List pvList = (List)this.idLocations.get(id);
        Set todo = (Set)this.unresolvedIDRefs.get(id);
        if (todo != null) {
            Iterator iter = todo.iterator();
            while (iter.hasNext()) {
                Resolvable res = (Resolvable)iter.next();
                res.resolveIDRef(id, pvList);
            }
            this.unresolvedIDRefs.remove(id);
        }
    }

    public boolean alreadyResolvedID(String id) {
        return this.alreadyResolvedIDs.contains(id);
    }

    private void tryIDResolution(String id, PageViewport pv, List pvList) {
        Set todo = (Set)this.unresolvedIDRefs.get(id);
        if (todo != null) {
            Iterator iter = todo.iterator();
            while (iter.hasNext()) {
                Resolvable res = (Resolvable)iter.next();
                if (!this.unfinishedIDs.contains(id)) {
                    res.resolveIDRef(id, pvList);
                    continue;
                }
                return;
            }
            this.alreadyResolvedIDs.add(id);
            this.unresolvedIDRefs.remove(id);
        }
    }

    public void tryIDResolution(PageViewport pv) {
        String[] ids = pv.getIDRefs();
        if (ids != null) {
            for (int i = 0; i < ids.length; ++i) {
                List pvList = (List)this.idLocations.get(ids[i]);
                if (pvList == null) continue;
                this.tryIDResolution(ids[i], pv, pvList);
            }
        }
    }

    public List getPageViewportsContainingID(String id) {
        return (List)this.idLocations.get(id);
    }

    public void addUnresolvedIDRef(String idref, Resolvable res) {
        HashSet<Resolvable> todo = (HashSet<Resolvable>)this.unresolvedIDRefs.get(idref);
        if (todo == null) {
            todo = new HashSet<Resolvable>();
            this.unresolvedIDRefs.put(idref, todo);
        }
        todo.add(res);
    }
}

