/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.OutputStream;
import org.apache.commons.io.output.ByteArrayOutputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.AFPImageObjectInfo;
import org.apache.fop.afp.AFPObjectAreaInfo;
import org.apache.fop.afp.AFPPaintingState;
import org.apache.fop.afp.AFPResourceInfo;
import org.apache.fop.afp.AFPResourceManager;
import org.apache.fop.afp.modca.GraphicsObject;
import org.apache.fop.afp.svg.AFPGraphicsConfiguration;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.svg.NativeImageHandler;
import org.apache.xmlgraphics.image.loader.ImageInfo;
import org.apache.xmlgraphics.image.loader.ImageSize;
import org.apache.xmlgraphics.image.loader.impl.ImageRendered;
import org.apache.xmlgraphics.java2d.AbstractGraphics2D;
import org.apache.xmlgraphics.java2d.GraphicContext;
import org.apache.xmlgraphics.java2d.StrokingTextHandler;
import org.apache.xmlgraphics.java2d.TextHandler;
import org.apache.xmlgraphics.ps.ImageEncodingHelper;
import org.apache.xmlgraphics.util.UnitConv;

public class AFPGraphics2D
extends AbstractGraphics2D
implements NativeImageHandler {
    private static final Log log = LogFactory.getLog((Class)AFPGraphics2D.class);
    private static final int X = 0;
    private static final int Y = 1;
    private static final int X1 = 0;
    private static final int Y1 = 1;
    private static final int X2 = 2;
    private static final int Y2 = 3;
    private static final int X3 = 4;
    private static final int Y3 = 5;
    private GraphicsObject graphicsObj = null;
    protected TextHandler fallbackTextHandler = new StrokingTextHandler();
    protected TextHandler customTextHandler = null;
    private AFPResourceManager resourceManager = null;
    private AFPResourceInfo resourceInfo = null;
    private AFPPaintingState paintingState = null;
    private final AFPGraphicsConfiguration graphicsConfig = new AFPGraphicsConfiguration();
    private FontInfo fontInfo;
    private static final double GUESSED_WIDTH_CORRECTION = 1.7;
    private static final double SPEC_NORMAL_LINE_WIDTH = UnitConv.in2pt((double)0.01);
    private static final double NORMAL_LINE_WIDTH = SPEC_NORMAL_LINE_WIDTH * 1.7;

    public AFPGraphics2D(boolean textAsShapes, AFPPaintingState paintingState, AFPResourceManager resourceManager, AFPResourceInfo resourceInfo, FontInfo fontInfo) {
        super(textAsShapes);
        this.setPaintingState(paintingState);
        this.setResourceManager(resourceManager);
        this.setResourceInfo(resourceInfo);
        this.setFontInfo(fontInfo);
    }

    public AFPGraphics2D(AFPGraphics2D g2d) {
        super((AbstractGraphics2D)g2d);
        this.paintingState = g2d.paintingState;
        this.resourceManager = g2d.resourceManager;
        this.resourceInfo = g2d.resourceInfo;
        this.fontInfo = g2d.fontInfo;
        this.graphicsObj = g2d.graphicsObj;
        this.fallbackTextHandler = g2d.fallbackTextHandler;
        this.customTextHandler = g2d.customTextHandler;
    }

    private void setResourceManager(AFPResourceManager resourceManager) {
        this.resourceManager = resourceManager;
    }

    private void setResourceInfo(AFPResourceInfo resourceInfo) {
        this.resourceInfo = resourceInfo;
    }

    public GraphicsObject getGraphicsObject() {
        return this.graphicsObj;
    }

    public void setGraphicsObject(GraphicsObject obj) {
        this.graphicsObj = obj;
    }

    private void setPaintingState(AFPPaintingState paintingState) {
        this.paintingState = paintingState;
    }

    public AFPPaintingState getPaintingState() {
        return this.paintingState;
    }

    private void setFontInfo(FontInfo fontInfo) {
        this.fontInfo = fontInfo;
    }

    public FontInfo getFontInfo() {
        return this.fontInfo;
    }

    public void setGraphicContext(GraphicContext gc) {
        this.gc = gc;
    }

    private int getResolution() {
        return this.paintingState.getResolution();
    }

    public double convertToAbsoluteLength(double length) {
        AffineTransform current = this.getTransform();
        double mult = (double)this.getResolution() / 72.0;
        double factor = -current.getScaleY() / mult;
        return length * factor;
    }

    protected void applyStroke(Stroke stroke) {
        if (stroke instanceof BasicStroke) {
            BasicStroke basicStroke = (BasicStroke)stroke;
            float lineWidth = basicStroke.getLineWidth();
            double absoluteLineWidth = (double)lineWidth * Math.abs(this.getTransform().getScaleY());
            double multiplier = absoluteLineWidth / NORMAL_LINE_WIDTH;
            this.graphicsObj.setLineWidth((int)Math.round(multiplier));
            float[] dashArray = basicStroke.getDashArray();
            if (this.paintingState.setDashArray(dashArray)) {
                int type = 0;
                if (dashArray != null) {
                    type = 1;
                    if (dashArray.length == 2) {
                        if (dashArray[0] < dashArray[1]) {
                            type = 2;
                        } else if (dashArray[0] > dashArray[1]) {
                            type = 5;
                        }
                    } else if (dashArray.length == 4) {
                        if (dashArray[0] > dashArray[1] && dashArray[2] < dashArray[3]) {
                            type = 3;
                        } else if (dashArray[0] < dashArray[1] && dashArray[2] < dashArray[3]) {
                            type = 4;
                        }
                    } else if (dashArray.length == 6 && dashArray[0] > dashArray[1] && dashArray[2] < dashArray[3] && dashArray[4] < dashArray[5]) {
                        type = 6;
                    }
                }
                this.graphicsObj.setLineType((byte)type);
            }
        } else {
            log.warn((Object)("Unsupported Stroke: " + stroke.getClass().getName()));
        }
    }

    private boolean applyPaint(Paint paint, boolean fill) {
        if (paint instanceof Color) {
            return true;
        }
        log.debug((Object)("NYI: applyPaint() " + paint + " fill=" + fill));
        if (paint instanceof TexturePaint) {
            // empty if block
        }
        return false;
    }

    private void doDrawing(Shape shape, boolean fill) {
        if (!fill) {
            this.graphicsObj.newSegment();
        }
        this.graphicsObj.setColor(this.gc.getColor());
        this.applyPaint(this.gc.getPaint(), fill);
        if (fill) {
            this.graphicsObj.beginArea();
        } else {
            this.applyStroke(this.gc.getStroke());
        }
        AffineTransform trans = this.gc.getTransform();
        PathIterator iter = shape.getPathIterator(trans);
        if (shape instanceof Line2D) {
            double[] dstPts = new double[6];
            iter.currentSegment(dstPts);
            int[] coords = new int[4];
            coords[0] = (int)Math.round(dstPts[0]);
            coords[1] = (int)Math.round(dstPts[1]);
            iter.next();
            iter.currentSegment(dstPts);
            coords[2] = (int)Math.round(dstPts[0]);
            coords[3] = (int)Math.round(dstPts[1]);
            this.graphicsObj.addLine(coords);
        } else if (shape instanceof Rectangle2D) {
            double[] dstPts = new double[6];
            iter.currentSegment(dstPts);
            int[] coords = new int[4];
            coords[2] = (int)Math.round(dstPts[0]);
            coords[3] = (int)Math.round(dstPts[1]);
            iter.next();
            iter.next();
            iter.currentSegment(dstPts);
            coords[0] = (int)Math.round(dstPts[0]);
            coords[1] = (int)Math.round(dstPts[1]);
            this.graphicsObj.addBox(coords);
        } else if (shape instanceof Ellipse2D) {
            double[] dstPts = new double[6];
            Ellipse2D elip = (Ellipse2D)shape;
            double scale = trans.getScaleX();
            double radiusWidth = elip.getWidth() / 2.0;
            double radiusHeight = elip.getHeight() / 2.0;
            this.graphicsObj.setArcParams((int)Math.round(radiusWidth * scale), (int)Math.round(radiusHeight * scale), 0, 0);
            double[] srcPts = new double[]{elip.getCenterX(), elip.getCenterY()};
            trans.transform(srcPts, 0, dstPts, 0, 1);
            boolean mh = true;
            boolean mhr = false;
            this.graphicsObj.addFullArc((int)Math.round(dstPts[0]), (int)Math.round(dstPts[1]), 1, 0);
        } else {
            this.processPathIterator(iter);
        }
        if (fill) {
            this.graphicsObj.endArea();
        }
    }

    private void processPathIterator(PathIterator iter) {
        double[] dstPts = new double[6];
        int[] openingCoords = new int[2];
        while (!iter.isDone()) {
            switch (iter.currentSegment(dstPts)) {
                case 1: {
                    this.graphicsObj.addLine(new int[]{(int)Math.round(dstPts[0]), (int)Math.round(dstPts[1])}, true);
                    break;
                }
                case 2: {
                    this.graphicsObj.addFillet(new int[]{(int)Math.round(dstPts[0]), (int)Math.round(dstPts[1]), (int)Math.round(dstPts[2]), (int)Math.round(dstPts[3])}, true);
                    break;
                }
                case 3: {
                    this.graphicsObj.addFillet(new int[]{(int)Math.round(dstPts[0]), (int)Math.round(dstPts[1]), (int)Math.round(dstPts[2]), (int)Math.round(dstPts[3]), (int)Math.round(dstPts[4]), (int)Math.round(dstPts[5])}, true);
                    break;
                }
                case 0: {
                    openingCoords = new int[]{(int)Math.round(dstPts[0]), (int)Math.round(dstPts[1])};
                    this.graphicsObj.setCurrentPosition(openingCoords);
                    break;
                }
                case 4: {
                    this.graphicsObj.addLine(openingCoords, true);
                    break;
                }
                default: {
                    log.debug((Object)"Unrecognised path iterator type");
                }
            }
            iter.next();
        }
    }

    public void draw(Shape shape) {
        log.debug((Object)("draw() shape=" + shape));
        this.doDrawing(shape, false);
    }

    public void fill(Shape shape) {
        log.debug((Object)("fill() shape=" + shape));
        this.doDrawing(shape, true);
    }

    public void handleIOException(IOException ioe) {
        log.error((Object)ioe.getMessage());
        ioe.printStackTrace();
    }

    public void drawString(String str, float x, float y) {
        try {
            if (this.customTextHandler != null && !this.textAsShapes) {
                this.customTextHandler.drawString((Graphics2D)((Object)this), str, x, y);
            } else {
                this.fallbackTextHandler.drawString((Graphics2D)((Object)this), str, x, y);
            }
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphicsConfig;
    }

    public Graphics create() {
        return new AFPGraphics2D(this);
    }

    public void dispose() {
        this.graphicsObj = null;
    }

    public boolean drawImage(Image img, int x, int y, ImageObserver observer) {
        return this.drawImage(img, x, y, img.getWidth(observer), img.getHeight(observer), observer);
    }

    private BufferedImage buildBufferedImage(Dimension size) {
        return new BufferedImage(size.width, size.height, 2);
    }

    private AFPImageObjectInfo createImageObjectInfo(RenderedImage img, int x, int y, int width, int height) throws IOException {
        ImageInfo imageInfo = new ImageInfo(null, "image/unknown");
        ImageSize size = new ImageSize(img.getWidth(), img.getHeight(), 72.0);
        imageInfo.setSize(size);
        ImageRendered imageRendered = new ImageRendered(imageInfo, img, null);
        RenderedImage renderedImage = imageRendered.getRenderedImage();
        AFPImageObjectInfo imageObjectInfo = new AFPImageObjectInfo();
        imageObjectInfo.setMimeType("image/x-afp+fs45");
        int bitsPerPixel = this.paintingState.getBitsPerPixel();
        imageObjectInfo.setBitsPerPixel(bitsPerPixel);
        imageObjectInfo.setResourceInfo(this.resourceInfo);
        int dataHeight = renderedImage.getHeight();
        imageObjectInfo.setDataHeight(dataHeight);
        int dataWidth = renderedImage.getWidth();
        imageObjectInfo.setDataWidth(dataWidth);
        boolean colorImages = this.paintingState.isColorImages();
        imageObjectInfo.setColor(colorImages);
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        ImageEncodingHelper.encodeRenderedImageAsRGB((RenderedImage)renderedImage, (OutputStream)boas);
        byte[] imageData = boas.toByteArray();
        if (!colorImages) {
            boas.reset();
            imageObjectInfo.setBitsPerPixel(bitsPerPixel);
            ImageEncodingHelper.encodeRGBAsGrayScale((byte[])imageData, (int)dataWidth, (int)dataHeight, (int)bitsPerPixel, (OutputStream)boas);
            imageData = boas.toByteArray();
        }
        imageObjectInfo.setData(imageData);
        if (imageInfo != null) {
            imageObjectInfo.setUri(imageInfo.getOriginalURI());
        }
        AFPObjectAreaInfo objectAreaInfo = new AFPObjectAreaInfo();
        objectAreaInfo.setX(x);
        objectAreaInfo.setY(y);
        objectAreaInfo.setWidth(width);
        objectAreaInfo.setHeight(height);
        int resolution = this.paintingState.getResolution();
        objectAreaInfo.setWidthRes(resolution);
        objectAreaInfo.setHeightRes(resolution);
        imageObjectInfo.setObjectAreaInfo(objectAreaInfo);
        return imageObjectInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean drawBufferedImage(Image img, BufferedImage bufferedImage, int width, int height, ImageObserver observer) {
        Graphics2D g2d = bufferedImage.createGraphics();
        try {
            g2d.setComposite(AlphaComposite.SrcOver);
            Color color = new Color(1, 1, 1, 0);
            g2d.setBackground(color);
            g2d.setPaint(color);
            g2d.fillRect(0, 0, width, height);
            int imageWidth = bufferedImage.getWidth();
            int imageHeight = bufferedImage.getHeight();
            Rectangle clipRect = new Rectangle(0, 0, imageWidth, imageHeight);
            g2d.clip(clipRect);
            g2d.setComposite(this.gc.getComposite());
            boolean bl = g2d.drawImage(img, 0, 0, imageWidth, imageHeight, observer);
            return bl;
        }
        finally {
            g2d.dispose();
        }
    }

    public boolean drawImage(Image img, int x, int y, int width, int height, ImageObserver observer) {
        Dimension imageSize = new Dimension(width, height);
        BufferedImage bufferedImage = this.buildBufferedImage(imageSize);
        boolean drawn = this.drawBufferedImage(img, bufferedImage, width, height, observer);
        if (drawn) {
            AffineTransform at = this.gc.getTransform();
            float[] srcPts = new float[]{x, y};
            float[] dstPts = new float[srcPts.length];
            at.transform(srcPts, 0, dstPts, 0, 1);
            x = Math.round(dstPts[0]);
            y = Math.round(dstPts[1]);
            try {
                AFPImageObjectInfo imageObjectInfo = this.createImageObjectInfo(bufferedImage, x, y, width, height);
                this.resourceManager.createObject(imageObjectInfo);
                return true;
            }
            catch (IOException ioe) {
                this.handleIOException(ioe);
            }
        }
        return false;
    }

    public void drawRenderedImage(RenderedImage img, AffineTransform xform) {
        int imgWidth = img.getWidth();
        int imgHeight = img.getHeight();
        AffineTransform at = this.paintingState.getData().getTransform();
        AffineTransform gat = this.gc.getTransform();
        int graphicsObjectHeight = this.graphicsObj.getObjectEnvironmentGroup().getObjectAreaDescriptor().getHeight();
        int x = (int)Math.round(at.getTranslateX() + gat.getTranslateX());
        int y = (int)Math.round(at.getTranslateY() - (gat.getTranslateY() - (double)graphicsObjectHeight));
        int width = (int)Math.round((double)imgWidth * gat.getScaleX());
        int height = (int)Math.round((double)imgHeight * -gat.getScaleY());
        try {
            AFPImageObjectInfo imageObjectInfo = this.createImageObjectInfo(img, x, y, width, height);
            this.resourceManager.createObject(imageObjectInfo);
        }
        catch (IOException ioe) {
            this.handleIOException(ioe);
        }
    }

    public void setCustomTextHandler(TextHandler handler) {
        this.customTextHandler = handler;
    }

    public void drawRenderableImage(RenderableImage img, AffineTransform xform) {
        log.debug((Object)("drawRenderableImage() NYI: img=" + img + ", xform=" + xform));
    }

    public FontMetrics getFontMetrics(Font f) {
        log.debug((Object)("getFontMetrics() NYI: f=" + f));
        return null;
    }

    public void setXORMode(Color col) {
        log.debug((Object)("setXORMode() NYI: col=" + col));
    }

    public void addNativeImage(org.apache.xmlgraphics.image.loader.Image image, float x, float y, float width, float height) {
        log.debug((Object)("NYI: addNativeImage() image=" + image + ",x=" + x + ",y=" + y + ",width=" + width + ",height=" + height));
    }

    public void copyArea(int x, int y, int width, int height, int dx, int dy) {
        log.debug((Object)"copyArea() NYI: ");
    }
}

