/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr.inline;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Trait;
import org.apache.fop.area.inline.TextArea;
import org.apache.fop.fo.FOText;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontSelector;
import org.apache.fop.layoutmgr.InlineKnuthSequence;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthGlue;
import org.apache.fop.layoutmgr.KnuthPenalty;
import org.apache.fop.layoutmgr.KnuthSequence;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.AlignmentContext;
import org.apache.fop.layoutmgr.inline.HyphContext;
import org.apache.fop.layoutmgr.inline.KnuthInlineBox;
import org.apache.fop.layoutmgr.inline.LeafNodeLayoutManager;
import org.apache.fop.text.linebreak.LineBreakStatus;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;
import org.apache.fop.util.CharUtilities;
import org.apache.fop.util.ListUtil;

public class TextLayoutManager
extends LeafNodeLayoutManager {
    private static final Log LOG = LogFactory.getLog((Class)TextLayoutManager.class);
    private final List vecAreaInfo;
    private static final String BREAK_CHARS = "-/";
    private static final MinOptMax ZERO_MINOPTMAX = new MinOptMax(0);
    private final FOText foText;
    private final MinOptMax[] letterAdjustArray;
    private Font spaceFont = null;
    private int nextStart = 0;
    private int spaceCharIPD;
    private MinOptMax wordSpaceIPD;
    private MinOptMax letterSpaceIPD;
    private int hyphIPD;
    private SpaceVal ws;
    private boolean hasChanged = false;
    private int returnedIndex = 0;
    private int thisStart = 0;
    private int tempStart = 0;
    private List changeList = null;
    private AlignmentContext alignmentContext = null;
    private int lineStartBAP = 0;
    private int lineEndBAP = 0;
    private boolean keepTogether;
    private final Position auxiliaryPosition = new LeafPosition(this, -1);
    private static final int SOFT_HYPHEN_PENALTY = 1;

    public TextLayoutManager(FOText node) {
        this.foText = node;
        this.letterAdjustArray = new MinOptMax[node.length() + 1];
        this.vecAreaInfo = new ArrayList();
    }

    private KnuthPenalty makeZeroWidthPenalty(int penaltyValue) {
        return new KnuthPenalty(0, penaltyValue, false, this.auxiliaryPosition, true);
    }

    private KnuthBox makeAuxiliaryZeroWidthBox() {
        return new KnuthInlineBox(0, null, this.notifyPos(new LeafPosition(this, -1)), true);
    }

    public void initialize() {
        this.foText.resetBuffer();
        this.spaceFont = FontSelector.selectFontForCharacterInText(' ', this.foText, this);
        this.spaceCharIPD = this.spaceFont.getCharWidth(' ');
        this.hyphIPD = this.foText.getCommonHyphenation().getHyphIPD(this.spaceFont);
        SpaceVal ls = SpaceVal.makeLetterSpacing(this.foText.getLetterSpacing());
        this.ws = SpaceVal.makeWordSpacing(this.foText.getWordSpacing(), ls, this.spaceFont);
        this.letterSpaceIPD = ls.getSpace();
        this.wordSpaceIPD = MinOptMax.add(new MinOptMax(this.spaceCharIPD), this.ws.getSpace());
        this.keepTogether = this.foText.getKeepTogether().getWithinLine().getEnum() == 7;
    }

    public void addAreas(PositionIterator posIter, LayoutContext context) {
        int wordSpaceCount = 0;
        int letterSpaceCount = 0;
        int firstAreaInfoIndex = -1;
        int lastAreaInfoIndex = 0;
        MinOptMax realWidth = new MinOptMax(0);
        AreaInfo lastAi = null;
        while (posIter.hasNext()) {
            LeafPosition tbpNext = (LeafPosition)posIter.next();
            if (tbpNext == null || tbpNext.getLeafPos() == -1) continue;
            AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(tbpNext.getLeafPos());
            if (lastAi == null || ai.font != lastAi.font) {
                if (lastAi != null) {
                    this.addAreaInfoAreas(lastAi, wordSpaceCount, letterSpaceCount, firstAreaInfoIndex, lastAreaInfoIndex, realWidth, context);
                }
                firstAreaInfoIndex = tbpNext.getLeafPos();
                wordSpaceCount = 0;
                letterSpaceCount = 0;
                realWidth = new MinOptMax(0);
            }
            wordSpaceCount += ai.wordSpaceCount;
            letterSpaceCount += ai.letterSpaceCount;
            realWidth.add(ai.areaIPD);
            lastAreaInfoIndex = tbpNext.getLeafPos();
            lastAi = ai;
        }
        if (lastAi != null) {
            this.addAreaInfoAreas(lastAi, wordSpaceCount, letterSpaceCount, firstAreaInfoIndex, lastAreaInfoIndex, realWidth, context);
        }
    }

    private void addAreaInfoAreas(AreaInfo ai, int wordSpaceCount, int letterSpaceCount, int firstAreaInfoIndex, int lastAreaInfoIndex, MinOptMax realWidth, LayoutContext context) {
        int textLength = ai.breakIndex - ai.startIndex;
        if (ai.letterSpaceCount == textLength && !ai.isHyphenated && context.isLastArea()) {
            realWidth.add(MinOptMax.multiply(this.letterSpaceIPD, -1.0));
            --letterSpaceCount;
        }
        for (int i = ai.startIndex; i < ai.breakIndex; ++i) {
            MinOptMax ladj = this.letterAdjustArray[i + 1];
            if (ladj == null || !ladj.isElastic()) continue;
            ++letterSpaceCount;
        }
        if (context.isLastArea() && ai.isHyphenated) {
            realWidth.add(new MinOptMax(this.hyphIPD));
        }
        int difference = 0;
        int totalAdjust = 0;
        int wordSpaceDim = this.wordSpaceIPD.opt;
        int letterSpaceDim = this.letterSpaceIPD.opt;
        double ipdAdjust = context.getIPDAdjust();
        difference = ipdAdjust > 0.0 ? (int)((double)(realWidth.max - realWidth.opt) * ipdAdjust) : (int)((double)(realWidth.opt - realWidth.min) * ipdAdjust);
        letterSpaceDim = ipdAdjust > 0.0 ? (letterSpaceDim += (int)((double)(this.letterSpaceIPD.max - this.letterSpaceIPD.opt) * ipdAdjust)) : (letterSpaceDim += (int)((double)(this.letterSpaceIPD.opt - this.letterSpaceIPD.min) * ipdAdjust));
        totalAdjust += (letterSpaceDim - this.letterSpaceIPD.opt) * letterSpaceCount;
        if (wordSpaceCount > 0) {
            wordSpaceDim += (difference - totalAdjust) / wordSpaceCount;
        }
        if ((totalAdjust += (wordSpaceDim - this.wordSpaceIPD.opt) * wordSpaceCount) != difference) {
            LOG.trace((Object)("TextLM.addAreas: error in word / letter space adjustment = " + (totalAdjust - difference)));
            totalAdjust = difference;
        }
        TextArea t = this.createTextArea(realWidth, totalAdjust, context, this.wordSpaceIPD.opt - this.spaceCharIPD, firstAreaInfoIndex, lastAreaInfoIndex, context.isLastArea(), ai.font);
        t.setTextLetterSpaceAdjust(letterSpaceDim);
        t.setTextWordSpaceAdjust(wordSpaceDim - this.spaceCharIPD - 2 * t.getTextLetterSpaceAdjust());
        if (context.getIPDAdjust() != 0.0) {
            t.setSpaceDifference(this.wordSpaceIPD.opt - this.spaceCharIPD - 2 * t.getTextLetterSpaceAdjust());
        }
        this.parentLM.addChildArea(t);
    }

    protected TextArea createTextArea(MinOptMax width, int adjust, LayoutContext context, int spaceDiff, int firstIndex, int lastIndex, boolean isLastArea, Font font) {
        TextArea textArea = context.getIPDAdjust() == 0.0 ? new TextArea() : new TextArea(width.max - width.opt, width.opt - width.min, adjust);
        textArea.setIPD(width.opt + adjust);
        textArea.setBPD(font.getAscender() - font.getDescender());
        textArea.setBaselineOffset(font.getAscender());
        if (textArea.getBPD() == this.alignmentContext.getHeight()) {
            textArea.setOffset(0);
        } else {
            textArea.setOffset(this.alignmentContext.getOffset());
        }
        int wordStartIndex = -1;
        int len = 0;
        for (int i = firstIndex; i <= lastIndex; ++i) {
            AreaInfo areaInfo = (AreaInfo)this.vecAreaInfo.get(i);
            if (areaInfo.isSpace) {
                for (int j = areaInfo.startIndex; j < areaInfo.breakIndex; ++j) {
                    char spaceChar = this.foText.charAt(j);
                    if (CharUtilities.isZeroWidthSpace(spaceChar)) continue;
                    textArea.addSpace(spaceChar, 0, CharUtilities.isAdjustableSpace(spaceChar));
                }
                continue;
            }
            if (wordStartIndex == -1) {
                wordStartIndex = i;
                len = 0;
            }
            len += areaInfo.breakIndex - areaInfo.startIndex;
            if (i != lastIndex && !((AreaInfo)this.vecAreaInfo.get(i + 1)).isSpace) continue;
            if (isLastArea && i == lastIndex && areaInfo.isHyphenated) {
                ++len;
            }
            StringBuffer wordChars = new StringBuffer(len);
            int[] letterAdjust = new int[len];
            int letter = 0;
            for (int j = wordStartIndex; j <= i; ++j) {
                AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(j);
                int lsCount = ai.letterSpaceCount;
                for (int ci = ai.startIndex; ci < ai.breakIndex; ++ci) {
                    wordChars.append(this.foText.charAt(ci));
                }
                for (int k = 0; k < ai.breakIndex - ai.startIndex; ++k) {
                    MinOptMax adj = this.letterAdjustArray[ai.startIndex + k];
                    if (letter > 0) {
                        int n = letterAdjust[letter] = adj == null ? 0 : adj.opt;
                    }
                    if (lsCount > 0) {
                        int n = letter;
                        letterAdjust[n] = letterAdjust[n] + textArea.getTextLetterSpaceAdjust();
                        --lsCount;
                    }
                    ++letter;
                }
            }
            if (isLastArea && i == lastIndex && areaInfo.isHyphenated) {
                wordChars.append(this.foText.getCommonHyphenation().getHyphChar(font));
            }
            textArea.addWord(wordChars.toString(), 0, letterAdjust);
            wordStartIndex = -1;
        }
        TraitSetter.addFontTraits(textArea, font);
        textArea.addTrait(Trait.COLOR, this.foText.getColor());
        TraitSetter.addTextDecoration(textArea, this.foText.getTextDecoration());
        return textArea;
    }

    private void addToLetterAdjust(int index, int width) {
        if (this.letterAdjustArray[index] == null) {
            this.letterAdjustArray[index] = new MinOptMax(width);
        } else {
            this.letterAdjustArray[index].add(width);
        }
    }

    private static boolean isSpace(char ch) {
        return ch == ' ' || CharUtilities.isNonBreakableSpace(ch) || CharUtilities.isFixedWidthSpace(ch);
    }

    public List getNextKnuthElements(LayoutContext context, int alignment) {
        this.lineStartBAP = context.getLineStartBorderAndPaddingWidth();
        this.lineEndBAP = context.getLineEndBorderAndPaddingWidth();
        this.alignmentContext = context.getAlignmentContext();
        LinkedList<InlineKnuthSequence> returnList = new LinkedList<InlineKnuthSequence>();
        KnuthSequence sequence = new InlineKnuthSequence();
        AreaInfo ai = null;
        AreaInfo prevAi = null;
        returnList.add((InlineKnuthSequence)sequence);
        LineBreakStatus lbs = new LineBreakStatus();
        this.thisStart = this.nextStart;
        boolean inWord = false;
        boolean inWhitespace = false;
        char ch = '\u0000';
        while (this.nextStart < this.foText.length()) {
            ch = this.foText.charAt(this.nextStart);
            boolean breakOpportunity = false;
            int breakAction = this.keepTogether ? 4 : (int)lbs.nextChar(ch);
            switch (breakAction) {
                case 3: 
                case 4: {
                    break;
                }
                case 5: {
                    break;
                }
                case 0: 
                case 1: 
                case 2: {
                    breakOpportunity = true;
                    break;
                }
                default: {
                    LOG.error((Object)("Unexpected breakAction: " + breakAction));
                }
            }
            if (inWord) {
                if (breakOpportunity || TextLayoutManager.isSpace(ch) || CharUtilities.isExplicitBreak(ch)) {
                    prevAi = this.processWord(alignment, sequence, prevAi, ch, breakOpportunity, true);
                }
            } else if (inWhitespace) {
                if (ch != ' ' || breakOpportunity) {
                    prevAi = this.processWhitespace(alignment, sequence, breakOpportunity);
                }
            } else {
                if (ai != null) {
                    prevAi = ai;
                    ai = this.processLeftoverAi(alignment, sequence, ai, ch, ch == ' ' || breakOpportunity);
                }
                if (breakAction == 5) {
                    sequence = this.processLinebreak(returnList, sequence);
                }
            }
            if (ch == ' ' && this.foText.getWhitespaceTreatment() == 108 || ch == '\u00a0') {
                ai = new AreaInfo(this.nextStart, this.nextStart + 1, 1, 0, this.wordSpaceIPD, false, true, breakOpportunity, this.spaceFont);
                this.thisStart = this.nextStart + 1;
            } else if (CharUtilities.isFixedWidthSpace(ch) || CharUtilities.isZeroWidthSpace(ch)) {
                Font font = FontSelector.selectFontForCharacterInText(ch, this.foText, this);
                MinOptMax ipd = new MinOptMax(font.getCharWidth(ch));
                ai = new AreaInfo(this.nextStart, this.nextStart + 1, 0, 0, ipd, false, true, breakOpportunity, font);
                this.thisStart = this.nextStart + 1;
            } else if (CharUtilities.isExplicitBreak(ch)) {
                this.thisStart = this.nextStart + 1;
            }
            inWord = !TextLayoutManager.isSpace(ch) && !CharUtilities.isExplicitBreak(ch);
            inWhitespace = ch == ' ' && this.foText.getWhitespaceTreatment() != 108;
            ++this.nextStart;
        }
        if (inWord) {
            this.processWord(alignment, sequence, prevAi, ch, false, false);
        } else if (inWhitespace) {
            this.processWhitespace(alignment, sequence, true);
        } else if (ai != null) {
            this.processLeftoverAi(alignment, sequence, ai, ch, ch == '\u200b');
        } else if (CharUtilities.isExplicitBreak(ch)) {
            this.processLinebreak(returnList, sequence);
        }
        if (((List)ListUtil.getLast(returnList)).isEmpty()) {
            ListUtil.removeLast(returnList);
        }
        this.setFinished(true);
        if (returnList.isEmpty()) {
            return null;
        }
        return returnList;
    }

    private KnuthSequence processLinebreak(List returnList, KnuthSequence sequence) {
        if (this.lineEndBAP != 0) {
            sequence.add(new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, true));
        }
        sequence.endSequence();
        sequence = new InlineKnuthSequence();
        returnList.add(sequence);
        return sequence;
    }

    private AreaInfo processLeftoverAi(int alignment, KnuthSequence sequence, AreaInfo ai, char ch, boolean breakOpportunityAfter) {
        this.vecAreaInfo.add(ai);
        ai.breakOppAfter = breakOpportunityAfter;
        this.addElementsForASpace(sequence, alignment, ai, this.vecAreaInfo.size() - 1);
        ai = null;
        return ai;
    }

    private AreaInfo processWhitespace(int alignment, KnuthSequence sequence, boolean breakOpportunity) {
        AreaInfo ai = new AreaInfo(this.thisStart, this.nextStart, this.nextStart - this.thisStart, 0, MinOptMax.multiply(this.wordSpaceIPD, this.nextStart - this.thisStart), false, true, breakOpportunity, this.spaceFont);
        this.vecAreaInfo.add(ai);
        this.addElementsForASpace(sequence, alignment, ai, this.vecAreaInfo.size() - 1);
        this.thisStart = this.nextStart;
        return ai;
    }

    private AreaInfo processWord(int alignment, KnuthSequence sequence, AreaInfo prevAi, char ch, boolean breakOpportunity, boolean checkEndsWithHyphen) {
        AreaInfo ai;
        int kern;
        int lastIndex;
        for (lastIndex = this.nextStart; lastIndex > 0 && this.foText.charAt(lastIndex - 1) == '\u00ad'; --lastIndex) {
        }
        boolean endsWithHyphen = checkEndsWithHyphen && this.foText.charAt(lastIndex) == '\u00ad';
        Font font = FontSelector.selectFontForCharactersInText(this.foText, this.thisStart, lastIndex, this.foText, this);
        int wordLength = lastIndex - this.thisStart;
        boolean kerning = font.hasKerning();
        MinOptMax wordIPD = new MinOptMax(0);
        for (int i = this.thisStart; i < lastIndex; ++i) {
            char previous;
            char c = this.foText.charAt(i);
            int charWidth = font.getCharWidth(c);
            wordIPD.add(charWidth);
            if (!kerning) continue;
            int kern2 = 0;
            if (i > this.thisStart) {
                previous = this.foText.charAt(i - 1);
                kern2 = font.getKernValue(previous, c) * font.getFontSize() / 1000;
            } else if (prevAi != null && !prevAi.isSpace && prevAi.breakIndex > 0) {
                previous = this.foText.charAt(prevAi.breakIndex - 1);
                kern2 = font.getKernValue(previous, c) * font.getFontSize() / 1000;
            }
            if (kern2 == 0) continue;
            this.addToLetterAdjust(i, kern2);
            wordIPD.add(kern2);
        }
        if (kerning && breakOpportunity && !TextLayoutManager.isSpace(ch) && lastIndex > 0 && endsWithHyphen && (kern = font.getKernValue(this.foText.charAt(lastIndex - 1), ch) * font.getFontSize() / 1000) != 0) {
            this.addToLetterAdjust(lastIndex, kern);
        }
        int iLetterSpaces = wordLength - 1;
        if (breakOpportunity && !TextLayoutManager.isSpace(ch)) {
            ++iLetterSpaces;
        }
        wordIPD.add(MinOptMax.multiply(this.letterSpaceIPD, iLetterSpaces));
        prevAi = ai = new AreaInfo(this.thisStart, lastIndex, 0, iLetterSpaces, wordIPD, endsWithHyphen, false, breakOpportunity, font);
        this.vecAreaInfo.add(ai);
        this.tempStart = this.nextStart;
        this.addElementsForAWordFragment(sequence, alignment, ai, this.vecAreaInfo.size() - 1, this.letterSpaceIPD);
        ai = null;
        this.thisStart = this.nextStart;
        return prevAi;
    }

    public List addALetterSpaceTo(List oldList) {
        ListIterator<KnuthElement> oldListIterator = oldList.listIterator();
        KnuthElement el = (KnuthElement)oldListIterator.next();
        LeafPosition pos = (LeafPosition)((KnuthBox)el).getPosition();
        int idx = pos.getLeafPos();
        if (idx > -1) {
            AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(idx);
            ai.letterSpaceCount++;
            ai.areaIPD.add(this.letterSpaceIPD);
            if (BREAK_CHARS.indexOf(this.foText.charAt(this.tempStart - 1)) >= 0) {
                oldListIterator = oldList.listIterator(oldList.size());
                oldListIterator.add(new KnuthPenalty(0, 50, true, this.auxiliaryPosition, false));
                oldListIterator.add(new KnuthGlue(this.letterSpaceIPD.opt, this.letterSpaceIPD.max - this.letterSpaceIPD.opt, this.letterSpaceIPD.opt - this.letterSpaceIPD.min, this.auxiliaryPosition, false));
            } else if (this.letterSpaceIPD.min == this.letterSpaceIPD.max) {
                oldListIterator.set(new KnuthInlineBox(((AreaInfo)ai).areaIPD.opt, this.alignmentContext, pos, false));
            } else {
                oldListIterator.next();
                oldListIterator.next();
                oldListIterator.set(new KnuthGlue(ai.letterSpaceCount * this.letterSpaceIPD.opt, ai.letterSpaceCount * (this.letterSpaceIPD.max - this.letterSpaceIPD.opt), ai.letterSpaceCount * (this.letterSpaceIPD.opt - this.letterSpaceIPD.min), this.auxiliaryPosition, true));
            }
        }
        return oldList;
    }

    public void removeWordSpace(List oldList) {
        int leafValue;
        ListIterator oldListIterator = oldList.listIterator();
        if (((KnuthElement)((LinkedList)oldList).getFirst()).isPenalty()) {
            oldListIterator.next();
        }
        if (oldList.size() > 2) {
            oldListIterator.next();
            oldListIterator.next();
        }
        if ((leafValue = ((LeafPosition)((KnuthElement)oldListIterator.next()).getPosition()).getLeafPos()) == this.vecAreaInfo.size() - 1) {
            this.vecAreaInfo.remove(leafValue);
        } else {
            LOG.error((Object)"trying to remove a non-trailing word space");
        }
    }

    public void hyphenate(Position pos, HyphContext hc) {
        AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(((LeafPosition)pos).getLeafPos());
        int startIndex = ai.startIndex;
        boolean nothingChanged = true;
        Font font = ai.font;
        while (startIndex < ai.breakIndex) {
            boolean hyphenFollows;
            MinOptMax newIPD = new MinOptMax(0);
            int stopIndex = startIndex + hc.getNextHyphPoint();
            if (hc.hasMoreHyphPoints() && stopIndex <= ai.breakIndex) {
                hyphenFollows = true;
            } else {
                hyphenFollows = false;
                stopIndex = ai.breakIndex;
            }
            hc.updateOffset(stopIndex - startIndex);
            for (int i = startIndex; i < stopIndex; ++i) {
                char c = this.foText.charAt(i);
                newIPD.add(new MinOptMax(font.getCharWidth(c)));
                if (i >= stopIndex) continue;
                MinOptMax la = this.letterAdjustArray[i + 1];
                if (i == stopIndex - 1 && hyphenFollows) {
                    la = null;
                }
                if (la == null) continue;
                newIPD.add(la);
            }
            boolean isWordEnd = stopIndex == ai.breakIndex && ai.letterSpaceCount < ai.breakIndex - ai.startIndex;
            newIPD.add(MinOptMax.multiply(this.letterSpaceIPD, isWordEnd ? stopIndex - startIndex - 1 : stopIndex - startIndex));
            if (!nothingChanged || stopIndex != ai.breakIndex || hyphenFollows) {
                if (this.changeList == null) {
                    this.changeList = new LinkedList();
                }
                this.changeList.add(new PendingChange(new AreaInfo(startIndex, stopIndex, 0, isWordEnd ? stopIndex - startIndex - 1 : stopIndex - startIndex, newIPD, hyphenFollows, false, false, font), ((LeafPosition)pos).getLeafPos()));
                nothingChanged = false;
            }
            startIndex = stopIndex;
        }
        this.hasChanged = this.hasChanged || !nothingChanged;
    }

    public boolean applyChanges(List oldList) {
        this.setFinished(false);
        if (this.changeList != null && !this.changeList.isEmpty()) {
            int areaInfosAdded = 0;
            int areaInfosRemoved = 0;
            int oldIndex = -1;
            ListIterator changeListIterator = this.changeList.listIterator();
            while (changeListIterator.hasNext()) {
                int changeIndex;
                PendingChange currChange = (PendingChange)changeListIterator.next();
                if (currChange.index == oldIndex) {
                    changeIndex = currChange.index + ++areaInfosAdded - areaInfosRemoved;
                } else {
                    oldIndex = currChange.index;
                    changeIndex = currChange.index + ++areaInfosAdded - ++areaInfosRemoved;
                    this.vecAreaInfo.remove(changeIndex);
                }
                this.vecAreaInfo.add(changeIndex, currChange.ai);
            }
            this.changeList.clear();
        }
        this.returnedIndex = 0;
        return this.hasChanged;
    }

    public List getChangedKnuthElements(List oldList, int alignment) {
        if (this.isFinished()) {
            return null;
        }
        LinkedList returnList = new LinkedList();
        while (this.returnedIndex < this.vecAreaInfo.size()) {
            AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(this.returnedIndex);
            if (ai.wordSpaceCount == 0) {
                this.addElementsForAWordFragment(returnList, alignment, ai, this.returnedIndex, this.letterSpaceIPD);
            } else {
                this.addElementsForASpace(returnList, alignment, ai, this.returnedIndex);
            }
            ++this.returnedIndex;
        }
        this.setFinished(true);
        return returnList;
    }

    public void getWordChars(StringBuffer sbChars, Position pos) {
        int leafValue = ((LeafPosition)pos).getLeafPos();
        if (leafValue != -1) {
            AreaInfo ai = (AreaInfo)this.vecAreaInfo.get(leafValue);
            for (int i = ai.startIndex; i < ai.breakIndex; ++i) {
                sbChars.append(this.foText.charAt(i));
            }
        }
    }

    private void addElementsForASpace(List baseList, int alignment, AreaInfo ai, int leafValue) {
        LeafPosition mainPosition = new LeafPosition(this, leafValue);
        if (!ai.breakOppAfter) {
            if (alignment == 70) {
                baseList.add(this.makeAuxiliaryZeroWidthBox());
                baseList.add(this.makeZeroWidthPenalty(1000));
                baseList.add(new KnuthGlue(((AreaInfo)ai).areaIPD.opt, ((AreaInfo)ai).areaIPD.max - ((AreaInfo)ai).areaIPD.opt, ((AreaInfo)ai).areaIPD.opt - ((AreaInfo)ai).areaIPD.min, mainPosition, false));
            } else {
                baseList.add(new KnuthInlineBox(((AreaInfo)ai).areaIPD.opt, null, mainPosition, true));
            }
        } else if (this.foText.charAt(ai.startIndex) != ' ' || this.foText.getWhitespaceTreatment() == 108) {
            this.addElementsForBreakingSpace(baseList, alignment, ai, this.auxiliaryPosition, 0, mainPosition, ((AreaInfo)ai).areaIPD.opt, true);
        } else {
            this.addElementsForBreakingSpace(baseList, alignment, ai, mainPosition, ((AreaInfo)ai).areaIPD.opt, this.auxiliaryPosition, 0, false);
        }
    }

    private void addElementsForBreakingSpace(List baseList, int alignment, AreaInfo ai, Position pos2, int p2WidthOffset, Position pos3, int p3WidthOffset, boolean skipZeroCheck) {
        switch (alignment) {
            case 23: {
                baseList.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, false));
                baseList.add(this.makeZeroWidthPenalty(0));
                baseList.add(new KnuthGlue(p2WidthOffset - (this.lineStartBAP + this.lineEndBAP), -20016, 0, pos2, false));
                baseList.add(this.makeAuxiliaryZeroWidthBox());
                baseList.add(this.makeZeroWidthPenalty(1000));
                baseList.add(new KnuthGlue(this.lineStartBAP + p3WidthOffset, 10008, 0, pos3, false));
                break;
            }
            case 39: 
            case 135: {
                if (skipZeroCheck || this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    baseList.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, false));
                    baseList.add(this.makeZeroWidthPenalty(0));
                    baseList.add(new KnuthGlue(p2WidthOffset - (this.lineStartBAP + this.lineEndBAP), -10008, 0, pos2, false));
                    baseList.add(this.makeAuxiliaryZeroWidthBox());
                    baseList.add(this.makeZeroWidthPenalty(1000));
                    baseList.add(new KnuthGlue(this.lineStartBAP + p3WidthOffset, 0, 0, pos3, false));
                    break;
                }
                baseList.add(new KnuthGlue(0, 10008, 0, this.auxiliaryPosition, false));
                baseList.add(this.makeZeroWidthPenalty(0));
                baseList.add(new KnuthGlue(((AreaInfo)ai).areaIPD.opt, -10008, 0, pos2, false));
                break;
            }
            case 70: {
                if (skipZeroCheck || this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    baseList.add(new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, false));
                    baseList.add(this.makeZeroWidthPenalty(0));
                    baseList.add(new KnuthGlue(p2WidthOffset - (this.lineStartBAP + this.lineEndBAP), ((AreaInfo)ai).areaIPD.max - ((AreaInfo)ai).areaIPD.opt, ((AreaInfo)ai).areaIPD.opt - ((AreaInfo)ai).areaIPD.min, pos2, false));
                    baseList.add(this.makeAuxiliaryZeroWidthBox());
                    baseList.add(this.makeZeroWidthPenalty(1000));
                    baseList.add(new KnuthGlue(this.lineStartBAP + p3WidthOffset, 0, 0, pos3, false));
                    break;
                }
                baseList.add(new KnuthGlue(((AreaInfo)ai).areaIPD.opt, ((AreaInfo)ai).areaIPD.max - ((AreaInfo)ai).areaIPD.opt, ((AreaInfo)ai).areaIPD.opt - ((AreaInfo)ai).areaIPD.min, pos2, false));
                break;
            }
            default: {
                if (skipZeroCheck || this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    baseList.add(new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, false));
                    baseList.add(this.makeZeroWidthPenalty(0));
                    baseList.add(new KnuthGlue(p2WidthOffset - (this.lineStartBAP + this.lineEndBAP), ((AreaInfo)ai).areaIPD.max - ((AreaInfo)ai).areaIPD.opt, 0, pos2, false));
                    baseList.add(this.makeAuxiliaryZeroWidthBox());
                    baseList.add(this.makeZeroWidthPenalty(1000));
                    baseList.add(new KnuthGlue(this.lineStartBAP + p3WidthOffset, 0, 0, pos3, false));
                    break;
                }
                baseList.add(new KnuthGlue(((AreaInfo)ai).areaIPD.opt, ((AreaInfo)ai).areaIPD.max - ((AreaInfo)ai).areaIPD.opt, 0, pos2, false));
            }
        }
    }

    private void addElementsForAWordFragment(List baseList, int alignment, AreaInfo ai, int leafValue, MinOptMax letterSpaceWidth) {
        boolean suppressibleLetterSpace;
        LeafPosition mainPosition = new LeafPosition(this, leafValue);
        boolean bl = suppressibleLetterSpace = ai.breakOppAfter && !ai.isHyphenated;
        if (letterSpaceWidth.min == letterSpaceWidth.max) {
            baseList.add(new KnuthInlineBox(suppressibleLetterSpace ? ((AreaInfo)ai).areaIPD.opt - letterSpaceWidth.opt : ((AreaInfo)ai).areaIPD.opt, this.alignmentContext, this.notifyPos(mainPosition), false));
        } else {
            int unsuppressibleLetterSpaces = suppressibleLetterSpace ? ai.letterSpaceCount - 1 : ai.letterSpaceCount;
            baseList.add(new KnuthInlineBox(((AreaInfo)ai).areaIPD.opt - ai.letterSpaceCount * letterSpaceWidth.opt, this.alignmentContext, this.notifyPos(mainPosition), false));
            baseList.add(this.makeZeroWidthPenalty(1000));
            baseList.add(new KnuthGlue(unsuppressibleLetterSpaces * letterSpaceWidth.opt, unsuppressibleLetterSpaces * (letterSpaceWidth.max - letterSpaceWidth.opt), unsuppressibleLetterSpaces * (letterSpaceWidth.opt - letterSpaceWidth.min), this.auxiliaryPosition, true));
            baseList.add(this.makeAuxiliaryZeroWidthBox());
        }
        if (ai.isHyphenated) {
            MinOptMax widthIfNoBreakOccurs = null;
            if (ai.breakIndex < this.foText.length()) {
                widthIfNoBreakOccurs = this.letterAdjustArray[ai.breakIndex];
            }
            this.addElementsForAHyphen(baseList, alignment, this.hyphIPD, widthIfNoBreakOccurs, ai.breakOppAfter && ai.isHyphenated);
        } else if (suppressibleLetterSpace) {
            this.addElementsForAHyphen(baseList, alignment, 0, letterSpaceWidth, true);
        }
    }

    private void addElementsForAHyphen(List baseList, int alignment, int widthIfBreakOccurs, MinOptMax widthIfNoBreakOccurs, boolean unflagged) {
        if (widthIfNoBreakOccurs == null) {
            widthIfNoBreakOccurs = ZERO_MINOPTMAX;
        }
        switch (alignment) {
            case 23: {
                baseList.add(this.makeZeroWidthPenalty(1000));
                baseList.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, true));
                baseList.add(new KnuthPenalty(this.hyphIPD, unflagged ? 1 : 50, !unflagged, this.auxiliaryPosition, false));
                baseList.add(new KnuthGlue(-(this.lineEndBAP + this.lineStartBAP), -20016, 0, this.auxiliaryPosition, false));
                baseList.add(this.makeAuxiliaryZeroWidthBox());
                baseList.add(this.makeZeroWidthPenalty(1000));
                baseList.add(new KnuthGlue(this.lineStartBAP, 10008, 0, this.auxiliaryPosition, true));
                break;
            }
            case 39: 
            case 135: {
                if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    baseList.add(this.makeZeroWidthPenalty(1000));
                    baseList.add(new KnuthGlue(this.lineEndBAP, 10008, 0, this.auxiliaryPosition, false));
                    baseList.add(new KnuthPenalty(widthIfBreakOccurs, unflagged ? 1 : 50, !unflagged, this.auxiliaryPosition, false));
                    baseList.add(new KnuthGlue(widthIfNoBreakOccurs.opt - (this.lineStartBAP + this.lineEndBAP), -10008, 0, this.auxiliaryPosition, false));
                    baseList.add(this.makeAuxiliaryZeroWidthBox());
                    baseList.add(this.makeZeroWidthPenalty(1000));
                    baseList.add(new KnuthGlue(this.lineStartBAP, 0, 0, this.auxiliaryPosition, false));
                    break;
                }
                baseList.add(this.makeZeroWidthPenalty(1000));
                baseList.add(new KnuthGlue(0, 10008, 0, this.auxiliaryPosition, false));
                baseList.add(new KnuthPenalty(widthIfBreakOccurs, unflagged ? 1 : 50, !unflagged, this.auxiliaryPosition, false));
                baseList.add(new KnuthGlue(widthIfNoBreakOccurs.opt, -10008, 0, this.auxiliaryPosition, false));
                break;
            }
            default: {
                if (this.lineStartBAP != 0 || this.lineEndBAP != 0) {
                    baseList.add(this.makeZeroWidthPenalty(1000));
                    baseList.add(new KnuthGlue(this.lineEndBAP, 0, 0, this.auxiliaryPosition, false));
                    baseList.add(new KnuthPenalty(widthIfBreakOccurs, unflagged ? 1 : 50, !unflagged, this.auxiliaryPosition, false));
                    if (widthIfNoBreakOccurs.min != 0 || widthIfNoBreakOccurs.max != 0) {
                        baseList.add(new KnuthGlue(widthIfNoBreakOccurs.opt - (this.lineStartBAP + this.lineEndBAP), widthIfNoBreakOccurs.max - widthIfNoBreakOccurs.opt, widthIfNoBreakOccurs.opt - widthIfNoBreakOccurs.min, this.auxiliaryPosition, false));
                    } else {
                        baseList.add(new KnuthGlue(-(this.lineStartBAP + this.lineEndBAP), 0, 0, this.auxiliaryPosition, false));
                    }
                    baseList.add(this.makeAuxiliaryZeroWidthBox());
                    baseList.add(this.makeZeroWidthPenalty(1000));
                    baseList.add(new KnuthGlue(this.lineStartBAP, 0, 0, this.auxiliaryPosition, false));
                    break;
                }
                baseList.add(new KnuthPenalty(widthIfBreakOccurs, unflagged ? 1 : 50, !unflagged, this.auxiliaryPosition, false));
                if (widthIfNoBreakOccurs.min == 0 && widthIfNoBreakOccurs.max == 0) break;
                baseList.add(new KnuthGlue(widthIfNoBreakOccurs.opt, widthIfNoBreakOccurs.max - widthIfNoBreakOccurs.opt, widthIfNoBreakOccurs.opt - widthIfNoBreakOccurs.min, this.auxiliaryPosition, false));
            }
        }
    }

    private final class PendingChange {
        private final AreaInfo ai;
        private final int index;

        private PendingChange(AreaInfo ai, int index) {
            this.ai = ai;
            this.index = index;
        }
    }

    private class AreaInfo {
        private final int startIndex;
        private final int breakIndex;
        private final int wordSpaceCount;
        private int letterSpaceCount;
        private final MinOptMax areaIPD;
        private final boolean isHyphenated;
        private final boolean isSpace;
        private boolean breakOppAfter;
        private final Font font;

        AreaInfo(int startIndex, int breakIndex, int wordSpaceCount, int letterSpaceCount, MinOptMax areaIPD, boolean isHyphenated, boolean isSpace, boolean breakOppAfter, Font font) {
            this.startIndex = startIndex;
            this.breakIndex = breakIndex;
            this.wordSpaceCount = wordSpaceCount;
            this.letterSpaceCount = letterSpaceCount;
            this.areaIPD = areaIPD;
            this.isHyphenated = isHyphenated;
            this.isSpace = isSpace;
            this.breakOppAfter = breakOppAfter;
            this.font = font;
        }

        public String toString() {
            return "[ lscnt=" + this.letterSpaceCount + ", wscnt=" + this.wordSpaceCount + ", ipd=" + this.areaIPD.toString() + ", sidx=" + this.startIndex + ", bidx=" + this.breakIndex + ", hyph=" + this.isHyphenated + ", space=" + this.isSpace + ", font=" + this.font + "]";
        }
    }
}

