/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.afp.fonts;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.afp.fonts.AFPFont;
import org.apache.fop.afp.fonts.CharacterSet;
import org.apache.fop.afp.fonts.FontRuntimeException;

public class RasterFont
extends AFPFont {
    protected static final Log log = LogFactory.getLog((String)"org.apache.fop.afp.fonts");
    private final SortedMap charSets = new TreeMap();
    private Map substitutionCharSets;
    private CharacterSet charSet = null;

    public RasterFont(String name) {
        super(name);
    }

    public void addCharacterSet(int size, CharacterSet characterSet) {
        this.charSets.put(new Integer(size), characterSet);
        this.charSet = characterSet;
    }

    public CharacterSet getCharacterSet(int size) {
        Integer requestedSize = new Integer(size);
        CharacterSet csm = (CharacterSet)this.charSets.get(requestedSize);
        if (csm != null) {
            return csm;
        }
        if (this.substitutionCharSets != null) {
            csm = (CharacterSet)this.substitutionCharSets.get(requestedSize);
        }
        if (csm == null && !this.charSets.isEmpty()) {
            int largerSize;
            SortedMap smallerSizes = this.charSets.headMap(requestedSize);
            SortedMap largerSizes = this.charSets.tailMap(requestedSize);
            int smallerSize = smallerSizes.isEmpty() ? 0 : smallerSizes.lastKey();
            Integer fontSize = size - smallerSize <= (largerSize = largerSizes.isEmpty() ? Integer.MAX_VALUE : largerSizes.firstKey()) - size ? new Integer(smallerSize) : new Integer(largerSize);
            csm = (CharacterSet)this.charSets.get(fontSize);
            if (csm != null) {
                if (this.substitutionCharSets == null) {
                    this.substitutionCharSets = new HashMap();
                }
                this.substitutionCharSets.put(requestedSize, csm);
                String msg = "No " + (float)size / 1000.0f + "pt font " + this.getFontName() + " found, substituted with " + (float)fontSize.intValue() / 1000.0f + "pt font";
                log.warn((Object)msg);
            }
        }
        if (csm == null) {
            String msg = "No font found for font " + this.getFontName() + " with point size " + (float)size / 1000.0f;
            log.error((Object)msg);
            throw new FontRuntimeException(msg);
        }
        return csm;
    }

    public int getFirstChar() {
        Iterator it = this.charSets.values().iterator();
        if (it.hasNext()) {
            CharacterSet csm = (CharacterSet)it.next();
            return csm.getFirstChar();
        }
        String msg = "getFirstChar() - No character set found for font:" + this.getFontName();
        log.error((Object)msg);
        throw new FontRuntimeException(msg);
    }

    public int getLastChar() {
        Iterator it = this.charSets.values().iterator();
        if (it.hasNext()) {
            CharacterSet csm = (CharacterSet)it.next();
            return csm.getLastChar();
        }
        String msg = "getLastChar() - No character set found for font:" + this.getFontName();
        log.error((Object)msg);
        throw new FontRuntimeException(msg);
    }

    public int getAscender(int size) {
        return this.getCharacterSet(size).getAscender() * size;
    }

    public int getCapHeight(int size) {
        return this.getCharacterSet(size).getCapHeight() * size;
    }

    public int getDescender(int size) {
        return this.getCharacterSet(size).getDescender() * size;
    }

    public int getXHeight(int size) {
        return this.getCharacterSet(size).getXHeight() * size;
    }

    public int getWidth(int character, int size) {
        return this.getCharacterSet(size).getWidth(character) * size;
    }

    public int[] getWidths(int size) {
        return this.getCharacterSet(size).getWidths();
    }

    public int[] getWidths() {
        return this.getWidths(1000);
    }

    public boolean hasChar(char c) {
        return this.charSet.hasChar(c);
    }

    public char mapChar(char c) {
        return this.charSet.mapChar(c);
    }

    public String getEncodingName() {
        return this.charSet.getEncoding();
    }
}

