/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.util.HashMap;
import org.apache.fop.events.Event;
import org.apache.fop.events.EventBroadcaster;
import org.apache.fop.events.model.EventSeverity;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontTriplet;

public class FontEventAdapter
implements FontEventListener {
    private EventBroadcaster eventBroadcaster;

    public FontEventAdapter(EventBroadcaster broadcaster) {
        this.eventBroadcaster = broadcaster;
    }

    protected String getEventGroupID() {
        return this.getClass().getName();
    }

    public void fontSubstituted(Object source, FontTriplet requested, FontTriplet effective) {
        HashMap<String, FontTriplet> params = new HashMap<String, FontTriplet>();
        params.put("requested", requested);
        params.put("effective", effective);
        Event ev = new Event(source, this.getEventGroupID() + ".fontSubstituted", EventSeverity.WARN, params);
        this.eventBroadcaster.broadcastEvent(ev);
    }

    public void fontLoadingErrorAtAutoDetection(Object source, String fontURL, Exception e) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("fontURL", fontURL);
        params.put("e", e);
        Event ev = new Event(source, this.getEventGroupID() + ".fontLoadingErrorAtAutoDetection", EventSeverity.WARN, params);
        this.eventBroadcaster.broadcastEvent(ev);
    }

    public void glyphNotAvailable(Object source, char ch, String fontName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("ch", new Character(ch));
        params.put("fontName", fontName);
        Event ev = new Event(source, this.getEventGroupID() + ".glyphNotAvailable", EventSeverity.WARN, params);
        this.eventBroadcaster.broadcastEvent(ev);
    }
}

