/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.apps.FOPException;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.EncodingMode;
import org.apache.fop.fonts.FontAdder;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontDetector;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.FontResolver;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.fonts.FontUtil;
import org.apache.fop.fonts.autodetect.FontFileFinder;
import org.apache.fop.fonts.autodetect.FontInfoFinder;
import org.apache.fop.util.LogUtil;

public class FontInfoConfigurator {
    protected static Log log = LogFactory.getLog((Class)FontInfoConfigurator.class);
    private Configuration cfg;
    private FontManager fontManager;
    private FontResolver fontResolver;
    private FontEventListener listener;
    private boolean strict;

    public FontInfoConfigurator(Configuration cfg, FontManager fontManager, FontResolver fontResolver, FontEventListener listener, boolean strict) {
        this.cfg = cfg;
        this.fontManager = fontManager;
        this.fontResolver = fontResolver;
        this.listener = listener;
        this.strict = strict;
    }

    public void configure(List fontInfoList) throws FOPException {
        Configuration fonts = this.cfg.getChild("fonts", false);
        if (fonts != null) {
            boolean autodetectFonts;
            long start = 0L;
            if (log.isDebugEnabled()) {
                log.debug((Object)"Starting font configuration...");
                start = System.currentTimeMillis();
            }
            FontAdder fontAdder = new FontAdder(this.fontManager, this.fontResolver, this.listener);
            boolean bl = autodetectFonts = fonts.getChild("auto-detect", false) != null;
            if (autodetectFonts) {
                FontDetector fontDetector = new FontDetector(this.fontManager, fontAdder, this.strict);
                fontDetector.detect(fontInfoList);
            }
            this.addDirectories(fonts, fontAdder, fontInfoList);
            FontCache fontCache = this.fontManager.getFontCache();
            this.addFonts(fonts, fontCache, fontInfoList);
            this.fontManager.updateReferencedFonts(fontInfoList);
            if (fontCache != null && fontCache.hasChanged()) {
                fontCache.save();
            }
            if (log.isDebugEnabled()) {
                log.debug((Object)("Finished font configuration in " + (System.currentTimeMillis() - start) + "ms"));
            }
        }
    }

    private void addDirectories(Configuration fontsCfg, FontAdder fontAdder, List fontInfoList) throws FOPException {
        Configuration[] directories = fontsCfg.getChildren("directory");
        for (int i = 0; i < directories.length; ++i) {
            boolean recursive = directories[i].getAttributeAsBoolean("recursive", false);
            String directory = null;
            try {
                directory = directories[i].getValue();
            }
            catch (ConfigurationException e) {
                LogUtil.handleException(log, (Exception)((Object)e), this.strict);
                continue;
            }
            if (directory == null) {
                LogUtil.handleException(log, new FOPException("directory defined without value"), this.strict);
                continue;
            }
            FontFileFinder fontFileFinder = new FontFileFinder(recursive ? -1 : 1);
            try {
                List fontURLList = fontFileFinder.find(directory);
                fontAdder.add(fontURLList, fontInfoList);
                continue;
            }
            catch (IOException e) {
                LogUtil.handleException(log, e, this.strict);
            }
        }
    }

    protected void addFonts(Configuration fontsCfg, FontCache fontCache, List fontInfoList) throws FOPException {
        Configuration[] font = fontsCfg.getChildren("font");
        for (int i = 0; i < font.length; ++i) {
            EmbedFontInfo embedFontInfo = this.getFontInfo(font[i], fontCache);
            if (embedFontInfo == null) continue;
            fontInfoList.add(embedFontInfo);
        }
    }

    private static void closeSource(Source src) {
        if (src instanceof StreamSource) {
            StreamSource streamSource = (StreamSource)src;
            IOUtils.closeQuietly((InputStream)streamSource.getInputStream());
            IOUtils.closeQuietly((Reader)streamSource.getReader());
        }
    }

    protected EmbedFontInfo getFontInfo(Configuration fontCfg, FontCache fontCache) throws FOPException {
        Configuration[] tripletCfg;
        String metricsUrl = fontCfg.getAttribute("metrics-url", null);
        String embedUrl = fontCfg.getAttribute("embed-url", null);
        String subFont = fontCfg.getAttribute("sub-font", null);
        if (metricsUrl == null && embedUrl == null) {
            LogUtil.handleError(log, "Font configuration without metric-url or embed-url attribute", this.strict);
            return null;
        }
        if (this.strict) {
            Source source;
            if (embedUrl != null) {
                source = this.fontResolver.resolve(embedUrl);
                FontInfoConfigurator.closeSource(source);
                if (source == null) {
                    LogUtil.handleError(log, "Failed to resolve font with embed-url '" + embedUrl + "'", this.strict);
                    return null;
                }
            }
            if (metricsUrl != null) {
                source = this.fontResolver.resolve(metricsUrl);
                FontInfoConfigurator.closeSource(source);
                if (source == null) {
                    LogUtil.handleError(log, "Failed to resolve font with metric-url '" + metricsUrl + "'", this.strict);
                    return null;
                }
            }
        }
        if ((tripletCfg = fontCfg.getChildren("font-triplet")).length == 0) {
            URL fontUrl;
            LogUtil.handleError(log, "font without font-triplet", this.strict);
            File fontFile = FontCache.getFileFromUrls(new String[]{embedUrl, metricsUrl});
            try {
                fontUrl = fontFile.toURI().toURL();
            }
            catch (MalformedURLException e) {
                log.debug((Object)("Malformed Url: " + e.getMessage()));
                return null;
            }
            if (fontFile != null) {
                FontInfoFinder finder = new FontInfoFinder();
                finder.setEventListener(this.listener);
                EmbedFontInfo[] infos = finder.find(fontUrl, this.fontResolver, fontCache);
                return infos[0];
            }
            return null;
        }
        ArrayList<FontTriplet> tripletList = new ArrayList<FontTriplet>();
        for (int j = 0; j < tripletCfg.length; ++j) {
            FontTriplet fontTriplet = this.getFontTriplet(tripletCfg[j]);
            tripletList.add(fontTriplet);
        }
        boolean useKerning = fontCfg.getAttributeAsBoolean("kerning", true);
        EncodingMode encodingMode = EncodingMode.valueOf(fontCfg.getAttribute("encoding-mode", EncodingMode.AUTO.getName()));
        EmbedFontInfo embedFontInfo = new EmbedFontInfo(metricsUrl, useKerning, tripletList, embedUrl, subFont);
        embedFontInfo.setEncodingMode(encodingMode);
        if (fontCache != null && !fontCache.containsFont(embedFontInfo)) {
            fontCache.addFont(embedFontInfo);
        }
        if (log.isDebugEnabled()) {
            String embedFile = embedFontInfo.getEmbedFile();
            log.debug((Object)("Adding font " + (embedFile != null ? embedFile + ", " : "") + "metric file " + embedFontInfo.getMetricsFile()));
            for (int j = 0; j < tripletList.size(); ++j) {
                FontTriplet triplet = (FontTriplet)tripletList.get(j);
                log.debug((Object)("  Font triplet " + triplet.getName() + ", " + triplet.getStyle() + ", " + triplet.getWeight()));
            }
        }
        return embedFontInfo;
    }

    private FontTriplet getFontTriplet(Configuration tripletCfg) throws FOPException {
        try {
            String name = tripletCfg.getAttribute("name");
            if (name == null) {
                LogUtil.handleError(log, "font-triplet without name", this.strict);
                return null;
            }
            String weightStr = tripletCfg.getAttribute("weight");
            if (weightStr == null) {
                LogUtil.handleError(log, "font-triplet without weight", this.strict);
                return null;
            }
            int weight = FontUtil.parseCSS2FontWeight(FontUtil.stripWhiteSpace(weightStr));
            String style = tripletCfg.getAttribute("style");
            if (style == null) {
                LogUtil.handleError(log, "font-triplet without style", this.strict);
                return null;
            }
            style = FontUtil.stripWhiteSpace(style);
            return FontInfo.createFontKey(name, style, weight);
        }
        catch (ConfigurationException e) {
            LogUtil.handleException(log, (Exception)((Object)e), this.strict);
            return null;
        }
    }
}

