/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.area.Area;
import org.apache.fop.area.Block;
import org.apache.fop.area.LineArea;
import org.apache.fop.datatypes.Length;
import org.apache.fop.fo.properties.KeepProperty;
import org.apache.fop.fonts.Font;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.fonts.FontTriplet;
import org.apache.fop.layoutmgr.BlockStackingLayoutManager;
import org.apache.fop.layoutmgr.ConditionalElementListener;
import org.apache.fop.layoutmgr.KeepUtil;
import org.apache.fop.layoutmgr.KnuthElement;
import org.apache.fop.layoutmgr.KnuthPossPosIter;
import org.apache.fop.layoutmgr.LMiter;
import org.apache.fop.layoutmgr.LayoutContext;
import org.apache.fop.layoutmgr.LayoutManager;
import org.apache.fop.layoutmgr.NonLeafPosition;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.layoutmgr.PositionIterator;
import org.apache.fop.layoutmgr.RelSide;
import org.apache.fop.layoutmgr.TraitSetter;
import org.apache.fop.layoutmgr.inline.InlineLevelLayoutManager;
import org.apache.fop.layoutmgr.inline.LineLayoutManager;
import org.apache.fop.traits.MinOptMax;
import org.apache.fop.traits.SpaceVal;

public class BlockLayoutManager
extends BlockStackingLayoutManager
implements ConditionalElementListener {
    private static Log log = LogFactory.getLog((Class)BlockLayoutManager.class);
    private Block curBlockArea;
    protected ListIterator proxyLMiter;
    private int lead = 12000;
    private Length lineHeight;
    private int follow = 2000;
    private boolean discardBorderBefore;
    private boolean discardBorderAfter;
    private boolean discardPaddingBefore;
    private boolean discardPaddingAfter;
    private MinOptMax effSpaceBefore;
    private MinOptMax effSpaceAfter;
    protected List childBreaks = new ArrayList();

    public BlockLayoutManager(org.apache.fop.fo.flow.Block inBlock) {
        super(inBlock);
        this.proxyLMiter = new ProxyLMiter();
    }

    public void initialize() {
        super.initialize();
        FontInfo fi = this.getBlockFO().getFOEventHandler().getFontInfo();
        FontTriplet[] fontkeys = this.getBlockFO().getCommonFont().getFontState(fi);
        Font initFont = fi.getFontInstance(fontkeys[0], this.getBlockFO().getCommonFont().fontSize.getValue(this));
        this.lead = initFont.getAscender();
        this.follow = -initFont.getDescender();
        this.lineHeight = this.getBlockFO().getLineHeight().getOptimum(this).getLength();
        this.startIndent = this.getBlockFO().getCommonMarginBlock().startIndent.getValue(this);
        this.endIndent = this.getBlockFO().getCommonMarginBlock().endIndent.getValue(this);
        this.foSpaceBefore = new SpaceVal(this.getBlockFO().getCommonMarginBlock().spaceBefore, this).getSpace();
        this.foSpaceAfter = new SpaceVal(this.getBlockFO().getCommonMarginBlock().spaceAfter, this).getSpace();
        this.bpUnit = 0;
        if (this.bpUnit == 0) {
            this.adjustedSpaceBefore = this.getBlockFO().getCommonMarginBlock().spaceBefore.getSpace().getOptimum(this).getLength().getValue(this);
            this.adjustedSpaceAfter = this.getBlockFO().getCommonMarginBlock().spaceAfter.getSpace().getOptimum(this).getLength().getValue(this);
        } else {
            this.adjustedSpaceBefore = this.getBlockFO().getCommonMarginBlock().spaceBefore.getSpace().getMinimum(this).getLength().getValue(this);
            this.adjustedSpaceAfter = this.getBlockFO().getCommonMarginBlock().spaceAfter.getSpace().getMinimum(this).getLength().getValue(this);
        }
    }

    public List getNextKnuthElements(LayoutContext context, int alignment) {
        this.resetSpaces();
        return super.getNextKnuthElements(context, alignment);
    }

    private void resetSpaces() {
        this.discardBorderBefore = false;
        this.discardBorderAfter = false;
        this.discardPaddingBefore = false;
        this.discardPaddingAfter = false;
        this.effSpaceBefore = null;
        this.effSpaceAfter = null;
    }

    public boolean createNextChildLMs(int pos) {
        while (this.proxyLMiter.hasNext()) {
            LayoutManager lm = (LayoutManager)this.proxyLMiter.next();
            if (lm instanceof InlineLevelLayoutManager) {
                LineLayoutManager lineLM = this.createLineManager(lm);
                this.addChildLM(lineLM);
            } else {
                this.addChildLM(lm);
            }
            if (pos >= this.childLMs.size()) continue;
            return true;
        }
        return false;
    }

    private LineLayoutManager createLineManager(LayoutManager firstlm) {
        LineLayoutManager llm = new LineLayoutManager(this.getBlockFO(), this.lineHeight, this.lead, this.follow);
        ArrayList<LayoutManager> inlines = new ArrayList<LayoutManager>();
        inlines.add(firstlm);
        while (this.proxyLMiter.hasNext()) {
            LayoutManager lm = (LayoutManager)this.proxyLMiter.next();
            if (lm instanceof InlineLevelLayoutManager) {
                inlines.add(lm);
                continue;
            }
            this.proxyLMiter.previous();
            break;
        }
        llm.addChildLMs(inlines);
        return llm;
    }

    public int getKeepTogetherStrength() {
        KeepProperty keep = this.getBlockFO().getKeepTogether();
        int strength = KeepUtil.getCombinedBlockLevelKeepStrength(keep);
        strength = Math.max(strength, this.getParentKeepTogetherStrength());
        return strength;
    }

    public int getKeepWithNextStrength() {
        return KeepUtil.getCombinedBlockLevelKeepStrength(this.getBlockFO().getKeepWithNext());
    }

    public int getKeepWithPreviousStrength() {
        return KeepUtil.getCombinedBlockLevelKeepStrength(this.getBlockFO().getKeepWithPrevious());
    }

    public void addAreas(PositionIterator parentIter, LayoutContext layoutContext) {
        LayoutManager childLM;
        PositionIterator childPosIter;
        this.getParentArea(null);
        if (layoutContext.getSpaceBefore() > 0) {
            this.addBlockSpacing(0.0, new MinOptMax(layoutContext.getSpaceBefore()));
        }
        LayoutManager lastLM = null;
        LayoutContext lc = new LayoutContext(0);
        lc.setSpaceAdjust(layoutContext.getSpaceAdjust());
        if (layoutContext.getSpaceAfter() > 0) {
            lc.setSpaceAfter(layoutContext.getSpaceAfter());
        }
        LinkedList<Position> positionList = new LinkedList<Position>();
        boolean bSpaceBefore = false;
        boolean bSpaceAfter = false;
        Position firstPos = null;
        Position lastPos = null;
        while (parentIter.hasNext()) {
            Position pos = (Position)parentIter.next();
            if (pos.getIndex() >= 0) {
                if (firstPos == null) {
                    firstPos = pos;
                }
                lastPos = pos;
            }
            Position innerPosition = pos;
            if (pos instanceof NonLeafPosition) {
                innerPosition = pos.getPosition();
            }
            if (innerPosition == null) {
                if (positionList.size() == 0) {
                    bSpaceBefore = true;
                    continue;
                }
                bSpaceAfter = true;
                continue;
            }
            if (innerPosition.getLM() == this && !(innerPosition instanceof BlockStackingLayoutManager.MappingPosition)) continue;
            positionList.add(innerPosition);
            lastLM = innerPosition.getLM();
        }
        this.addId();
        this.addMarkersToPage(true, this.isFirst(firstPos), this.isLast(lastPos));
        if (this.bpUnit == 0) {
            childPosIter = new BlockStackingLayoutManager.StackingIter(positionList.listIterator());
        } else {
            LinkedList<KnuthElement> splitList = new LinkedList<KnuthElement>();
            int splitLength = 0;
            int iFirst = ((BlockStackingLayoutManager.MappingPosition)positionList.getFirst()).getFirstIndex();
            int iLast = ((BlockStackingLayoutManager.MappingPosition)positionList.getLast()).getLastIndex();
            ListIterator storedListIterator = this.storedList.listIterator(iFirst);
            while (storedListIterator.nextIndex() <= iLast) {
                KnuthElement element = (KnuthElement)storedListIterator.next();
                if (element.getLayoutManager() == this) continue;
                splitList.add(element);
                splitLength += element.getW();
                lastLM = element.getLayoutManager();
            }
            if (bSpaceBefore && bSpaceAfter) {
                this.foSpaceBefore = new SpaceVal(this.getBlockFO().getCommonMarginBlock().spaceBefore, this).getSpace();
                this.foSpaceAfter = new SpaceVal(this.getBlockFO().getCommonMarginBlock().spaceAfter, this).getSpace();
                this.adjustedSpaceBefore = (this.neededUnits(splitLength + this.foSpaceBefore.min + this.foSpaceAfter.min) * this.bpUnit - splitLength) / 2;
                this.adjustedSpaceAfter = this.neededUnits(splitLength + this.foSpaceBefore.min + this.foSpaceAfter.min) * this.bpUnit - splitLength - this.adjustedSpaceBefore;
            } else if (bSpaceBefore) {
                this.adjustedSpaceBefore = this.neededUnits(splitLength + this.foSpaceBefore.min) * this.bpUnit - splitLength;
            } else {
                this.adjustedSpaceAfter = this.neededUnits(splitLength + this.foSpaceAfter.min) * this.bpUnit - splitLength;
            }
            childPosIter = new KnuthPossPosIter(splitList, 0, splitList.size());
        }
        while ((childLM = childPosIter.getNextChildLM()) != null) {
            lc.setFlags(128, layoutContext.isLastArea() && childLM == lastLM);
            lc.setStackLimitBP(layoutContext.getStackLimitBP());
            childLM.addAreas(childPosIter, lc);
        }
        this.addMarkersToPage(false, this.isFirst(firstPos), this.isLast(lastPos));
        TraitSetter.addSpaceBeforeAfter(this.curBlockArea, layoutContext.getSpaceAdjust(), this.effSpaceBefore, this.effSpaceAfter);
        this.flush();
        this.curBlockArea = null;
        this.resetSpaces();
        this.checkEndOfLayout(lastPos);
    }

    public Area getParentArea(Area childArea) {
        if (this.curBlockArea == null) {
            this.curBlockArea = new Block();
            this.curBlockArea.setIPD(super.getContentAreaIPD());
            TraitSetter.addBreaks(this.curBlockArea, this.getBlockFO().getBreakBefore(), this.getBlockFO().getBreakAfter());
            this.parentLM.getParentArea(this.curBlockArea);
            TraitSetter.setProducerID(this.curBlockArea, this.getBlockFO().getId());
            TraitSetter.addBorders(this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), this.discardBorderBefore, this.discardBorderAfter, false, false, this);
            TraitSetter.addPadding(this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), this.discardPaddingBefore, this.discardPaddingAfter, false, false, this);
            TraitSetter.addMargins(this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), this.startIndent, this.endIndent, this);
            this.setCurrentArea(this.curBlockArea);
        }
        return this.curBlockArea;
    }

    public void addChildArea(Area childArea) {
        if (this.curBlockArea != null) {
            if (childArea instanceof LineArea) {
                this.curBlockArea.addLineArea((LineArea)childArea);
            } else {
                this.curBlockArea.addBlock((Block)childArea);
            }
        }
    }

    protected void flush() {
        if (this.curBlockArea != null) {
            TraitSetter.addBackground(this.curBlockArea, this.getBlockFO().getCommonBorderPaddingBackground(), this);
            super.flush();
        }
    }

    protected org.apache.fop.fo.flow.Block getBlockFO() {
        return (org.apache.fop.fo.flow.Block)this.fobj;
    }

    public int getContentAreaIPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getIPD();
        }
        return super.getContentAreaIPD();
    }

    public int getContentAreaBPD() {
        if (this.curBlockArea != null) {
            return this.curBlockArea.getBPD();
        }
        return -1;
    }

    public boolean getGeneratesBlockArea() {
        return true;
    }

    public void notifySpace(RelSide side, MinOptMax effectiveLength) {
        if (RelSide.BEFORE == side) {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + side + ", " + this.effSpaceBefore + "-> " + effectiveLength));
            }
            this.effSpaceBefore = effectiveLength;
        } else {
            if (log.isDebugEnabled()) {
                log.debug((Object)(this + ": Space " + side + ", " + this.effSpaceAfter + "-> " + effectiveLength));
            }
            this.effSpaceAfter = effectiveLength;
        }
    }

    public void notifyBorder(RelSide side, MinOptMax effectiveLength) {
        if (effectiveLength == null) {
            if (RelSide.BEFORE == side) {
                this.discardBorderBefore = true;
            } else {
                this.discardBorderAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Border " + side + " -> " + effectiveLength));
        }
    }

    public void notifyPadding(RelSide side, MinOptMax effectiveLength) {
        if (effectiveLength == null) {
            if (RelSide.BEFORE == side) {
                this.discardPaddingBefore = true;
            } else {
                this.discardPaddingAfter = true;
            }
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)(this + ": Padding " + side + " -> " + effectiveLength));
        }
    }

    protected class ProxyLMiter
    extends LMiter {
        public ProxyLMiter() {
            super(BlockLayoutManager.this);
            this.listLMs = new ArrayList(10);
        }

        public boolean hasNext() {
            return this.curPos < this.listLMs.size() || this.createNextChildLMs(this.curPos);
        }

        protected boolean createNextChildLMs(int pos) {
            List newLMs = BlockLayoutManager.this.createChildLMs(pos + 1 - this.listLMs.size());
            if (newLMs != null) {
                this.listLMs.addAll(newLMs);
            }
            return pos < this.listLMs.size();
        }
    }
}

