/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.layoutmgr;

import java.util.LinkedList;
import java.util.List;
import org.apache.fop.layoutmgr.KnuthBox;
import org.apache.fop.layoutmgr.Position;
import org.apache.fop.traits.MinOptMax;

public class KnuthBlockBox
extends KnuthBox {
    private MinOptMax ipdRange;
    private int bpd;
    private List footnoteList;
    private List elementLists = null;

    public KnuthBlockBox(int w, MinOptMax range, int bpdim, Position pos, boolean bAux) {
        super(w, pos, bAux);
        this.ipdRange = (MinOptMax)range.clone();
        this.bpd = bpdim;
        this.footnoteList = new LinkedList();
    }

    public KnuthBlockBox(int w, List list, Position pos, boolean bAux) {
        super(w, pos, bAux);
        this.ipdRange = new MinOptMax(0);
        this.bpd = 0;
        this.footnoteList = new LinkedList(list);
    }

    public List getFootnoteBodyLMs() {
        return this.footnoteList;
    }

    public boolean hasAnchors() {
        return this.footnoteList.size() > 0;
    }

    public void addElementList(List list) {
        if (this.elementLists == null) {
            this.elementLists = new LinkedList();
        }
        this.elementLists.add(list);
    }

    public List getElementLists() {
        return this.elementLists;
    }

    public MinOptMax getIPDRange() {
        return (MinOptMax)this.ipdRange.clone();
    }

    public int getBPD() {
        return this.bpd;
    }
}

