/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.render.bitmap;

import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.fop.fonts.FontInfo;
import org.apache.fop.render.bitmap.BitmapRendererEventProducer;
import org.apache.fop.render.bitmap.BitmapRenderingSettings;
import org.apache.fop.render.bitmap.TIFFConstants;
import org.apache.fop.render.bitmap.TIFFRendererConfigurator;
import org.apache.fop.render.intermediate.AbstractBinaryWritingIFDocumentHandler;
import org.apache.fop.render.intermediate.IFContext;
import org.apache.fop.render.intermediate.IFDocumentHandlerConfigurator;
import org.apache.fop.render.intermediate.IFException;
import org.apache.fop.render.intermediate.IFPainter;
import org.apache.fop.render.java2d.Java2DPainter;
import org.apache.fop.render.java2d.Java2DUtil;
import org.apache.xmlgraphics.image.writer.ImageWriter;
import org.apache.xmlgraphics.image.writer.ImageWriterRegistry;
import org.apache.xmlgraphics.image.writer.MultiImageWriter;

public class TIFFDocumentHandler
extends AbstractBinaryWritingIFDocumentHandler
implements TIFFConstants {
    private static Log log = LogFactory.getLog((Class)TIFFDocumentHandler.class);
    private ImageWriter imageWriter;
    private MultiImageWriter multiImageWriter;
    private int pageCount;
    private Dimension currentPageDimensions;
    private BufferedImage currentImage;
    private BitmapRenderingSettings bitmapSettings = new BitmapRenderingSettings();
    private double scaleFactor = 1.0;

    public boolean supportsPagesOutOfOrder() {
        return false;
    }

    public String getMimeType() {
        return "image/tiff";
    }

    public void setContext(IFContext context) {
        super.setContext(context);
        int dpi = Math.round(context.getUserAgent().getTargetResolution());
        this.getSettings().getWriterParams().setResolution(dpi);
    }

    public IFDocumentHandlerConfigurator getConfigurator() {
        return new TIFFRendererConfigurator(this.getUserAgent());
    }

    public BitmapRenderingSettings getSettings() {
        return this.bitmapSettings;
    }

    public void setDefaultFontInfo(FontInfo fontInfo) {
        FontInfo fi = Java2DUtil.buildDefaultJava2DBasedFontInfo(fontInfo, this.getUserAgent());
        this.setFontInfo(fi);
    }

    public void startDocument() throws IFException {
        super.startDocument();
        try {
            this.imageWriter = ImageWriterRegistry.getInstance().getWriterFor(this.getMimeType());
            if (this.imageWriter == null) {
                BitmapRendererEventProducer eventProducer = BitmapRendererEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                eventProducer.noImageWriterFound(this, this.getMimeType());
            }
            if (this.imageWriter.supportsMultiImageWriter()) {
                this.multiImageWriter = this.imageWriter.createMultiImageWriter(this.outputStream);
            }
            this.pageCount = 0;
        }
        catch (IOException e) {
            throw new IFException("I/O error in startDocument()", e);
        }
    }

    public void endDocumentHeader() throws IFException {
    }

    public void endDocument() throws IFException {
        try {
            if (this.multiImageWriter != null) {
                this.multiImageWriter.close();
            }
            this.multiImageWriter = null;
            this.imageWriter = null;
        }
        catch (IOException ioe) {
            throw new IFException("I/O error in endDocument()", ioe);
        }
        super.endDocument();
    }

    public void startPageSequence(String id) throws IFException {
    }

    public void endPageSequence() throws IFException {
    }

    public void startPage(int index, String name, String pageMasterName, Dimension size) throws IFException {
        ++this.pageCount;
        this.currentPageDimensions = new Dimension(size);
    }

    public IFPainter startPageContent() throws IFException {
        double scale = this.scaleFactor * 0.35277777910232544 / (double)this.getUserAgent().getTargetPixelUnitToMillimeter();
        int bitmapWidth = (int)((double)this.currentPageDimensions.width * scale / 1000.0 + 0.5);
        int bitmapHeight = (int)((double)this.currentPageDimensions.height * scale / 1000.0 + 0.5);
        this.currentImage = this.createBufferedImage(bitmapWidth, bitmapHeight);
        Graphics2D graphics2D = this.currentImage.createGraphics();
        if (!this.getSettings().hasTransparentPageBackground()) {
            graphics2D.setBackground(this.getSettings().getPageBackgroundColor());
            graphics2D.setPaint(this.getSettings().getPageBackgroundColor());
            graphics2D.fillRect(0, 0, bitmapWidth, bitmapHeight);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        if (this.getSettings().isAntiAliasingEnabled() && this.currentImage.getColorModel().getPixelSize() > 1) {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_ON);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
            graphics2D.setRenderingHint(RenderingHints.KEY_TEXT_ANTIALIASING, RenderingHints.VALUE_TEXT_ANTIALIAS_OFF);
        }
        if (this.getSettings().isQualityRenderingEnabled()) {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        } else {
            graphics2D.setRenderingHint(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_SPEED);
        }
        graphics2D.setRenderingHint(RenderingHints.KEY_STROKE_CONTROL, RenderingHints.VALUE_STROKE_PURE);
        graphics2D.scale(scale / 1000.0, scale / 1000.0);
        return new Java2DPainter(graphics2D, this.getContext(), this.getFontInfo());
    }

    protected BufferedImage createBufferedImage(int bitmapWidth, int bitmapHeight) {
        return new BufferedImage(bitmapWidth, bitmapHeight, this.getSettings().getBufferedImageType());
    }

    public void endPageContent() throws IFException {
        try {
            if (this.multiImageWriter == null) {
                switch (this.pageCount) {
                    case 1: {
                        this.imageWriter.writeImage((RenderedImage)this.currentImage, this.outputStream, this.getSettings().getWriterParams());
                        break;
                    }
                    case 2: {
                        BitmapRendererEventProducer eventProducer = BitmapRendererEventProducer.Provider.get(this.getUserAgent().getEventBroadcaster());
                        eventProducer.stoppingAfterFirstPageNoFilename(this);
                        break;
                    }
                }
            } else {
                this.multiImageWriter.writeImage((RenderedImage)this.currentImage, this.getSettings().getWriterParams());
            }
            this.currentImage = null;
        }
        catch (IOException ioe) {
            throw new IFException("I/O error while encoding BufferedImage", ioe);
        }
    }

    public void endPage() throws IFException {
        this.currentPageDimensions = null;
    }

    public void handleExtensionObject(Object extension) throws IFException {
        log.debug((Object)("Don't know how to handle extension object. Ignoring: " + extension + " (" + extension.getClass().getName() + ")"));
    }
}

