/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.Serializable;
import java.rmi.Remote;
import java.util.Set;
import org.apache.yoko.rmi.impl.AbstractObjectArrayDescriptor;
import org.apache.yoko.rmi.impl.BooleanArrayDescriptor;
import org.apache.yoko.rmi.impl.ByteArrayDescriptor;
import org.apache.yoko.rmi.impl.CharArrayDescriptor;
import org.apache.yoko.rmi.impl.DoubleArrayDescriptor;
import org.apache.yoko.rmi.impl.FloatArrayDescriptor;
import org.apache.yoko.rmi.impl.IntArrayDescriptor;
import org.apache.yoko.rmi.impl.LongArrayDescriptor;
import org.apache.yoko.rmi.impl.ObjectArrayDescriptor;
import org.apache.yoko.rmi.impl.RemoteArrayDescriptor;
import org.apache.yoko.rmi.impl.ShortArrayDescriptor;
import org.apache.yoko.rmi.impl.TypeDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.apache.yoko.rmi.impl.ValueArrayDescriptor;
import org.apache.yoko.rmi.impl.ValueDescriptor;
import org.omg.CORBA.ORB;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.ValueMember;
import org.omg.CORBA_2_3.portable.InputStream;
import org.omg.CORBA_2_3.portable.OutputStream;

public abstract class ArrayDescriptor
extends ValueDescriptor {
    protected int order;
    protected Class basicType;
    protected Class elementType;
    String _repid = null;
    String _elementRepid = null;

    public String getRepositoryID() {
        if (this._repid != null) {
            return this._repid;
        }
        if (this.elementType.isPrimitive() || this.elementType == Object.class) {
            this._repid = "RMI:" + this.getJavaClass().getName() + ":0000000000000000";
        } else {
            TypeDescriptor desc = this.getTypeRepository().getDescriptor(this.elementType);
            String elemRep = desc.getRepositoryIDForArray();
            String hash = elemRep.substring(elemRep.indexOf(58, 4));
            this._repid = "RMI:" + this.getJavaClass().getName() + hash;
        }
        return this._repid;
    }

    public String getElementRepositoryID() {
        if (this._elementRepid != null) {
            return this._elementRepid;
        }
        if (this.elementType.isPrimitive() || this.elementType == Object.class) {
            this._elementRepid = "RMI:" + this.getJavaClass().getName().substring(1) + ":0000000000000000";
        } else {
            TypeDescriptor desc = this.getTypeRepository().getDescriptor(this.elementType);
            this._elementRepid = desc.getRepositoryIDForArray();
        }
        return this._elementRepid;
    }

    protected ArrayDescriptor(Class type, Class elemType, TypeRepository rep) {
        super(type, rep);
        logger.fine("Creating an array descriptor for type " + type.getName() + " holding elements of " + elemType.getName());
        this.elementType = elemType;
        this.order = 1;
        this.basicType = elemType;
        while (this.basicType.isArray()) {
            this.basicType = this.basicType.getComponentType();
            ++this.order;
        }
    }

    public String getIDLName() {
        StringBuffer sb = new StringBuffer("org_omg_boxedRMI_");
        TypeDescriptor desc = this.getTypeRepository().getDescriptor(this.basicType);
        String pkgName = desc.getPackageName();
        if (pkgName.length() == 0) {
            sb.append("seq");
            sb.append(this.order);
            sb.append('_');
            sb.append(desc.getTypeName());
        } else {
            String elemName = desc.getIDLName();
            int idx = elemName.lastIndexOf(95);
            pkgName = elemName.substring(0, idx + 1);
            String elmName = elemName.substring(idx + 1);
            sb.append(pkgName);
            sb.append("seq");
            sb.append(this.order);
            sb.append('_');
            sb.append(elmName);
        }
        return sb.toString();
    }

    static ArrayDescriptor get(Class type, TypeRepository rep) {
        logger.fine("retrieving an array descriptor for class " + type.getName());
        if (!type.isArray()) {
            throw new IllegalArgumentException("type is not an array");
        }
        Class<?> elemType = type.getComponentType();
        if (elemType.isPrimitive()) {
            if (elemType == Boolean.TYPE) {
                return new BooleanArrayDescriptor(type, elemType, rep);
            }
            if (elemType == Byte.TYPE) {
                return new ByteArrayDescriptor(type, elemType, rep);
            }
            if (elemType == Character.TYPE) {
                return new CharArrayDescriptor(type, elemType, rep);
            }
            if (elemType == Short.TYPE) {
                return new ShortArrayDescriptor(type, elemType, rep);
            }
            if (elemType == Integer.TYPE) {
                return new IntArrayDescriptor(type, elemType, rep);
            }
            if (elemType == Long.TYPE) {
                return new LongArrayDescriptor(type, elemType, rep);
            }
            if (elemType == Float.TYPE) {
                return new FloatArrayDescriptor(type, elemType, rep);
            }
            if (elemType == Double.TYPE) {
                return new DoubleArrayDescriptor(type, elemType, rep);
            }
            throw new RuntimeException("unknown array type " + type);
        }
        if (Serializable.class.isAssignableFrom(elemType)) {
            return new ValueArrayDescriptor(type, elemType, rep);
        }
        if (Remote.class.isAssignableFrom(elemType)) {
            return new RemoteArrayDescriptor(type, elemType, rep);
        }
        if (Object.class.equals(elemType)) {
            return new ObjectArrayDescriptor(type, elemType, rep);
        }
        return new AbstractObjectArrayDescriptor(type, elemType, rep);
    }

    public Object read(org.omg.CORBA.portable.InputStream in) {
        InputStream _in = (InputStream)in;
        logger.fine("Reading an array value with repository id " + this.getRepositoryID() + " java class is " + this.getJavaClass());
        Class clz = this.getJavaClass();
        if (clz == null) {
            return _in.read_value(this.getRepositoryID());
        }
        return _in.read_value(clz);
    }

    public void write(org.omg.CORBA.portable.OutputStream out, Object value) {
        OutputStream _out = (OutputStream)out;
        _out.write_value((Serializable)value, this.getRepositoryID());
    }

    ValueMember[] getValueMembers() {
        if (this._value_members == null) {
            this._value_members = new ValueMember[1];
            TypeDescriptor elemDesc = this.getTypeRepository().getDescriptor(this.elementType);
            String elemRepID = elemDesc.getRepositoryID();
            ORB orb = ORB.init();
            TypeCode memberTC = orb.create_sequence_tc(0, elemDesc.getTypeCode());
            this._value_members[0] = new ValueMember("", elemRepID, this.getRepositoryID(), "1.0", memberTC, null, 1);
        }
        return this._value_members;
    }

    void addDependencies(Set classes) {
        this.getTypeRepository().getDescriptor(this.basicType).addDependencies(classes);
    }
}

