/*
 * Decompiled with CFR 0.152.
 */
package org.apache.yoko.rmi.impl;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Serializable;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;
import org.apache.yoko.rmi.impl.CopyState;
import org.apache.yoko.rmi.impl.CorbaObjectReader;
import org.apache.yoko.rmi.impl.ModelElement;
import org.apache.yoko.rmi.impl.RemoteInterfaceDescriptor;
import org.apache.yoko.rmi.impl.TypeRepository;
import org.omg.CORBA.TypeCode;
import org.omg.CORBA.portable.InputStream;
import org.omg.CORBA.portable.OutputStream;

public abstract class TypeDescriptor
extends ModelElement {
    static Logger logger = Logger.getLogger(TypeDescriptor.class.getName());
    protected Class _java_class;
    protected String _repid;
    protected RemoteInterfaceDescriptor remoteDescriptor;
    protected TypeCode _type_code = null;

    public Class getJavaClass() {
        return this._java_class;
    }

    protected TypeDescriptor(Class type, TypeRepository repository) {
        this._java_class = type;
        String typeName = type.getName();
        this.setTypeRepository(repository);
        this.setIDLName(typeName.replace('.', '_'));
        int idx = typeName.lastIndexOf(46);
        if (idx >= 0) {
            this.setPackageName(typeName.substring(0, idx));
            this.setTypeName(typeName.substring(idx + 1));
        } else {
            this.setPackageName("");
            this.setTypeName(typeName);
        }
    }

    public String getRepositoryIDForArray() {
        return this.getRepositoryID();
    }

    public String getRepositoryID() {
        if (this._repid == null) {
            this._repid = "RMI:" + this.getJavaClass().getName() + ":0000000000000000";
        }
        return this._repid;
    }

    RemoteInterfaceDescriptor getRemoteInterface() {
        return this.remoteDescriptor;
    }

    void setRemoteInterface(RemoteInterfaceDescriptor desc) {
        this.remoteDescriptor = desc;
    }

    public abstract Object read(InputStream var1);

    public abstract void write(OutputStream var1, Object var2);

    public void init() {
    }

    public boolean isCustomMarshalled() {
        return false;
    }

    CorbaObjectReader makeCorbaObjectReader(final InputStream in, final Map offsetMap, final Serializable obj) throws IOException {
        try {
            return (CorbaObjectReader)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return new CorbaObjectReader(in, offsetMap, obj);
                    }
                    catch (IOException ex) {
                        throw new WrappedIOException(ex);
                    }
                }
            });
        }
        catch (WrappedIOException ex) {
            throw ex.wrapped;
        }
    }

    String makeSignature(Class type) {
        if (type.isPrimitive()) {
            if (type == Boolean.TYPE) {
                return "Z";
            }
            if (type == Byte.TYPE) {
                return "B";
            }
            if (type == Short.TYPE) {
                return "S";
            }
            if (type == Character.TYPE) {
                return "C";
            }
            if (type == Integer.TYPE) {
                return "I";
            }
            if (type == Long.TYPE) {
                return "J";
            }
            if (type == Float.TYPE) {
                return "F";
            }
            if (type == Double.TYPE) {
                return "D";
            }
            if (type == Void.TYPE) {
                return "V";
            }
            throw new RuntimeException("unknown primitive class" + type);
        }
        if (type.isArray()) {
            int i = 0;
            Class<?> elem = type;
            while (elem.isArray()) {
                ++i;
                elem = elem.getComponentType();
            }
            StringBuffer sb = new StringBuffer();
            for (int j = 0; j < i; ++j) {
                sb.append('[');
            }
            sb.append(this.makeSignature(elem));
            return sb.toString();
        }
        return "L" + type.getName().replace('.', '/') + ";";
    }

    long getHashCode() {
        return 0L;
    }

    abstract TypeCode getTypeCode();

    Object copyObject(Object value, CopyState state) {
        throw new InternalError("cannot copy " + value.getClass().getName());
    }

    void writeMarshalValue(PrintWriter pw, String outName, String paramName) {
        pw.print(outName);
        pw.print('.');
        pw.print("write_");
        pw.print(this.getIDLName());
        pw.print('(');
        pw.print(paramName);
        pw.print(')');
    }

    void writeUnmarshalValue(PrintWriter pw, String inName) {
        pw.print(inName);
        pw.print('.');
        pw.print("read_");
        pw.print(this.getIDLName());
        pw.print('(');
        pw.print(')');
    }

    void addDependencies(Set classes) {
    }

    boolean copyInStub() {
        return true;
    }

    void print(PrintWriter pw, Map recurse, Object val) {
        Integer old;
        if (val == null) {
            pw.print("null");
        }
        if ((old = (Integer)recurse.get(val)) != null) {
            pw.print("^" + old);
        } else {
            Integer key = new Integer(System.identityHashCode(val));
            pw.println(this.getJavaClass().getName() + "@" + Integer.toHexString(key));
        }
    }

    synchronized TypeDescriptor getSelf() {
        return this;
    }

    public boolean copyBetweenStates() {
        return true;
    }

    public boolean copyWithinState() {
        return true;
    }

    static class WrappedIOException
    extends RuntimeException {
        IOException wrapped;

        WrappedIOException(IOException ex) {
            super("wrapped IO exception");
            this.wrapped = ex;
        }
    }
}

