/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.Serializable;
import java.util.Map;
import java.util.Set;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.AuthenticationPolicyExecutionResult;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.core.Ordered;

@FunctionalInterface
@JsonTypeInfo(use=JsonTypeInfo.Id.CLASS)
public interface AuthenticationPolicy
extends Ordered,
Serializable {
    public static AuthenticationPolicy alwaysSatisfied() {
        return (authentication, handlers, applicationContext, assertion) -> AuthenticationPolicyExecutionResult.success();
    }

    public static AuthenticationPolicy neverSatisfied() {
        return (authentication, handlers, applicationContext, assertion) -> AuthenticationPolicyExecutionResult.failure();
    }

    public AuthenticationPolicyExecutionResult isSatisfiedBy(Authentication var1, Set<AuthenticationHandler> var2, ConfigurableApplicationContext var3, Map<String, ? extends Serializable> var4) throws Throwable;

    default public AuthenticationPolicyExecutionResult isSatisfiedBy(Authentication authentication, Set<AuthenticationHandler> authenticationHandlers, ConfigurableApplicationContext applicationContext) throws Throwable {
        return this.isSatisfiedBy(authentication, authenticationHandlers, applicationContext, Map.of());
    }

    default public AuthenticationPolicyExecutionResult isSatisfiedBy(Authentication authentication, ConfigurableApplicationContext applicationContext, Map<String, ? extends Serializable> context) throws Throwable {
        return this.isSatisfiedBy(authentication, Set.of(), applicationContext, context);
    }

    default public AuthenticationPolicyExecutionResult isSatisfiedBy(Authentication authentication, ConfigurableApplicationContext applicationContext) throws Throwable {
        return this.isSatisfiedBy(authentication, Set.of(), applicationContext, Map.of());
    }

    default public int getOrder() {
        return Integer.MAX_VALUE;
    }

    default public String getName() {
        return this.getClass().getSimpleName();
    }

    default public boolean shouldResumeOnFailure(Throwable failure) {
        return failure != null;
    }
}

