/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.principal;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.apache.hc.core5.net.URIBuilder;
import org.apereo.cas.authentication.principal.Principal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Service
extends Principal {
    public static final Logger LOGGER = LoggerFactory.getLogger(Service.class);

    default public void setPrincipal(String principal) {
    }

    public void setAttributes(Map<String, List<Object>> var1);

    public String getOriginalUrl();

    @JsonIgnore
    default public String getShortenedId() throws Exception {
        String lastSegment;
        URIBuilder urlBuilder = new URIBuilder(this.getId());
        Object serviceId = "";
        if (StringUtils.isNotBlank((CharSequence)urlBuilder.getScheme())) {
            serviceId = (String)serviceId + urlBuilder.getScheme().concat("://");
        }
        if (StringUtils.isNotBlank((CharSequence)urlBuilder.getHost())) {
            serviceId = (String)serviceId + urlBuilder.getHost();
        }
        if (urlBuilder.getPort() > 0) {
            serviceId = (String)serviceId + ":" + urlBuilder.getPort();
        }
        if (!urlBuilder.getPathSegments().isEmpty()) {
            serviceId = (String)serviceId + String.valueOf(StringUtils.isBlank((CharSequence)serviceId) ? "" : Character.valueOf('/')) + (String)urlBuilder.getPathSegments().getFirst();
        }
        if (urlBuilder.getPathSegments().size() >= 2) {
            serviceId = (String)serviceId + "/" + (String)urlBuilder.getPathSegments().get(1);
        }
        if (!urlBuilder.getPathSegments().isEmpty() && !((String)serviceId).contains(lastSegment = (String)urlBuilder.getPathSegments().getLast())) {
            serviceId = (String)serviceId + "/" + lastSegment;
        }
        return serviceId;
    }
}

