/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.model.support.sms;

import com.fasterxml.jackson.annotation.JsonFilter;
import java.io.File;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import lombok.Generated;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.apereo.cas.configuration.support.RequiresModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.ResourceUtils;

@RequiresModule(name="cas-server-core-util", automated=true)
@JsonFilter(value="SmsProperties")
public class SmsProperties
implements Serializable {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(SmsProperties.class);
    private static final long serialVersionUID = -3713886839517507306L;
    @RequiredProperty
    private String text;
    @RequiredProperty
    private String from;
    @RequiredProperty
    private String attributeName = "phone";

    public boolean isDefined() {
        return StringUtils.isNotBlank((CharSequence)this.getText()) && StringUtils.isNotBlank((CharSequence)this.getFrom());
    }

    public String getFormattedText(Object ... arguments) {
        if (StringUtils.isBlank((CharSequence)this.text)) {
            LOGGER.warn("No SMS text is defined");
            return "";
        }
        try {
            File templateFile = ResourceUtils.getFile((String)this.text);
            String contents = FileUtils.readFileToString((File)templateFile, (Charset)StandardCharsets.UTF_8);
            return String.format(contents, arguments);
        }
        catch (Exception e) {
            LOGGER.trace(e.getMessage(), (Throwable)e);
            return String.format(this.text, arguments);
        }
    }

    @Generated
    public String getText() {
        return this.text;
    }

    @Generated
    public String getFrom() {
        return this.from;
    }

    @Generated
    public String getAttributeName() {
        return this.attributeName;
    }

    @Generated
    public SmsProperties setText(String text) {
        this.text = text;
        return this;
    }

    @Generated
    public SmsProperties setFrom(String from) {
        this.from = from;
        return this;
    }

    @Generated
    public SmsProperties setAttributeName(String attributeName) {
        this.attributeName = attributeName;
        return this;
    }
}

