/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.support;

import java.io.File;
import java.time.Duration;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.configuration.model.core.authentication.AttributeRepositoryStates;
import org.apereo.cas.configuration.model.core.authentication.PrincipalAttributesProperties;
import org.apereo.cas.configuration.model.core.authentication.StubPrincipalAttributesProperties;
import org.apereo.cas.configuration.model.support.ConnectionPoolingProperties;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.support.NamedStubPersonAttributeDao;
import org.springframework.scheduling.concurrent.ThreadPoolExecutorFactoryBean;
import org.springframework.util.StringUtils;

public final class Beans {
    public static ThreadPoolExecutorFactoryBean newThreadPoolExecutorFactoryBean(ConnectionPoolingProperties config) {
        ThreadPoolExecutorFactoryBean bean = new ThreadPoolExecutorFactoryBean();
        bean.setMaxPoolSize(config.getMaxSize());
        bean.setCorePoolSize(config.getMinSize());
        return bean;
    }

    public static IPersonAttributeDao newStubAttributeRepository(PrincipalAttributesProperties p) {
        NamedStubPersonAttributeDao dao = new NamedStubPersonAttributeDao();
        LinkedHashMap backingMap = new LinkedHashMap();
        StubPrincipalAttributesProperties stub = p.getStub();
        stub.getAttributes().forEach((key, value) -> {
            String[] vals = StringUtils.commaDelimitedListToStringArray((String)value);
            backingMap.put(key, Arrays.stream(vals).map(v -> {
                Boolean bool = BooleanUtils.toBooleanObject((String)v);
                if (bool != null) {
                    return bool;
                }
                return v;
            }).collect(Collectors.toList()));
        });
        dao.setBackingMap(backingMap);
        dao.setOrder(stub.getOrder());
        dao.setEnabled(stub.getState() != AttributeRepositoryStates.DISABLED);
        dao.putTag("state", (Object)(stub.getState() == AttributeRepositoryStates.ACTIVE ? 1 : 0));
        if (StringUtils.hasText((String)stub.getId())) {
            dao.setId(new String[]{stub.getId()});
        }
        return dao;
    }

    public static Duration newDuration(String value) {
        if ("0".equalsIgnoreCase(value) || "NEVER".equalsIgnoreCase(value)) {
            return Duration.ZERO;
        }
        if ("-1".equalsIgnoreCase(value) || !StringUtils.hasText((String)value) || "INFINITE".equalsIgnoreCase(value)) {
            return Duration.ofDays(Integer.MAX_VALUE);
        }
        if (NumberUtils.isCreatable((String)value)) {
            return Duration.ofSeconds(Long.parseLong(value));
        }
        return Duration.parse(value);
    }

    public static String getTempFilePath(String prefix, String suffix) {
        return File.createTempFile(prefix, suffix).getCanonicalPath();
    }

    @Generated
    private Beans() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

