/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.support;

import java.security.Provider;
import java.security.Security;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.jasypt.encryption.pbe.StandardPBEStringEncryptor;
import org.jasypt.iv.IvGenerator;
import org.jasypt.iv.RandomIvGenerator;
import org.springframework.core.env.Environment;

public class CasConfigurationJasyptCipherExecutor
implements CipherExecutor<String, String> {
    public static final String ENCRYPTED_VALUE_PREFIX = "{cas-cipher}";
    public static final String ALGS_THAT_REQUIRE_IV_PATTERN = "PBEWITHHMACSHA\\d+ANDAES_.*(?<!-BC)$";
    private final StandardPBEStringEncryptor jasyptInstance;

    public CasConfigurationJasyptCipherExecutor(Environment environment) {
        Security.addProvider((Provider)new BouncyCastleProvider());
        this.jasyptInstance = new StandardPBEStringEncryptor();
        String alg = CasConfigurationJasyptCipherExecutor.getJasyptParamFromEnv(environment, JasyptEncryptionParameters.ALGORITHM);
        this.setAlgorithm(alg);
        String psw = CasConfigurationJasyptCipherExecutor.getJasyptParamFromEnv(environment, JasyptEncryptionParameters.PASSWORD);
        this.setPassword(psw);
        String pName = CasConfigurationJasyptCipherExecutor.getJasyptParamFromEnv(environment, JasyptEncryptionParameters.PROVIDER);
        this.setProviderName(pName);
        String iter = CasConfigurationJasyptCipherExecutor.getJasyptParamFromEnv(environment, JasyptEncryptionParameters.ITERATIONS);
        this.setKeyObtentionIterations(iter);
        boolean initializationVector = Boolean.parseBoolean(CasConfigurationJasyptCipherExecutor.getJasyptParamFromEnv(environment, JasyptEncryptionParameters.INITIALIZATION_VECTOR));
        if (initializationVector || this.isVectorInitializationRequiredFor(alg)) {
            this.configureInitializationVector();
        }
    }

    private static String getJasyptParamFromEnv(Environment environment, JasyptEncryptionParameters param) {
        return environment.getProperty(param.getPropertyName(), param.getDefaultValue());
    }

    public void setAlgorithm(String alg) {
        if (StringUtils.isNotBlank((CharSequence)alg)) {
            LOGGER.debug("Configured Jasypt algorithm [{}]", (Object)alg);
            this.jasyptInstance.setAlgorithm(alg);
        }
    }

    protected void setAlgorithmForce(String alg) {
        if (StringUtils.isNotBlank((CharSequence)alg)) {
            LOGGER.debug("Configured Jasypt algorithm [{}]", (Object)alg);
            this.jasyptInstance.setAlgorithm(alg);
        }
    }

    public void configureInitializationVector() {
        this.jasyptInstance.setIvGenerator((IvGenerator)new RandomIvGenerator());
    }

    public boolean isVectorInitializationRequiredFor(String algorithm) {
        return StringUtils.isNotBlank((CharSequence)algorithm) && algorithm.matches(ALGS_THAT_REQUIRE_IV_PATTERN);
    }

    public void setPassword(String psw) {
        if (StringUtils.isNotBlank((CharSequence)psw)) {
            LOGGER.debug("Configured Jasypt password");
            this.jasyptInstance.setPassword(psw);
        }
    }

    public void setKeyObtentionIterations(String iter) {
        if (StringUtils.isNotBlank((CharSequence)iter) && NumberUtils.isCreatable((String)iter)) {
            LOGGER.debug("Configured Jasypt iterations");
            this.jasyptInstance.setKeyObtentionIterations(Integer.parseInt(iter));
        }
    }

    public void setProviderName(String pName) {
        if (StringUtils.isNotBlank((CharSequence)pName)) {
            LOGGER.debug("Configured Jasypt provider");
            this.jasyptInstance.setProviderName(pName);
        }
    }

    public String encode(String value, Object[] parameters) {
        return this.encryptValue(value);
    }

    public String decode(String value, Object[] parameters) {
        return this.decryptValue(value);
    }

    public String getName() {
        return "CAS Configuration Jasypt Encryption";
    }

    public String encryptValue(String value) {
        try {
            return this.encryptValuePropagateExceptions(value);
        }
        catch (Exception e) {
            LOGGER.error("Could not encrypt value [{}]", (Object)value, (Object)e);
            return null;
        }
    }

    public String encryptValuePropagateExceptions(String value) {
        this.initializeJasyptInstanceIfNecessary();
        return ENCRYPTED_VALUE_PREFIX + this.jasyptInstance.encrypt(value);
    }

    public String decryptValue(String value) {
        try {
            return this.decryptValuePropagateExceptions(value);
        }
        catch (Exception e) {
            LOGGER.error("Could not decrypt value [{}]", (Object)value, (Object)e);
            return null;
        }
    }

    public String decryptValuePropagateExceptions(String value) {
        if (StringUtils.isNotBlank((CharSequence)value) && value.startsWith(ENCRYPTED_VALUE_PREFIX)) {
            this.initializeJasyptInstanceIfNecessary();
            String encValue = value.substring(ENCRYPTED_VALUE_PREFIX.length());
            LOGGER.trace("Decrypting value [{}]...", (Object)encValue);
            String result = this.jasyptInstance.decrypt(encValue);
            if (StringUtils.isNotBlank((CharSequence)result)) {
                LOGGER.debug("Decrypted value [{}] successfully.", (Object)encValue);
                return result;
            }
            LOGGER.warn("Encrypted value [{}] has no values.", (Object)encValue);
        }
        return value;
    }

    private void initializeJasyptInstanceIfNecessary() {
        if (!this.jasyptInstance.isInitialized()) {
            LOGGER.trace("Initializing Jasypt...");
            this.jasyptInstance.initialize();
        }
    }

    public static enum JasyptEncryptionParameters {
        ALGORITHM("cas.standalone.configuration-security.alg", "PBEWithMD5AndTripleDES"),
        PROVIDER("cas.standalone.configuration-security.provider", null),
        ITERATIONS("cas.standalone.configuration-security.iterations", null),
        PASSWORD("cas.standalone.configuration-security.psw", null),
        INITIALIZATION_VECTOR("cas.standalone.configuration-security.initialization-vector", "false");

        private final String propertyName;
        private final String defaultValue;

        private JasyptEncryptionParameters(String name, String defaultValue) {
            this.propertyName = name;
            this.defaultValue = defaultValue;
        }

        @Generated
        public String getPropertyName() {
            return this.propertyName;
        }

        @Generated
        public String getDefaultValue() {
            return this.defaultValue;
        }
    }
}

