/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.support;

import com.fasterxml.jackson.annotation.JsonIgnore;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Set;
import java.util.function.Predicate;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.support.RequiredProperty;
import org.jooq.lambda.Unchecked;
import org.reflections.ReflectionUtils;
import org.springframework.util.ClassUtils;

public interface CasFeatureModule {
    @JsonIgnore
    default public boolean isDefined() {
        Set fields = ReflectionUtils.getAllFields(this.getClass(), (Predicate[])new Predicate[]{field -> field.getAnnotation(RequiredProperty.class) != null});
        return fields.stream().allMatch(Unchecked.predicate(field -> {
            String getter = CasFeatureModule.getMethodName(field, "get");
            if (ClassUtils.hasMethod(this.getClass(), (String)getter, (Class[])new Class[0])) {
                Method method = ClassUtils.getMethod(this.getClass(), (String)getter, (Class[])new Class[0]);
                Object value = method.invoke((Object)this, new Object[0]);
                return value != null && StringUtils.isNotBlank((CharSequence)value.toString());
            }
            getter = CasFeatureModule.getMethodName(field, "is");
            if (ClassUtils.hasMethod(this.getClass(), (String)getter, (Class[])new Class[0])) {
                Method method = ClassUtils.getMethod(this.getClass(), (String)getter, (Class[])new Class[0]);
                Object value = method.invoke((Object)this, new Object[0]);
                return value != null && BooleanUtils.toBoolean((String)value.toString());
            }
            return false;
        }));
    }

    @JsonIgnore
    default public boolean isUndefined() {
        return !this.isDefined();
    }

    private static String getMethodName(Field field, String prefix) {
        return prefix + field.getName().substring(0, 1).toUpperCase() + field.getName().substring(1);
    }
}

