/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import lombok.Generated;
import org.springframework.http.HttpStatus;
import org.springframework.web.bind.annotation.ResponseStatus;

@ResponseStatus(value=HttpStatus.FORBIDDEN, reason="Unauthorized Service Usage")
public class UnauthorizedServiceException
extends RuntimeException {
    private static final String CODE_UNAUTHORIZED_SERVICE = "screen.service.error.message";
    private static final String CODE_EXPIRED_SERVICE = "screen.service.expired.message";
    private static final String CODE_REQUIRED_SERVICE = "screen.service.required.message";
    private static final String CODE_INITIAL_SERVICE = "screen.service.initial.message";
    private static final long serialVersionUID = 3905807495715960369L;
    private final String code;

    protected UnauthorizedServiceException(String message) {
        this(null, message);
    }

    protected UnauthorizedServiceException(String code, String message) {
        super(message);
        this.code = code;
    }

    protected UnauthorizedServiceException(Throwable cause, String code, String message) {
        super(message, cause);
        this.code = code;
    }

    protected UnauthorizedServiceException(String message, Throwable cause) {
        super(message, cause);
        this.code = null;
    }

    public static RuntimeException denied(String message) {
        return new UnauthorizedServiceException(CODE_UNAUTHORIZED_SERVICE, message);
    }

    public static RuntimeException expired(String message) {
        return new UnauthorizedServiceException(CODE_EXPIRED_SERVICE, message);
    }

    public static RuntimeException wrap(Throwable ex) {
        return new UnauthorizedServiceException(ex, CODE_UNAUTHORIZED_SERVICE, ex.getMessage());
    }

    public static RuntimeException required() {
        return new UnauthorizedServiceException(CODE_REQUIRED_SERVICE, CODE_REQUIRED_SERVICE);
    }

    public static RuntimeException requested() {
        return new UnauthorizedServiceException(CODE_INITIAL_SERVICE, CODE_INITIAL_SERVICE);
    }

    @Generated
    public String getCode() {
        return this.code;
    }
}

