/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.util.nativex;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.util.ReflectionUtils;
import org.jooq.lambda.Unchecked;
import org.springframework.aop.SpringProxy;
import org.springframework.aop.framework.Advised;
import org.springframework.aot.hint.ExecutableMode;
import org.springframework.aot.hint.RuntimeHints;
import org.springframework.aot.hint.RuntimeHintsRegistrar;
import org.springframework.core.DecoratingProxy;

@FunctionalInterface
public interface CasRuntimeHintsRegistrar
extends RuntimeHintsRegistrar {
    public static final String PROPERTY_IMAGE_CODE_KEY = "org.graalvm.nativeimage.imagecode";
    public static final String PROPERTY_IMAGE_CODE_VALUE_BUILDTIME = "buildtime";
    public static final String PROPERTY_IMAGE_CODE_VALUE_RUNTIME = "runtime";
    public static final String SYSTEM_PROPERTY_SPRING_AOT_PROCESSING = "spring.aot.processing";

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerSerializableSpringProxy(RuntimeHints hints, Class ... clazz) {
        List<Class> proxies = Arrays.stream(clazz).collect(Collectors.toList());
        proxies.add(Serializable.class);
        CasRuntimeHintsRegistrar.addSpringProxyInterfaces(proxies);
        hints.proxies().registerJdkProxy(clazz).registerJdkProxy(proxies.toArray(ArrayUtils.EMPTY_CLASS_ARRAY));
        return this;
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerSpringProxy(RuntimeHints hints, Class ... clazz) {
        List<Class> proxies = Arrays.stream(clazz).collect(Collectors.toList());
        CasRuntimeHintsRegistrar.addSpringProxyInterfaces(proxies);
        hints.proxies().registerJdkProxy(clazz).registerJdkProxy(proxies.toArray(ArrayUtils.EMPTY_CLASS_ARRAY));
        return this;
    }

    @CanIgnoreReturnValue
    default public CasRuntimeHintsRegistrar registerDeclaredMethod(RuntimeHints hints, Class clazz, String name) {
        Method method = (Method)Unchecked.supplier(() -> clazz.getDeclaredMethod(name, new Class[0])).get();
        hints.reflection().registerMethod(method, ExecutableMode.INVOKE);
        return this;
    }

    default public void registerChainedProxyHints(RuntimeHints hints, Class ... subclassesInPackage) {
        hints.proxies().registerJdkProxy(subclassesInPackage);
    }

    default public void registerProxyHints(RuntimeHints hints, Class ... subclassesInPackage) {
        Arrays.stream(subclassesInPackage).forEach(clazz -> hints.proxies().registerJdkProxy(new Class[]{clazz}));
    }

    default public void registerProxyHints(RuntimeHints hints, Collection<Class> subclassesInPackage) {
        subclassesInPackage.forEach(clazz -> hints.proxies().registerJdkProxy(new Class[]{clazz}));
    }

    default public Collection<Class> findSubclassesInPackage(Class superClass, String ... packages) {
        Collection results = ReflectionUtils.findSubclassesInPackage(superClass, packages);
        List<Class> filteredResults = results.stream().filter(clazz -> {
            String host = clazz.getCanonicalName();
            if (clazz.isMemberClass() && clazz.getPackageName().startsWith("org.apereo.cas")) {
                Class<?> entry = clazz;
                while (entry.isMemberClass()) {
                    entry = clazz.getNestHost();
                }
                host = entry.getCanonicalName();
            }
            return StringUtils.isNotBlank((CharSequence)host) && !host.endsWith("Tests");
        }).collect(Collectors.toList());
        filteredResults.add(superClass);
        return filteredResults;
    }

    public static boolean inNativeImage() {
        return CasRuntimeHintsRegistrar.inImageBuildTimeCode() || CasRuntimeHintsRegistrar.inImageRuntimeCode() || BooleanUtils.toBoolean((String)System.getProperty(SYSTEM_PROPERTY_SPRING_AOT_PROCESSING));
    }

    public static boolean notInNativeImage() {
        return !CasRuntimeHintsRegistrar.inNativeImage();
    }

    private static boolean inImageRuntimeCode() {
        return PROPERTY_IMAGE_CODE_VALUE_RUNTIME.equals(System.getProperty(PROPERTY_IMAGE_CODE_KEY));
    }

    private static boolean inImageBuildTimeCode() {
        return PROPERTY_IMAGE_CODE_VALUE_BUILDTIME.equals(System.getProperty(PROPERTY_IMAGE_CODE_KEY));
    }

    private static void addSpringProxyInterfaces(List<Class> proxies) {
        proxies.add(SpringProxy.class);
        proxies.add(Advised.class);
        proxies.add(DecoratingProxy.class);
    }
}

