/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit.spi.support;

import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.function.Function;
import lombok.Generated;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.aspectj.lang.JoinPoint;

public class ReturnValueAsStringResourceResolver
implements AuditResourceResolver {
    protected AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.DEFAULT;
    protected Function<String[], String[]> resourcePostProcessor = Function.identity();

    public String[] resolveFrom(JoinPoint auditableTarget, Object retval) {
        if (retval instanceof Collection) {
            Collection collection = (Collection)retval;
            int size = collection.size();
            String[] returnValues = new String[size];
            Iterator iter = collection.iterator();
            for (int i = 0; iter.hasNext() && i < size; ++i) {
                Object o = iter.next();
                if (o == null) continue;
                returnValues[i] = this.toResourceString(o);
            }
            return returnValues;
        }
        if (retval instanceof Object[]) {
            Object[] vals = (Object[])retval;
            return (String[])Arrays.stream(vals).map(this::toResourceString).toArray(String[]::new);
        }
        return new String[]{this.toResourceString(retval)};
    }

    public String[] resolveFrom(JoinPoint auditableTarget, Exception exception) {
        String message = exception.getMessage();
        if (message != null) {
            return new String[]{this.toResourceString(message)};
        }
        return new String[]{this.toResourceString(exception)};
    }

    public String toResourceString(Object arg) {
        if (this.auditFormat == AuditTrailManager.AuditFormats.JSON) {
            return this.postProcess(AuditTrailManager.toJson((Object)arg));
        }
        return this.postProcess(arg.toString());
    }

    protected String postProcess(String value) {
        return this.resourcePostProcessor.apply(new String[]{value})[0];
    }

    @Generated
    public void setAuditFormat(AuditTrailManager.AuditFormats auditFormat) {
        this.auditFormat = auditFormat;
    }

    @Generated
    public void setResourcePostProcessor(Function<String[], String[]> resourcePostProcessor) {
        this.resourcePostProcessor = resourcePostProcessor;
    }
}

