/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.inspektr.audit.support;

import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.MinimalPrettyPrinter;
import com.fasterxml.jackson.databind.ObjectWriter;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.inspektr.audit.AuditActionContext;
import org.apereo.inspektr.audit.AuditTrailManager;

public abstract class AbstractStringAuditTrailManager
implements AuditTrailManager {
    private AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.DEFAULT;
    private boolean useSingleLine;
    private String entrySeparator = ",";
    private List<AuditTrailManager.AuditableFields> auditableFields = new ArrayList<AuditTrailManager.AuditableFields>();

    protected String toString(AuditActionContext auditActionContext) {
        if (this.auditFormat == AuditTrailManager.AuditFormats.JSON) {
            StringBuilder builder = new StringBuilder();
            try {
                ObjectWriter writer = this.useSingleLine ? MAPPER.writer((PrettyPrinter)new MinimalPrettyPrinter()) : MAPPER.writerWithDefaultPrettyPrinter();
                builder.append(writer.writeValueAsString(this.getMappedAuditActionContext(auditActionContext)));
                if (!this.useSingleLine) {
                    builder.append('\n');
                }
            }
            catch (Exception e) {
                throw new IllegalArgumentException(e.getMessage(), e);
            }
            return builder.toString();
        }
        return this.getAuditLineString(auditActionContext);
    }

    protected String getAuditLineString(AuditActionContext auditActionContext) {
        StringBuilder builder = new StringBuilder();
        if (!this.useSingleLine) {
            builder.append("Audit trail record BEGIN\n");
            builder.append("=============================================================\n");
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.WHEN)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getWhenActionWasPerformed());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("WHEN: ");
                builder.append(auditActionContext.getWhenActionWasPerformed());
                builder.append('\n');
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.WHO)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getPrincipal());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("WHO: ");
                builder.append(auditActionContext.getPrincipal());
                builder.append('\n');
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.WHAT)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getResourceOperatedUpon());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("WHAT: ");
                builder.append(auditActionContext.getResourceOperatedUpon());
                builder.append('\n');
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.ACTION)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getActionPerformed());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("ACTION: ");
                builder.append(auditActionContext.getActionPerformed());
                builder.append('\n');
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.APPLICATION)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getApplicationCode());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("APPLICATION: ");
                builder.append(auditActionContext.getApplicationCode());
                builder.append('\n');
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.USER_AGENT)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getClientInfo().getUserAgent());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("USER-AGENT: ");
                builder.append(auditActionContext.getClientInfo().getUserAgent());
                builder.append('\n');
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.CLIENT_IP)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getClientInfo().getClientIpAddress());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("CLIENT IP ADDRESS: ");
                builder.append(auditActionContext.getClientInfo().getClientIpAddress());
                builder.append('\n');
            }
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.SERVER_IP)) {
            if (this.useSingleLine) {
                builder.append(auditActionContext.getClientInfo().getServerIpAddress());
                builder.append(this.getEntrySeparator());
            } else {
                builder.append("SERVER IP ADDRESS: ");
                builder.append(auditActionContext.getClientInfo().getServerIpAddress());
                builder.append('\n');
            }
        }
        if (!this.useSingleLine) {
            builder.append("=============================================================");
            builder.append("\n\n");
        }
        return builder.toString();
    }

    private static Object readFieldValue(String value) {
        try {
            return MAPPER.readValue(value, Map.class);
        }
        catch (Exception e) {
            return value;
        }
    }

    protected Map<String, ?> getMappedAuditActionContext(AuditActionContext auditActionContext) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.WHO)) {
            map.put("who", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getPrincipal()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.WHAT)) {
            map.put("what", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getResourceOperatedUpon()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.ACTION)) {
            map.put("action", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getActionPerformed()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.APPLICATION)) {
            map.put("application", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getApplicationCode()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.WHEN)) {
            map.put("when", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getWhenActionWasPerformed().toString()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.CLIENT_IP)) {
            map.put("clientIpAddress", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getClientInfo().getClientIpAddress()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.SERVER_IP)) {
            map.put("serverIpAddress", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getClientInfo().getServerIpAddress()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.USER_AGENT)) {
            map.put("userAgent", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getClientInfo().getUserAgent()));
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.HEADERS)) {
            map.put("headers", auditActionContext.getClientInfo().getHeaders());
        }
        if (this.auditableFields.isEmpty() || this.auditableFields.contains(AuditTrailManager.AuditableFields.GEO_LOCATION)) {
            map.put("geoLocation", AbstractStringAuditTrailManager.readFieldValue(auditActionContext.getClientInfo().getGeoLocation()));
        }
        return map;
    }

    @Generated
    public void setAuditFormat(AuditTrailManager.AuditFormats auditFormat) {
        this.auditFormat = auditFormat;
    }

    @Generated
    public void setUseSingleLine(boolean useSingleLine) {
        this.useSingleLine = useSingleLine;
    }

    @Generated
    public void setEntrySeparator(String entrySeparator) {
        this.entrySeparator = entrySeparator;
    }

    @Generated
    public void setAuditableFields(List<AuditTrailManager.AuditableFields> auditableFields) {
        this.auditableFields = auditableFields;
    }

    @Generated
    public AuditTrailManager.AuditFormats getAuditFormat() {
        return this.auditFormat;
    }

    @Generated
    public boolean isUseSingleLine() {
        return this.useSingleLine;
    }

    @Generated
    public String getEntrySeparator() {
        return this.entrySeparator;
    }

    @Generated
    public List<AuditTrailManager.AuditableFields> getAuditableFields() {
        return this.auditableFields;
    }
}

