/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.audit.spi.config;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import javax.servlet.Filter;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.audit.AuditPrincipalIdProvider;
import org.apereo.cas.audit.AuditTrailExecutionPlan;
import org.apereo.cas.audit.AuditTrailExecutionPlanConfigurer;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlan;
import org.apereo.cas.audit.AuditTrailRecordResolutionPlanConfigurer;
import org.apereo.cas.audit.spi.plan.DefaultAuditTrailExecutionPlan;
import org.apereo.cas.audit.spi.plan.DefaultAuditTrailRecordResolutionPlan;
import org.apereo.cas.audit.spi.principal.ChainingAuditPrincipalIdProvider;
import org.apereo.cas.audit.spi.principal.ThreadLocalAuditPrincipalResolver;
import org.apereo.cas.audit.spi.resource.CredentialsAsFirstParameterResourceResolver;
import org.apereo.cas.audit.spi.resource.ProtocolSpecificationValidationAuditResourceResolver;
import org.apereo.cas.audit.spi.resource.ServiceAccessEnforcementAuditResourceResolver;
import org.apereo.cas.audit.spi.resource.ServiceAuditResourceResolver;
import org.apereo.cas.audit.spi.resource.TicketAsFirstParameterResourceResolver;
import org.apereo.cas.audit.spi.resource.TicketValidationResourceResolver;
import org.apereo.cas.config.CasCoreServicesConfiguration;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.audit.AuditEngineProperties;
import org.apereo.cas.configuration.model.core.audit.AuditSlf4jLogProperties;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.serialization.MessageSanitizationUtils;
import org.apereo.inspektr.audit.AuditTrailManagementAspect;
import org.apereo.inspektr.audit.AuditTrailManager;
import org.apereo.inspektr.audit.FilterAndDelegateAuditTrailManager;
import org.apereo.inspektr.audit.spi.AuditActionResolver;
import org.apereo.inspektr.audit.spi.AuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.BooleanAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.DefaultAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.MessageBundleAwareResourceResolver;
import org.apereo.inspektr.audit.spi.support.NullableReturnValueAuditResourceResolver;
import org.apereo.inspektr.audit.spi.support.ObjectCreationAuditActionResolver;
import org.apereo.inspektr.audit.spi.support.ShortenedReturnValueAsStringAuditResourceResolver;
import org.apereo.inspektr.audit.support.Slf4jLoggingAuditTrailManager;
import org.apereo.inspektr.common.spi.PrincipalResolver;
import org.apereo.inspektr.common.web.ClientInfoThreadLocalFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.actuate.audit.AuditEventRepository;
import org.springframework.boot.actuate.audit.InMemoryAuditEventRepository;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ConfigurableApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.ScopedProxyMode;
import org.springframework.core.annotation.AnnotationAwareOrderComparator;

@Configuration(value="CasCoreAuditConfiguration", proxyBeanMethods=false)
@EnableAspectJAutoProxy
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
@AutoConfigureAfter(value={CasCoreServicesConfiguration.class})
public class CasCoreAuditConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreAuditConfiguration.class);

    @Configuration(value="CasCoreAuditExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=0x7FFFFFFF)
    public static class CasCoreAuditExecutionPlanConfiguration {
        @ConditionalOnMissingBean(name={"auditTrailExecutionPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailExecutionPlan auditTrailExecutionPlan(List<AuditTrailExecutionPlanConfigurer> configurers) {
            DefaultAuditTrailExecutionPlan plan = new DefaultAuditTrailExecutionPlan();
            configurers.forEach(c -> {
                LOGGER.trace("Configuring audit trail execution plan via [{}]", (Object)c.getName());
                c.configureAuditTrailExecutionPlan((AuditTrailExecutionPlan)plan);
            });
            return plan;
        }

        @Bean
        @ConditionalOnMissingBean(name={"casAuditTrailExecutionPlanConfigurer"})
        @ConditionalOnProperty(prefix="cas.audit.slf4j", name={"enabled"}, havingValue="true", matchIfMissing=true)
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailExecutionPlanConfigurer casAuditTrailExecutionPlanConfigurer(CasConfigurationProperties casProperties) {
            return plan -> {
                AuditSlf4jLogProperties slf4j = casProperties.getAudit().getSlf4j();
                Slf4jLoggingAuditTrailManager slf4jManager = new Slf4jLoggingAuditTrailManager();
                slf4jManager.setUseSingleLine(slf4j.isUseSingleLine());
                slf4jManager.setEntrySeparator(slf4j.getSinglelineSeparator());
                plan.registerAuditTrailManager((AuditTrailManager)slf4jManager);
            };
        }
    }

    @Configuration(value="CasCoreAuditResolutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    @AutoConfigureOrder(value=0x7FFFFFFF)
    public static class CasCoreAuditResolutionPlanConfiguration {
        @ConditionalOnMissingBean(name={"auditTrailRecordResolutionPlan"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlan auditTrailRecordResolutionPlan(List<AuditTrailRecordResolutionPlanConfigurer> configurers) {
            DefaultAuditTrailRecordResolutionPlan plan = new DefaultAuditTrailRecordResolutionPlan();
            configurers.forEach(c -> {
                LOGGER.trace("Registering audit trail manager [{}]", (Object)c.getName());
                c.configureAuditTrailRecordResolutionPlan((AuditTrailRecordResolutionPlan)plan);
            });
            return plan;
        }

        @Bean
        @ConditionalOnMissingBean(name={"casAuditResourceResolversResolutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer casAuditResourceResolversResolutionPlanConfigurer(@Qualifier(value="credentialsAsFirstParameterResourceResolver") AuditResourceResolver credentialsAsFirstParameterResourceResolver, @Qualifier(value="nullableReturnValueResourceResolver") AuditResourceResolver nullableReturnValueResourceResolver, @Qualifier(value="messageBundleAwareResourceResolver") AuditResourceResolver messageBundleAwareResourceResolver, @Qualifier(value="returnValueResourceResolver") AuditResourceResolver returnValueResourceResolver, @Qualifier(value="ticketResourceResolver") AuditResourceResolver ticketResourceResolver, @Qualifier(value="serviceAccessEnforcementAuditResourceResolver") AuditResourceResolver serviceAccessEnforcementAuditResourceResolver, @Qualifier(value="serviceAuditResourceResolver") AuditResourceResolver serviceAuditResourceResolver, @Qualifier(value="ticketValidationResourceResolver") AuditResourceResolver ticketValidationResourceResolver, @Qualifier(value="protocolSpecificationValidationResourceResolver") AuditResourceResolver protocolSpecificationValidationResourceResolver) {
            return plan -> {
                plan.registerAuditResourceResolver("AUTHENTICATION_RESOURCE_RESOLVER", credentialsAsFirstParameterResourceResolver);
                plan.registerAuditResourceResolver("AUTHENTICATION_EVENT_RESOURCE_RESOLVER", nullableReturnValueResourceResolver);
                plan.registerAuditResourceResolver("CREATE_TICKET_GRANTING_TICKET_RESOURCE_RESOLVER", messageBundleAwareResourceResolver);
                plan.registerAuditResourceResolver("CREATE_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER", messageBundleAwareResourceResolver);
                plan.registerAuditResourceResolver("DESTROY_TICKET_RESOURCE_RESOLVER", ticketResourceResolver);
                plan.registerAuditResourceResolver("DESTROY_PROXY_GRANTING_TICKET_RESOURCE_RESOLVER", ticketResourceResolver);
                plan.registerAuditResourceResolver("GRANT_SERVICE_TICKET_RESOURCE_RESOLVER", serviceAuditResourceResolver);
                plan.registerAuditResourceResolver("GRANT_PROXY_TICKET_RESOURCE_RESOLVER", serviceAuditResourceResolver);
                plan.registerAuditResourceResolver("VALIDATE_SERVICE_TICKET_RESOURCE_RESOLVER", ticketValidationResourceResolver);
                plan.registerAuditResourceResolver("VALIDATE_PROTOCOL_SPECIFICATION_RESOURCE_RESOLVER", protocolSpecificationValidationResourceResolver);
                plan.registerAuditResourceResolver("SAVE_SERVICE_RESOURCE_RESOLVER", returnValueResourceResolver);
                plan.registerAuditResourceResolver("DELETE_SERVICE_RESOURCE_RESOLVER", returnValueResourceResolver);
                plan.registerAuditResourceResolver("SERVICE_ACCESS_ENFORCEMENT_RESOURCE_RESOLVER", serviceAccessEnforcementAuditResourceResolver);
            };
        }

        @Bean
        @ConditionalOnMissingBean(name={"casAuditActionResolversResolutionPlanConfigurer"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditTrailRecordResolutionPlanConfigurer casAuditActionResolversResolutionPlanConfigurer(@Qualifier(value="authenticationActionResolver") AuditActionResolver authenticationActionResolver, @Qualifier(value="objectCreationAuditActionResolver") AuditActionResolver objectCreationAuditActionResolver, @Qualifier(value="defaultAuditActionResolver") AuditActionResolver defaultAuditActionResolver, @Qualifier(value="ticketCreationActionResolver") AuditActionResolver ticketCreationActionResolver, @Qualifier(value="triggeredAuditActionResolver") AuditActionResolver triggeredAuditActionResolver, @Qualifier(value="ticketValidationActionResolver") AuditActionResolver ticketValidationActionResolver, @Qualifier(value="booleanActionResolver") AuditActionResolver booleanActionResolver) {
            return plan -> {
                plan.registerAuditActionResolver("AUTHENTICATION_RESOLVER", authenticationActionResolver);
                plan.registerAuditActionResolver("SAVE_SERVICE_ACTION_RESOLVER", authenticationActionResolver);
                plan.registerAuditActionResolver("DELETE_SERVICE_ACTION_RESOLVER", objectCreationAuditActionResolver);
                plan.registerAuditActionResolver("DESTROY_TICKET_RESOLVER", defaultAuditActionResolver);
                plan.registerAuditActionResolver("DESTROY_PROXY_GRANTING_TICKET_RESOLVER", defaultAuditActionResolver);
                plan.registerAuditActionResolver("CREATE_PROXY_GRANTING_TICKET_RESOLVER", ticketCreationActionResolver);
                plan.registerAuditActionResolver("GRANT_SERVICE_TICKET_RESOLVER", ticketCreationActionResolver);
                plan.registerAuditActionResolver("GRANT_PROXY_TICKET_RESOLVER", ticketCreationActionResolver);
                plan.registerAuditActionResolver("CREATE_TICKET_GRANTING_TICKET_RESOLVER", ticketCreationActionResolver);
                plan.registerAuditActionResolver("AUTHENTICATION_EVENT_ACTION_RESOLVER", triggeredAuditActionResolver);
                plan.registerAuditActionResolver("VALIDATE_SERVICE_TICKET_RESOLVER", ticketValidationActionResolver);
                plan.registerAuditActionResolver("VALIDATE_PROTOCOL_SPECIFICATION_RESOLVER", booleanActionResolver);
                plan.registerAuditActionResolver("SERVICE_ACCESS_ENFORCEMENT_ACTION_RESOLVER", triggeredAuditActionResolver);
            };
        }
    }

    @Configuration(value="CasCoreAuditFiltersConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuditFiltersConfiguration {
        @Bean
        public FilterRegistrationBean<ClientInfoThreadLocalFilter> casClientInfoLoggingFilter(CasConfigurationProperties casProperties) {
            AuditEngineProperties audit = casProperties.getAudit().getEngine();
            FilterRegistrationBean bean = new FilterRegistrationBean();
            bean.setFilter((Filter)new ClientInfoThreadLocalFilter());
            bean.setUrlPatterns((Collection)CollectionUtils.wrap((Object)"/*"));
            bean.setName("CAS Client Info Logging Filter");
            bean.setAsyncSupported(true);
            bean.setOrder(-2147483647);
            HashMap<String, String> initParams = new HashMap<String, String>();
            if (StringUtils.isNotBlank((CharSequence)audit.getAlternateClientAddrHeaderName())) {
                initParams.put("alternativeIpAddressHeader", audit.getAlternateClientAddrHeaderName());
            }
            if (StringUtils.isNotBlank((CharSequence)audit.getAlternateServerAddrHeaderName())) {
                initParams.put("alternateServerAddrHeaderName", audit.getAlternateServerAddrHeaderName());
            }
            initParams.put("useServerHostAddress", String.valueOf(audit.isUseServerHostAddress()));
            bean.setInitParameters(initParams);
            return bean;
        }
    }

    @Configuration(value="CasCoreAuditManagementConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuditManagementConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"auditTrailManagementAspect"})
        @ConditionalOnProperty(prefix="cas.audit.engine", name={"enabled"}, havingValue="true", matchIfMissing=true)
        public AuditTrailManagementAspect auditTrailManagementAspect(@Qualifier(value="auditTrailRecordResolutionPlan") AuditTrailRecordResolutionPlan auditTrailRecordResolutionPlan, @Qualifier(value="auditablePrincipalResolver") PrincipalResolver auditablePrincipalResolver, @Qualifier(value="filterAndDelegateAuditTrailManager") AuditTrailManager filterAndDelegateAuditTrailManager, CasConfigurationProperties casProperties) {
            AuditEngineProperties audit = casProperties.getAudit().getEngine();
            AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.valueOf((String)audit.getAuditFormat().name());
            AuditTrailManagementAspect aspect = new AuditTrailManagementAspect(audit.getAppCode(), auditablePrincipalResolver, CollectionUtils.wrapList((Object[])new AuditTrailManager[]{filterAndDelegateAuditTrailManager}), auditTrailRecordResolutionPlan.getAuditActionResolvers(), auditTrailRecordResolutionPlan.getAuditResourceResolvers(), auditTrailRecordResolutionPlan.getAuditPrincipalResolvers(), auditFormat);
            aspect.setFailOnAuditFailures(!audit.isIgnoreAuditFailures());
            return aspect;
        }

        @Bean
        @ConditionalOnMissingBean(name={"filterAndDelegateAuditTrailManager"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        protected AuditTrailManager filterAndDelegateAuditTrailManager(@Qualifier(value="auditTrailExecutionPlan") AuditTrailExecutionPlan auditTrailExecutionPlan, CasConfigurationProperties casProperties) {
            AuditEngineProperties audit = casProperties.getAudit().getEngine();
            AuditTrailManager.AuditFormats auditFormat = AuditTrailManager.AuditFormats.valueOf((String)audit.getAuditFormat().name());
            FilterAndDelegateAuditTrailManager auditManager = new FilterAndDelegateAuditTrailManager((Collection)auditTrailExecutionPlan.getAuditTrailManagers(), audit.getSupportedActions(), audit.getExcludedActions());
            auditManager.setAuditFormat(auditFormat);
            return auditManager;
        }
    }

    @Configuration(value="CasCoreAuditEventsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuditEventsConfiguration {
        @Bean
        @ConditionalOnProperty(prefix="cas.audit.engine", name={"enabled"}, havingValue="true", matchIfMissing=true)
        @ConditionalOnMissingBean(name={"inMemoryAuditEventRepository"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditEventRepository inMemoryAuditEventRepository() {
            return new InMemoryAuditEventRepository();
        }
    }

    @Configuration(value="CasCoreAuditActionsConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuditActionsConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"defaultAuditActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver defaultAuditActionResolver() {
            return new DefaultAuditActionResolver();
        }

        @Bean
        @ConditionalOnMissingBean(name={"triggeredAuditActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver triggeredAuditActionResolver() {
            return new DefaultAuditActionResolver("_TRIGGERED", "");
        }

        @Bean
        @ConditionalOnMissingBean(name={"objectCreationAuditActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver objectCreationAuditActionResolver() {
            return new ObjectCreationAuditActionResolver("_SUCCESS", "_FAILED");
        }

        @Bean
        @ConditionalOnMissingBean(name={"booleanActionResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver booleanActionResolver() {
            return new BooleanAuditActionResolver("_SUCCESS", "_FAILED");
        }

        @ConditionalOnMissingBean(name={"authenticationActionResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver authenticationActionResolver() {
            return new DefaultAuditActionResolver("_SUCCESS", "_FAILED");
        }

        @ConditionalOnMissingBean(name={"ticketCreationActionResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver ticketCreationActionResolver() {
            return new DefaultAuditActionResolver("_CREATED", "_NOT_CREATED");
        }

        @ConditionalOnMissingBean(name={"ticketValidationActionResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditActionResolver ticketValidationActionResolver() {
            return new DefaultAuditActionResolver("_SUCCESS", "_FAILED");
        }
    }

    @Configuration(value="CasCoreAuditResourcesConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuditResourcesConfiguration {
        @Bean
        @ConditionalOnMissingBean(name={"credentialsAsFirstParameterResourceResolver"})
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver credentialsAsFirstParameterResourceResolver() {
            return new CredentialsAsFirstParameterResourceResolver();
        }

        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnMissingBean(name={"protocolSpecificationValidationResourceResolver"})
        public AuditResourceResolver protocolSpecificationValidationResourceResolver(CasConfigurationProperties casProperties) {
            return new ProtocolSpecificationValidationAuditResourceResolver(casProperties);
        }

        @ConditionalOnMissingBean(name={"ticketResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver ticketResourceResolver() {
            return new TicketAsFirstParameterResourceResolver();
        }

        @ConditionalOnMissingBean(name={"ticketValidationResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver ticketValidationResourceResolver(@Qualifier(value="ticketResourceResolver") AuditResourceResolver ticketResourceResolver, CasConfigurationProperties casProperties) {
            if (casProperties.getAudit().getEngine().isIncludeValidationAssertion()) {
                return new TicketValidationResourceResolver();
            }
            return ticketResourceResolver;
        }

        @ConditionalOnMissingBean(name={"messageBundleAwareResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver messageBundleAwareResourceResolver(ConfigurableApplicationContext applicationContext) {
            MessageBundleAwareResourceResolver resolver = new MessageBundleAwareResourceResolver((ApplicationContext)applicationContext);
            resolver.setResourcePostProcessor(inputs -> (String[])Arrays.stream(inputs).map(MessageSanitizationUtils::sanitize).toArray(String[]::new));
            return resolver;
        }

        @ConditionalOnMissingBean(name={"serviceAuditResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver serviceAuditResourceResolver() {
            return new ServiceAuditResourceResolver();
        }

        @ConditionalOnMissingBean(name={"returnValueResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver returnValueResourceResolver() {
            return new ShortenedReturnValueAsStringAuditResourceResolver();
        }

        @ConditionalOnMissingBean(name={"nullableReturnValueResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver nullableReturnValueResourceResolver() {
            NullableReturnValueAuditResourceResolver resolver = new NullableReturnValueAuditResourceResolver((AuditResourceResolver)new ShortenedReturnValueAsStringAuditResourceResolver());
            resolver.setResourcePostProcessor(inputs -> (String[])Arrays.stream(inputs).map(MessageSanitizationUtils::sanitize).toArray(String[]::new));
            return resolver;
        }

        @ConditionalOnMissingBean(name={"serviceAccessEnforcementAuditResourceResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditResourceResolver serviceAccessEnforcementAuditResourceResolver() {
            return new ServiceAccessEnforcementAuditResourceResolver();
        }
    }

    @Configuration(value="CasCoreAuditPrincipalConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuditPrincipalConfiguration {
        @ConditionalOnMissingBean(name={"auditablePrincipalResolver"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public PrincipalResolver auditablePrincipalResolver(@Qualifier(value="auditPrincipalIdProvider") AuditPrincipalIdProvider auditPrincipalIdProvider) {
            return new ThreadLocalAuditPrincipalResolver(auditPrincipalIdProvider);
        }

        @ConditionalOnMissingBean(name={"auditPrincipalIdProvider"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuditPrincipalIdProvider auditPrincipalIdProvider(List<AuditPrincipalIdProvider> providers) {
            AnnotationAwareOrderComparator.sortIfNecessary(providers);
            return new ChainingAuditPrincipalIdProvider(providers);
        }
    }
}

