/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import java.util.Arrays;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.attribute.PrincipalAttributeRepositoryFetcher;
import org.apereo.services.persondir.IPersonAttributeDao;
import org.apereo.services.persondir.IPersonAttributeDaoFilter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class PrincipalAttributeRepositoryFilter
implements IPersonAttributeDaoFilter {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(PrincipalAttributeRepositoryFilter.class);
    private final PrincipalAttributeRepositoryFetcher fetcher;

    public boolean choosePersonAttributeDao(IPersonAttributeDao repository) {
        Set<String> activeAttributeRepositoryIdentifiers = this.fetcher.getActiveAttributeRepositoryIdentifiers();
        if (activeAttributeRepositoryIdentifiers.isEmpty()) {
            return false;
        }
        if (activeAttributeRepositoryIdentifiers.contains("*")) {
            return true;
        }
        String[] repoIdsArray = activeAttributeRepositoryIdentifiers.toArray(ArrayUtils.EMPTY_STRING_ARRAY);
        LOGGER.trace("Active attribute repository identifiers [{}] to compare with [{}]", activeAttributeRepositoryIdentifiers, (Object)repository.getId());
        boolean result = Arrays.stream(repository.getId()).anyMatch(daoId -> daoId.equalsIgnoreCase("*") || StringUtils.equalsAnyIgnoreCase((CharSequence)daoId, (CharSequence[])repoIdsArray) || StringUtils.equalsAnyIgnoreCase((CharSequence)"*", (CharSequence[])repoIdsArray));
        LOGGER.debug("Selecting attribute repository [{}]", (Object)ArrayUtils.toString((Object)repository.getId()));
        return result;
    }

    @Generated
    private PrincipalAttributeRepositoryFilter(PrincipalAttributeRepositoryFetcher fetcher) {
        this.fetcher = fetcher;
    }

    @Generated
    protected static PrincipalAttributeRepositoryFilter of(PrincipalAttributeRepositoryFetcher fetcher) {
        return new PrincipalAttributeRepositoryFilter(fetcher);
    }
}

