/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication;

import java.util.Collection;
import java.util.Objects;
import java.util.stream.Stream;
import lombok.Generated;
import lombok.NonNull;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationResult;
import org.apereo.cas.authentication.AuthenticationResultBuilder;
import org.apereo.cas.authentication.AuthenticationResultBuilderFactory;
import org.apereo.cas.authentication.AuthenticationSystemSupport;
import org.apereo.cas.authentication.AuthenticationTransaction;
import org.apereo.cas.authentication.AuthenticationTransactionFactory;
import org.apereo.cas.authentication.AuthenticationTransactionManager;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.PrincipalElectionStrategy;
import org.apereo.cas.authentication.principal.PrincipalResolver;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.services.ServicesManager;

public class DefaultAuthenticationSystemSupport
implements AuthenticationSystemSupport {
    private final AuthenticationTransactionManager authenticationTransactionManager;
    private final PrincipalElectionStrategy principalElectionStrategy;
    private final AuthenticationResultBuilderFactory authenticationResultBuilderFactory;
    private final AuthenticationTransactionFactory authenticationTransactionFactory;
    private final ServicesManager servicesManager;
    private final PrincipalResolver principalResolver;

    public AuthenticationResultBuilder establishAuthenticationContextFromInitial(Authentication authentication, Credential ... credentials) {
        return this.establishAuthenticationContextFromInitial(authentication).collect(credentials);
    }

    public AuthenticationResultBuilder establishAuthenticationContextFromInitial(Authentication authentication) {
        return this.authenticationResultBuilderFactory.newBuilder().collect(authentication);
    }

    public AuthenticationResultBuilder handleInitialAuthenticationTransaction(Service service, Credential ... credential) throws Throwable {
        AuthenticationResultBuilder builder = this.authenticationResultBuilderFactory.newBuilder();
        if (credential != null) {
            Stream.of(credential).filter(Objects::nonNull).forEach(xva$0 -> builder.collect(new Credential[]{xva$0}));
        }
        return this.handleAuthenticationTransaction(service, builder, credential);
    }

    public AuthenticationResultBuilder handleAuthenticationTransaction(Service service, AuthenticationResultBuilder authenticationResultBuilder, Credential ... credentials) throws Throwable {
        AuthenticationTransaction transaction = this.authenticationTransactionFactory.newTransaction(service, credentials).collect((Collection)authenticationResultBuilder.getAuthentications());
        this.authenticationTransactionManager.handle(transaction, authenticationResultBuilder);
        return authenticationResultBuilder;
    }

    public AuthenticationResult finalizeAllAuthenticationTransactions(@NonNull AuthenticationResultBuilder authenticationResultBuilder, Service service) throws Throwable {
        if (authenticationResultBuilder == null) {
            throw new NullPointerException("authenticationResultBuilder is marked non-null but is null");
        }
        return authenticationResultBuilder.build(this.principalElectionStrategy, service);
    }

    public AuthenticationResult finalizeAuthenticationTransaction(Service service, Credential ... credential) throws Throwable {
        return this.finalizeAllAuthenticationTransactions(this.handleInitialAuthenticationTransaction(service, credential), service);
    }

    @Generated
    public AuthenticationTransactionManager getAuthenticationTransactionManager() {
        return this.authenticationTransactionManager;
    }

    @Generated
    public PrincipalElectionStrategy getPrincipalElectionStrategy() {
        return this.principalElectionStrategy;
    }

    @Generated
    public AuthenticationResultBuilderFactory getAuthenticationResultBuilderFactory() {
        return this.authenticationResultBuilderFactory;
    }

    @Generated
    public AuthenticationTransactionFactory getAuthenticationTransactionFactory() {
        return this.authenticationTransactionFactory;
    }

    @Generated
    public ServicesManager getServicesManager() {
        return this.servicesManager;
    }

    @Generated
    public PrincipalResolver getPrincipalResolver() {
        return this.principalResolver;
    }

    @Generated
    public DefaultAuthenticationSystemSupport(AuthenticationTransactionManager authenticationTransactionManager, PrincipalElectionStrategy principalElectionStrategy, AuthenticationResultBuilderFactory authenticationResultBuilderFactory, AuthenticationTransactionFactory authenticationTransactionFactory, ServicesManager servicesManager, PrincipalResolver principalResolver) {
        this.authenticationTransactionManager = authenticationTransactionManager;
        this.principalElectionStrategy = principalElectionStrategy;
        this.authenticationResultBuilderFactory = authenticationResultBuilderFactory;
        this.authenticationTransactionFactory = authenticationTransactionFactory;
        this.servicesManager = servicesManager;
        this.principalResolver = principalResolver;
    }
}

