/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.attribute;

import java.util.Set;
import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationHandler;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.authentication.principal.Service;

@FunctionalInterface
public interface AttributeRepositoryResolver {
    public static final String BEAN_NAME = "attributeRepositoryResolver";

    public Set<String> resolve(AttributeRepositoryQuery var1);

    public static AttributeRepositoryResolver allAttributeRepositories() {
        return query -> Set.of("*");
    }

    public static class AttributeRepositoryQuery {
        private final AuthenticationHandler authenticationHandler;
        private final Principal principal;
        private final Service service;
        private final Set<String> activeRepositoryIds;

        @Generated
        protected AttributeRepositoryQuery(AttributeRepositoryQueryBuilder<?, ?> b) {
            this.authenticationHandler = b.authenticationHandler;
            this.principal = b.principal;
            this.service = b.service;
            this.activeRepositoryIds = b.activeRepositoryIds;
        }

        @Generated
        public static AttributeRepositoryQueryBuilder<?, ?> builder() {
            return new AttributeRepositoryQueryBuilderImpl();
        }

        @Generated
        public AttributeRepositoryQuery withAuthenticationHandler(AuthenticationHandler authenticationHandler) {
            return this.authenticationHandler == authenticationHandler ? this : new AttributeRepositoryQuery(authenticationHandler, this.principal, this.service, this.activeRepositoryIds);
        }

        @Generated
        public AttributeRepositoryQuery withPrincipal(Principal principal) {
            return this.principal == principal ? this : new AttributeRepositoryQuery(this.authenticationHandler, principal, this.service, this.activeRepositoryIds);
        }

        @Generated
        public AttributeRepositoryQuery withService(Service service) {
            return this.service == service ? this : new AttributeRepositoryQuery(this.authenticationHandler, this.principal, service, this.activeRepositoryIds);
        }

        @Generated
        public AttributeRepositoryQuery withActiveRepositoryIds(Set<String> activeRepositoryIds) {
            return this.activeRepositoryIds == activeRepositoryIds ? this : new AttributeRepositoryQuery(this.authenticationHandler, this.principal, this.service, activeRepositoryIds);
        }

        @Generated
        public AttributeRepositoryQuery(AuthenticationHandler authenticationHandler, Principal principal, Service service, Set<String> activeRepositoryIds) {
            this.authenticationHandler = authenticationHandler;
            this.principal = principal;
            this.service = service;
            this.activeRepositoryIds = activeRepositoryIds;
        }

        @Generated
        public AuthenticationHandler getAuthenticationHandler() {
            return this.authenticationHandler;
        }

        @Generated
        public Principal getPrincipal() {
            return this.principal;
        }

        @Generated
        public Service getService() {
            return this.service;
        }

        @Generated
        public Set<String> getActiveRepositoryIds() {
            return this.activeRepositoryIds;
        }

        @Generated
        public static abstract class AttributeRepositoryQueryBuilder<C extends AttributeRepositoryQuery, B extends AttributeRepositoryQueryBuilder<C, B>> {
            @Generated
            private AuthenticationHandler authenticationHandler;
            @Generated
            private Principal principal;
            @Generated
            private Service service;
            @Generated
            private Set<String> activeRepositoryIds;

            @Generated
            public B authenticationHandler(AuthenticationHandler authenticationHandler) {
                this.authenticationHandler = authenticationHandler;
                return this.self();
            }

            @Generated
            public B principal(Principal principal) {
                this.principal = principal;
                return this.self();
            }

            @Generated
            public B service(Service service) {
                this.service = service;
                return this.self();
            }

            @Generated
            public B activeRepositoryIds(Set<String> activeRepositoryIds) {
                this.activeRepositoryIds = activeRepositoryIds;
                return this.self();
            }

            @Generated
            protected abstract B self();

            @Generated
            public abstract C build();

            @Generated
            public String toString() {
                return "AttributeRepositoryResolver.AttributeRepositoryQuery.AttributeRepositoryQueryBuilder(authenticationHandler=" + String.valueOf(this.authenticationHandler) + ", principal=" + String.valueOf(this.principal) + ", service=" + String.valueOf(this.service) + ", activeRepositoryIds=" + String.valueOf(this.activeRepositoryIds) + ")";
            }
        }

        @Generated
        private static final class AttributeRepositoryQueryBuilderImpl
        extends AttributeRepositoryQueryBuilder<AttributeRepositoryQuery, AttributeRepositoryQueryBuilderImpl> {
            @Generated
            private AttributeRepositoryQueryBuilderImpl() {
            }

            @Override
            @Generated
            protected AttributeRepositoryQueryBuilderImpl self() {
                return this;
            }

            @Override
            @Generated
            public AttributeRepositoryQuery build() {
                return new AttributeRepositoryQuery(this);
            }
        }
    }
}

