/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.apereo.cas.authentication.Credential;
import org.apereo.cas.authentication.CredentialMetadata;
import org.apereo.cas.authentication.CredentialTrait;

public class BasicCredentialMetadata
implements CredentialMetadata {
    private static final long serialVersionUID = 4929579849241505377L;
    private final String id;
    private final Class<? extends Credential> credentialClass;
    private final List<CredentialTrait> traits = new ArrayList<CredentialTrait>();
    private final Map<String, Serializable> properties = new HashMap<String, Serializable>();

    public BasicCredentialMetadata(Credential credential, Map<String, ? extends Serializable> properties) {
        this.id = credential.getId();
        this.credentialClass = credential.getClass();
        this.putProperties(properties);
    }

    public BasicCredentialMetadata(Credential credential) {
        this(credential, new HashMap());
    }

    @CanIgnoreReturnValue
    public CredentialMetadata putProperties(Map<String, ? extends Serializable> properties) {
        this.properties.putAll(properties);
        return this;
    }

    @CanIgnoreReturnValue
    public CredentialMetadata putProperty(String key, Serializable value) {
        this.properties.put(key, value);
        return this;
    }

    @CanIgnoreReturnValue
    public CredentialMetadata addTrait(CredentialTrait credentialTrait) {
        this.traits.add(credentialTrait);
        return this;
    }

    @CanIgnoreReturnValue
    public CredentialMetadata removeTrait(Class<? extends CredentialTrait> clazz) {
        this.traits.removeIf(current -> current.getClass().equals(clazz));
        return this;
    }

    @JsonIgnore
    public <T extends CredentialTrait> Optional<T> getTrait(Class<T> clazz) {
        return this.traits.stream().filter(trait -> clazz.equals(trait.getClass())).map(clazz::cast).findFirst();
    }

    @JsonIgnore
    public boolean containsProperty(String key) {
        return this.properties.containsKey(key);
    }

    @Generated
    public String getId() {
        return this.id;
    }

    @Generated
    public Class<? extends Credential> getCredentialClass() {
        return this.credentialClass;
    }

    @Generated
    public List<CredentialTrait> getTraits() {
        return this.traits;
    }

    @Generated
    public Map<String, Serializable> getProperties() {
        return this.properties;
    }

    @Generated
    public BasicCredentialMetadata() {
        this.id = null;
        this.credentialClass = null;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BasicCredentialMetadata)) {
            return false;
        }
        BasicCredentialMetadata other = (BasicCredentialMetadata)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$id = this.id;
        String other$id = other.id;
        if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
            return false;
        }
        Class<? extends Credential> this$credentialClass = this.credentialClass;
        Class<? extends Credential> other$credentialClass = other.credentialClass;
        if (this$credentialClass == null ? other$credentialClass != null : !this$credentialClass.equals(other$credentialClass)) {
            return false;
        }
        List<CredentialTrait> this$traits = this.traits;
        List<CredentialTrait> other$traits = other.traits;
        if (this$traits == null ? other$traits != null : !((Object)this$traits).equals(other$traits)) {
            return false;
        }
        Map<String, Serializable> this$properties = this.properties;
        Map<String, Serializable> other$properties = other.properties;
        return !(this$properties == null ? other$properties != null : !((Object)this$properties).equals(other$properties));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BasicCredentialMetadata;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $id = this.id;
        result = result * 59 + ($id == null ? 43 : $id.hashCode());
        Class<? extends Credential> $credentialClass = this.credentialClass;
        result = result * 59 + ($credentialClass == null ? 43 : $credentialClass.hashCode());
        List<CredentialTrait> $traits = this.traits;
        result = result * 59 + ($traits == null ? 43 : ((Object)$traits).hashCode());
        Map<String, Serializable> $properties = this.properties;
        result = result * 59 + ($properties == null ? 43 : ((Object)$properties).hashCode());
        return result;
    }
}

