/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apereo.cas.configuration.support.ExpressionLanguageCapable;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.util.spring.SpringExpressionLanguageValueResolver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.AbstractResource;
import org.springframework.core.io.Resource;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class GroovyScriptAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptAttributeReleasePolicy.class);
    private static final long serialVersionUID = 1703080077563402223L;
    @ExpressionLanguageCapable
    private String groovyScript;

    @Override
    public Map<String, List<Object>> getAttributesInternal(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> attributes) {
        try {
            Object[] args = new Object[]{attributes, LOGGER, context.getPrincipal(), context.getRegisteredService()};
            LOGGER.debug("Invoking Groovy script with attributes=[{}], principal=[{}], service=[{}] and default logger", new Object[]{attributes, context.getPrincipal(), context.getRegisteredService()});
            AbstractResource resource = ResourceUtils.getResourceFrom((String)SpringExpressionLanguageValueResolver.getInstance().resolve(this.groovyScript));
            return (Map)ScriptingUtils.executeGroovyScript((Resource)resource, (Object[])args, Map.class, (boolean)true);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            LOGGER.warn("Groovy script [{}] does not exist or cannot be loaded", (Object)this.groovyScript);
            return new HashMap<String, List<Object>>(0);
        }
    }

    @Generated
    public String getGroovyScript() {
        return this.groovyScript;
    }

    @Generated
    public void setGroovyScript(String groovyScript) {
        this.groovyScript = groovyScript;
    }

    @Generated
    public GroovyScriptAttributeReleasePolicy() {
    }

    @Generated
    public GroovyScriptAttributeReleasePolicy(String groovyScript) {
        this.groovyScript = groovyScript;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GroovyScriptAttributeReleasePolicy)) {
            return false;
        }
        GroovyScriptAttributeReleasePolicy other = (GroovyScriptAttributeReleasePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$groovyScript = this.groovyScript;
        String other$groovyScript = other.groovyScript;
        return !(this$groovyScript == null ? other$groovyScript != null : !this$groovyScript.equals(other$groovyScript));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof GroovyScriptAttributeReleasePolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $groovyScript = this.groovyScript;
        result = result * 59 + ($groovyScript == null ? 43 : $groovyScript.hashCode());
        return result;
    }
}

