/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.services;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Matcher;
import lombok.Generated;
import org.apereo.cas.services.AbstractRegisteredServiceAttributeReleasePolicy;
import org.apereo.cas.services.RegisteredServiceAttributeReleasePolicyContext;
import org.apereo.cas.util.CollectionUtils;
import org.apereo.cas.util.scripting.ExecutableCompiledGroovyScript;
import org.apereo.cas.util.scripting.ScriptingUtils;
import org.apereo.cas.util.spring.ApplicationContextProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class ReturnMappedAttributeReleasePolicy
extends AbstractRegisteredServiceAttributeReleasePolicy {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(ReturnMappedAttributeReleasePolicy.class);
    private static final long serialVersionUID = -6249488544306639050L;
    private Map<String, Object> allowedAttributes = new TreeMap<String, Object>();

    @JsonCreator
    public ReturnMappedAttributeReleasePolicy(@JsonProperty(value="allowedAttributes") Map<String, Object> attributes) {
        this.allowedAttributes = attributes;
    }

    private static void mapSingleAttributeDefinition(String attributeName, String mappedAttributeName, Object attributeValue, Map<String, List<Object>> resolvedAttributes, Map<String, List<Object>> attributesToRelease) {
        Matcher matcherInline = ScriptingUtils.getMatcherForInlineGroovyScript((String)mappedAttributeName);
        Matcher matcherFile = ScriptingUtils.getMatcherForExternalGroovyScript((String)mappedAttributeName);
        if (matcherInline.find()) {
            String inlineGroovy = matcherInline.group(1);
            ReturnMappedAttributeReleasePolicy.fetchAttributeValueAsInlineGroovyScript(attributeName, resolvedAttributes, attributesToRelease, inlineGroovy);
        } else if (matcherFile.find()) {
            String file = matcherFile.group();
            ReturnMappedAttributeReleasePolicy.fetchAttributeValueFromExternalGroovyScript(attributeName, resolvedAttributes, attributesToRelease, file);
        } else {
            ReturnMappedAttributeReleasePolicy.mapSimpleSingleAttributeDefinition(attributeName, mappedAttributeName, attributeValue, attributesToRelease, resolvedAttributes);
        }
    }

    private static void fetchAttributeValueFromExternalGroovyScript(String attributeName, Map<String, List<Object>> resolvedAttributes, Map<String, List<Object>> attributesToRelease, String file) {
        ApplicationContextProvider.getScriptResourceCacheManager().ifPresentOrElse(cacheMgr -> {
            ExecutableCompiledGroovyScript script = cacheMgr.resolveScriptableResource(file, new String[]{attributeName, file});
            if (script != null) {
                ReturnMappedAttributeReleasePolicy.fetchAttributeValueFromScript(script, attributeName, resolvedAttributes, attributesToRelease);
            }
        }, () -> {
            throw new RuntimeException("No groovy script cache manager is available to execute attribute mappings");
        });
    }

    private static void fetchAttributeValueAsInlineGroovyScript(String attributeName, Map<String, List<Object>> resolvedAttributes, Map<String, List<Object>> attributesToRelease, String inlineGroovy) {
        ApplicationContextProvider.getScriptResourceCacheManager().ifPresentOrElse(cacheMgr -> {
            ExecutableCompiledGroovyScript script = cacheMgr.resolveScriptableResource(inlineGroovy, new String[]{attributeName, inlineGroovy});
            ReturnMappedAttributeReleasePolicy.fetchAttributeValueFromScript(script, attributeName, resolvedAttributes, attributesToRelease);
        }, () -> {
            throw new RuntimeException("No groovy script cache manager is available to execute attribute mappings");
        });
    }

    private static void mapSimpleSingleAttributeDefinition(String attributeName, String mappedAttributeName, Object attributeValue, Map<String, List<Object>> attributesToRelease, Map<String, List<Object>> resolvedAttributes) {
        if (attributeValue != null) {
            LOGGER.debug("Found attribute [{}] in the list of allowed attributes, mapped to the name [{}]", (Object)attributeName, (Object)mappedAttributeName);
            ArrayList values = (ArrayList)CollectionUtils.toCollection((Object)attributeValue, ArrayList.class);
            attributesToRelease.put(mappedAttributeName, values);
        } else if (resolvedAttributes.containsKey(mappedAttributeName)) {
            List<Object> mappedValue = resolvedAttributes.get(mappedAttributeName);
            LOGGER.debug("Reusing existing already-remapped attribute [{}] with value [{}]", (Object)mappedAttributeName, mappedValue);
            attributesToRelease.put(mappedAttributeName, mappedValue);
        } else {
            LOGGER.warn("Could not find value for mapped attribute [{}] that is based off of [{}] in the allowed attributes list. Ensure the original attribute [{}] is retrieved and contains at least a single value. Attribute [{}] will and can not be released without the presence of a value.", new Object[]{mappedAttributeName, attributeName, attributeName, mappedAttributeName});
        }
    }

    private static void fetchAttributeValueFromScript(ExecutableCompiledGroovyScript script, String attributeName, Map<String, List<Object>> resolvedAttributes, Map<String, List<Object>> attributesToRelease) {
        Map args = CollectionUtils.wrap((String)"attributes", resolvedAttributes, (String)"logger", (Object)LOGGER);
        script.setBinding(args);
        Object result = script.execute(args.values().toArray(), Object.class, false);
        if (result != null) {
            LOGGER.debug("Mapped attribute [{}] to [{}] from script", (Object)attributeName, result);
            attributesToRelease.put(attributeName, CollectionUtils.wrapList((Object[])new Object[]{result}));
        } else {
            LOGGER.warn("Groovy-scripted attribute returned no value for [{}]", (Object)attributeName);
        }
    }

    public Map<String, Object> getAllowedAttributes() {
        return new TreeMap<String, Object>(this.allowedAttributes);
    }

    @Override
    public Map<String, List<Object>> getAttributesInternal(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> attrs) {
        return this.authorizeReleaseOfAllowedAttributes(context, attrs);
    }

    @Override
    public List<String> determineRequestedAttributeDefinitions(RegisteredServiceAttributeReleasePolicyContext context) {
        return new ArrayList<String>(this.getAllowedAttributes().keySet());
    }

    protected Map<String, List<Object>> authorizeReleaseOfAllowedAttributes(RegisteredServiceAttributeReleasePolicyContext context, Map<String, List<Object>> attributes) {
        TreeMap<String, List<Object>> resolvedAttributes = new TreeMap<String, List<Object>>(String.CASE_INSENSITIVE_ORDER);
        resolvedAttributes.putAll(attributes);
        resolvedAttributes.putAll(context.getReleasingAttributes());
        HashMap<String, List<Object>> attributesToRelease = new HashMap<String, List<Object>>();
        this.getAllowedAttributes().forEach((attributeName, value) -> {
            List mappedAttributes = CollectionUtils.wrap((Object)value);
            LOGGER.trace("Attempting to map allowed attribute name [{}]", attributeName);
            List attributeValue = (List)resolvedAttributes.get(attributeName);
            mappedAttributes.forEach(mapped -> {
                String mappedAttributeName = mapped.toString();
                LOGGER.debug("Mapping attribute [{}] to [{}] with value [{}]", new Object[]{attributeName, mappedAttributeName, attributeValue});
                ReturnMappedAttributeReleasePolicy.mapSingleAttributeDefinition(attributeName, mappedAttributeName, attributeValue, resolvedAttributes, attributesToRelease);
            });
        });
        return attributesToRelease;
    }

    @Override
    @Generated
    public String toString() {
        return "ReturnMappedAttributeReleasePolicy(super=" + super.toString() + ", allowedAttributes=" + this.allowedAttributes + ")";
    }

    @Generated
    public void setAllowedAttributes(Map<String, Object> allowedAttributes) {
        this.allowedAttributes = allowedAttributes;
    }

    @Override
    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ReturnMappedAttributeReleasePolicy)) {
            return false;
        }
        ReturnMappedAttributeReleasePolicy other = (ReturnMappedAttributeReleasePolicy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Map<String, Object> this$allowedAttributes = this.allowedAttributes;
        Map<String, Object> other$allowedAttributes = other.allowedAttributes;
        return !(this$allowedAttributes == null ? other$allowedAttributes != null : !((Object)this$allowedAttributes).equals(other$allowedAttributes));
    }

    @Override
    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof ReturnMappedAttributeReleasePolicy;
    }

    @Override
    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        Map<String, Object> $allowedAttributes = this.allowedAttributes;
        result = result * 59 + ($allowedAttributes == null ? 43 : ((Object)$allowedAttributes).hashCode());
        return result;
    }

    @Generated
    public ReturnMappedAttributeReleasePolicy() {
    }
}

