/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.authentication.mfa.trigger;

import java.util.Map;
import java.util.Optional;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.authentication.Authentication;
import org.apereo.cas.authentication.AuthenticationException;
import org.apereo.cas.authentication.MultifactorAuthenticationProvider;
import org.apereo.cas.authentication.MultifactorAuthenticationTrigger;
import org.apereo.cas.authentication.MultifactorAuthenticationUtils;
import org.apereo.cas.authentication.principal.Service;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.services.RegisteredService;
import org.apereo.cas.util.LoggingUtils;
import org.apereo.cas.util.ResourceUtils;
import org.apereo.cas.util.scripting.WatchableGroovyScriptResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;

public class GroovyScriptMultifactorAuthenticationTrigger
implements MultifactorAuthenticationTrigger,
DisposableBean {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(GroovyScriptMultifactorAuthenticationTrigger.class);
    private final CasConfigurationProperties casProperties;
    private final WatchableGroovyScriptResource watchableScript;
    private final ApplicationContext applicationContext;
    private int order = Integer.MAX_VALUE;

    public GroovyScriptMultifactorAuthenticationTrigger(CasConfigurationProperties casProperties, ApplicationContext applicationContext) {
        this.casProperties = casProperties;
        Resource groovyScript = casProperties.getAuthn().getMfa().getGroovyScript().getLocation();
        this.watchableScript = new WatchableGroovyScriptResource(groovyScript);
        this.applicationContext = applicationContext;
    }

    public Optional<MultifactorAuthenticationProvider> isActivated(Authentication authentication, RegisteredService registeredService, HttpServletRequest httpServletRequest, HttpServletResponse response, Service service) {
        Resource groovyScript = this.casProperties.getAuthn().getMfa().getGroovyScript().getLocation();
        if (groovyScript == null) {
            LOGGER.trace("No groovy script is configured for multifactor authentication");
            return Optional.empty();
        }
        if (!ResourceUtils.doesResourceExist((Resource)groovyScript)) {
            LOGGER.warn("No groovy script is found at [{}] for multifactor authentication", (Object)groovyScript);
            return Optional.empty();
        }
        if (authentication == null) {
            LOGGER.debug("No authentication is available to determine event for principal");
            return Optional.empty();
        }
        Map<String, MultifactorAuthenticationProvider> providerMap = MultifactorAuthenticationUtils.getAvailableMultifactorAuthenticationProviders(this.applicationContext);
        if (providerMap.isEmpty()) {
            LOGGER.error("No multifactor authentication providers are available in the application context");
            throw new AuthenticationException();
        }
        try {
            Object[] args = new Object[]{service, registeredService, authentication, httpServletRequest, LOGGER};
            String provider = (String)this.watchableScript.execute(args, String.class);
            LOGGER.debug("Groovy script run for [{}] returned the provider id [{}]", (Object)registeredService, (Object)provider);
            if (StringUtils.isBlank((CharSequence)provider)) {
                return Optional.empty();
            }
            return MultifactorAuthenticationUtils.resolveProvider(providerMap, provider);
        }
        catch (Exception e) {
            LoggingUtils.error((Logger)LOGGER, (Throwable)e);
            return Optional.empty();
        }
    }

    public void destroy() {
        this.watchableScript.close();
    }

    @Generated
    public CasConfigurationProperties getCasProperties() {
        return this.casProperties;
    }

    @Generated
    public WatchableGroovyScriptResource getWatchableScript() {
        return this.watchableScript;
    }

    @Generated
    public ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    @Generated
    public int getOrder() {
        return this.order;
    }

    @Generated
    public void setOrder(int order) {
        this.order = order;
    }
}

