/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.config;

import lombok.Generated;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlan;
import org.apereo.cas.authentication.AuthenticationEventExecutionPlanConfigurer;
import org.apereo.cas.authentication.AuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.metadata.AuthenticationCredentialTypeMetaDataPopulator;
import org.apereo.cas.authentication.metadata.AuthenticationDateAttributeMetaDataPopulator;
import org.apereo.cas.authentication.metadata.CacheCredentialsCipherExecutor;
import org.apereo.cas.authentication.metadata.CacheCredentialsMetaDataPopulator;
import org.apereo.cas.authentication.metadata.ClientInfoAuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.metadata.CredentialCustomFieldsAttributeMetaDataPopulator;
import org.apereo.cas.authentication.metadata.RememberMeAuthenticationMetaDataPopulator;
import org.apereo.cas.authentication.metadata.SuccessfulHandlerMetaDataPopulator;
import org.apereo.cas.configuration.CasConfigurationProperties;
import org.apereo.cas.configuration.model.core.util.EncryptionJwtSigningJwtCryptographyProperties;
import org.apereo.cas.configuration.model.support.clearpass.ClearpassProperties;
import org.apereo.cas.util.cipher.CipherExecutorUtils;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ScopedProxyMode;

@Configuration(value="CasCoreAuthenticationMetadataConfiguration", proxyBeanMethods=false)
@EnableConfigurationProperties(value={CasConfigurationProperties.class})
public class CasCoreAuthenticationMetadataConfiguration {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(CasCoreAuthenticationMetadataConfiguration.class);

    @Configuration(value="CasCoreAuthenticationMetadataExecutionPlanConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuthenticationMetadataExecutionPlanConfiguration {
        @ConditionalOnMissingBean(name={"casCoreAuthenticationMetadataAuthenticationEventExecutionPlanConfigurer"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationEventExecutionPlanConfigurer casCoreAuthenticationMetadataAuthenticationEventExecutionPlanConfigurer(@Qualifier(value="authenticationCredentialTypeMetaDataPopulator") AuthenticationMetaDataPopulator authenticationCredentialTypeMetaDataPopulator, @Qualifier(value="credentialCustomFieldsAttributeMetaDataPopulator") AuthenticationMetaDataPopulator credentialCustomFieldsAttributeMetaDataPopulator, @Qualifier(value="authenticationDateMetaDataPopulator") AuthenticationMetaDataPopulator authenticationDateMetaDataPopulator, @Qualifier(value="clientInfoAuthenticationMetaDataPopulator") AuthenticationMetaDataPopulator clientInfoAuthenticationMetaDataPopulator, @Qualifier(value="rememberMeAuthenticationMetaDataPopulator") AuthenticationMetaDataPopulator rememberMeAuthenticationMetaDataPopulator, @Qualifier(value="successfulHandlerMetaDataPopulator") AuthenticationMetaDataPopulator successfulHandlerMetaDataPopulator, @Qualifier(value="cacheCredentialsMetaDataPopulator") ObjectProvider<AuthenticationMetaDataPopulator> cacheCredentialsMetaDataPopulator) {
            return plan -> {
                plan.registerAuthenticationMetadataPopulator(successfulHandlerMetaDataPopulator);
                plan.registerAuthenticationMetadataPopulator(rememberMeAuthenticationMetaDataPopulator);
                plan.registerAuthenticationMetadataPopulator(authenticationCredentialTypeMetaDataPopulator);
                plan.registerAuthenticationMetadataPopulator(authenticationDateMetaDataPopulator);
                plan.registerAuthenticationMetadataPopulator(credentialCustomFieldsAttributeMetaDataPopulator);
                plan.registerAuthenticationMetadataPopulator(clientInfoAuthenticationMetaDataPopulator);
                cacheCredentialsMetaDataPopulator.ifAvailable(arg_0 -> ((AuthenticationEventExecutionPlan)plan).registerAuthenticationMetadataPopulator(arg_0));
            };
        }
    }

    @Configuration(value="CasCoreAuthenticationMetadataClearPassConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuthenticationMetadataClearPassConfiguration {
        @ConditionalOnMissingBean(name={"cacheCredentialsMetaDataPopulator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        @ConditionalOnProperty(prefix="cas.clearpass", name={"cache-credential"}, havingValue="true")
        public AuthenticationMetaDataPopulator cacheCredentialsMetaDataPopulator(@Qualifier(value="cacheCredentialsCipherExecutor") CipherExecutor cacheCredentialsCipherExecutor) {
            LOGGER.warn("CAS is configured to capture and cache credentials via Clearpass. Sharing the user credential with other applications is generally NOT recommended, may lead to security vulnerabilities and MUST only be used as a last resort .");
            return new CacheCredentialsMetaDataPopulator(cacheCredentialsCipherExecutor);
        }
    }

    @Configuration(value="CasCoreAuthenticationMetadataPopulatorConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuthenticationMetadataPopulatorConfiguration {
        @ConditionalOnMissingBean(name={"authenticationCredentialTypeMetaDataPopulator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationMetaDataPopulator authenticationCredentialTypeMetaDataPopulator() {
            return new AuthenticationCredentialTypeMetaDataPopulator();
        }

        @ConditionalOnMissingBean(name={"credentialCustomFieldsAttributeMetaDataPopulator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationMetaDataPopulator credentialCustomFieldsAttributeMetaDataPopulator() {
            return new CredentialCustomFieldsAttributeMetaDataPopulator();
        }

        @ConditionalOnMissingBean(name={"authenticationDateMetaDataPopulator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationMetaDataPopulator authenticationDateMetaDataPopulator() {
            return new AuthenticationDateAttributeMetaDataPopulator();
        }

        @ConditionalOnMissingBean(name={"clientInfoAuthenticationMetaDataPopulator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationMetaDataPopulator clientInfoAuthenticationMetaDataPopulator() {
            return new ClientInfoAuthenticationMetaDataPopulator();
        }

        @ConditionalOnMissingBean(name={"successfulHandlerMetaDataPopulator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationMetaDataPopulator successfulHandlerMetaDataPopulator() {
            return new SuccessfulHandlerMetaDataPopulator();
        }

        @ConditionalOnMissingBean(name={"rememberMeAuthenticationMetaDataPopulator"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public AuthenticationMetaDataPopulator rememberMeAuthenticationMetaDataPopulator(CasConfigurationProperties casProperties) {
            return new RememberMeAuthenticationMetaDataPopulator(casProperties.getTicket().getTgt().getRememberMe());
        }
    }

    @Configuration(value="CasCoreAuthenticationMetadataCipherConfiguration", proxyBeanMethods=false)
    @EnableConfigurationProperties(value={CasConfigurationProperties.class})
    public static class CasCoreAuthenticationMetadataCipherConfiguration {
        @ConditionalOnMissingBean(name={"cacheCredentialsCipherExecutor"})
        @Bean
        @RefreshScope(proxyMode=ScopedProxyMode.DEFAULT)
        public CipherExecutor cacheCredentialsCipherExecutor(CasConfigurationProperties casProperties) {
            ClearpassProperties cp = casProperties.getClearpass();
            if (cp.isCacheCredential()) {
                EncryptionJwtSigningJwtCryptographyProperties crypto = cp.getCrypto();
                if (crypto.isEnabled()) {
                    return CipherExecutorUtils.newStringCipherExecutor((EncryptionJwtSigningJwtCryptographyProperties)crypto, CacheCredentialsCipherExecutor.class);
                }
                LOGGER.warn("CAS is configured to capture and cache credentials via Clearpass yet crypto operations for the cached password are turned off. Consider enabling the crypto configuration in CAS settings that allow the system to sign & encrypt the captured credential.");
            }
            return CipherExecutor.noOp();
        }
    }
}

