/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.configuration.loader;

import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apereo.cas.configuration.loader.BaseConfigurationPropertiesLoader;
import org.apereo.cas.configuration.loader.GroovyConfigurationPropertiesLoader;
import org.apereo.cas.configuration.loader.SimpleConfigurationPropertiesLoader;
import org.apereo.cas.configuration.loader.YamlConfigurationPropertiesLoader;
import org.apereo.cas.util.crypto.CipherExecutor;
import org.apereo.cas.util.nativex.CasRuntimeHintsRegistrar;
import org.springframework.core.env.Environment;
import org.springframework.core.io.Resource;

public class ConfigurationPropertiesLoaderFactory {
    public static final String BEAN_NAME = "configurationPropertiesLoaderFactory";
    private final CipherExecutor<String, String> configurationCipherExecutor;
    private final Environment environment;

    public static List<String> getApplicationProfiles(Environment environment) {
        return Arrays.stream(environment.getActiveProfiles()).collect(Collectors.toList());
    }

    public BaseConfigurationPropertiesLoader getLoader(Resource resource, String name) {
        String filename = StringUtils.defaultString((String)resource.getFilename()).toLowerCase(Locale.ENGLISH);
        if (filename.endsWith(".properties")) {
            return new SimpleConfigurationPropertiesLoader(this.configurationCipherExecutor, name, resource);
        }
        if (filename.endsWith(".groovy") && CasRuntimeHintsRegistrar.notInNativeImage()) {
            return new GroovyConfigurationPropertiesLoader(this.configurationCipherExecutor, name, ConfigurationPropertiesLoaderFactory.getApplicationProfiles(this.environment), resource);
        }
        if (filename.endsWith(".yaml") || filename.endsWith(".yml")) {
            return new YamlConfigurationPropertiesLoader(this.configurationCipherExecutor, name, resource);
        }
        throw new IllegalArgumentException("Unable to determine configuration loader for " + String.valueOf(resource));
    }

    @Generated
    public ConfigurationPropertiesLoaderFactory(CipherExecutor<String, String> configurationCipherExecutor, Environment environment) {
        this.configurationCipherExecutor = configurationCipherExecutor;
        this.environment = environment;
    }
}

