/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.listener;

import java.time.Instant;
import java.time.ZonedDateTime;
import javax.validation.constraints.NotNull;
import lombok.Generated;
import org.apereo.cas.authentication.adaptive.geo.GeoLocationRequest;
import org.apereo.cas.support.events.AbstractCasEvent;
import org.apereo.cas.support.events.CasEventRepository;
import org.apereo.cas.support.events.authentication.CasAuthenticationPolicyFailureEvent;
import org.apereo.cas.support.events.authentication.CasAuthenticationTransactionFailureEvent;
import org.apereo.cas.support.events.authentication.adaptive.CasRiskyAuthenticationDetectedEvent;
import org.apereo.cas.support.events.dao.CasEvent;
import org.apereo.cas.support.events.listener.DefaultCasEventListener;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketCreatedEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketDestroyedEvent;
import org.apereo.cas.util.DateTimeUtils;
import org.apereo.cas.util.HttpRequestUtils;
import org.apereo.cas.util.serialization.MessageSanitizationUtils;
import org.apereo.inspektr.common.web.ClientInfo;
import org.apereo.inspektr.common.web.ClientInfoHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultCasAuthenticationEventListener
implements DefaultCasEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCasAuthenticationEventListener.class);
    @NotNull
    private final CasEventRepository casEventRepository;

    private static CasEvent prepareCasEvent(AbstractCasEvent event) {
        CasEvent dto = new CasEvent();
        dto.setType(event.getClass().getCanonicalName());
        dto.putTimestamp(Long.valueOf(event.getTimestamp()));
        ZonedDateTime dt = DateTimeUtils.zonedDateTimeOf((Instant)Instant.ofEpochMilli(event.getTimestamp()));
        dto.setCreationTime(dt.toString());
        ClientInfo clientInfo = ClientInfoHolder.getClientInfo();
        if (clientInfo != null) {
            dto.putClientIpAddress(clientInfo.getClientIpAddress());
            dto.putServerIpAddress(clientInfo.getServerIpAddress());
            dto.putAgent(clientInfo.getUserAgent());
            GeoLocationRequest location = HttpRequestUtils.getHttpServletRequestGeoLocation((String)clientInfo.getGeoLocation());
            dto.putGeoLocation(location);
        } else {
            LOGGER.trace("No client information is available. The final event cannot track client location, user agent or IP addresses");
        }
        return dto;
    }

    @Override
    public void handleCasTicketGrantingTicketCreatedEvent(CasTicketGrantingTicketCreatedEvent event) throws Exception {
        CasEvent dto = DefaultCasAuthenticationEventListener.prepareCasEvent((AbstractCasEvent)event);
        dto.setCreationTime(event.getTicketGrantingTicket().getCreationTime().toString());
        dto.putEventId(MessageSanitizationUtils.sanitize((String)event.getTicketGrantingTicket().getId()));
        dto.setPrincipalId(event.getTicketGrantingTicket().getAuthentication().getPrincipal().getId());
        this.casEventRepository.save(dto);
    }

    @Override
    public void handleCasTicketGrantingTicketDeletedEvent(CasTicketGrantingTicketDestroyedEvent event) throws Exception {
        CasEvent dto = DefaultCasAuthenticationEventListener.prepareCasEvent((AbstractCasEvent)event);
        dto.setCreationTime(event.getTicketGrantingTicket().getCreationTime().toString());
        dto.putEventId(MessageSanitizationUtils.sanitize((String)event.getTicketGrantingTicket().getId()));
        dto.setPrincipalId(event.getTicketGrantingTicket().getAuthentication().getPrincipal().getId());
        this.casEventRepository.save(dto);
    }

    @Override
    public void handleCasAuthenticationTransactionFailureEvent(CasAuthenticationTransactionFailureEvent event) throws Exception {
        CasEvent dto = DefaultCasAuthenticationEventListener.prepareCasEvent((AbstractCasEvent)event);
        dto.setPrincipalId(event.getCredential().getId());
        dto.putEventId(CasAuthenticationPolicyFailureEvent.class.getSimpleName());
        this.casEventRepository.save(dto);
    }

    @Override
    public void handleCasAuthenticationPolicyFailureEvent(CasAuthenticationPolicyFailureEvent event) throws Exception {
        CasEvent dto = DefaultCasAuthenticationEventListener.prepareCasEvent((AbstractCasEvent)event);
        dto.setPrincipalId(event.getAuthentication().getPrincipal().getId());
        dto.putEventId(CasAuthenticationPolicyFailureEvent.class.getSimpleName());
        this.casEventRepository.save(dto);
    }

    @Override
    public void handleCasRiskyAuthenticationDetectedEvent(CasRiskyAuthenticationDetectedEvent event) throws Exception {
        CasEvent dto = DefaultCasAuthenticationEventListener.prepareCasEvent((AbstractCasEvent)event);
        dto.putEventId(event.getService().getName());
        dto.setPrincipalId(event.getAuthentication().getPrincipal().getId());
        this.casEventRepository.save(dto);
    }

    @Generated
    public DefaultCasAuthenticationEventListener(CasEventRepository casEventRepository) {
        this.casEventRepository = casEventRepository;
    }

    @Generated
    public CasEventRepository getCasEventRepository() {
        return this.casEventRepository;
    }
}

