/*
 * Decompiled with CFR 0.152.
 */
package org.apereo.cas.support.events.listener;

import lombok.Generated;
import org.apereo.cas.authentication.principal.Principal;
import org.apereo.cas.support.events.authentication.CasAuthenticationPrincipalResolvedEvent;
import org.apereo.cas.support.events.authentication.CasAuthenticationTransactionFailureEvent;
import org.apereo.cas.support.events.listener.LoggingCasEventListener;
import org.apereo.cas.support.events.ticket.CasProxyTicketGrantedEvent;
import org.apereo.cas.support.events.ticket.CasServiceTicketGrantedEvent;
import org.apereo.cas.support.events.ticket.CasServiceTicketValidatedEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketCreatedEvent;
import org.apereo.cas.support.events.ticket.CasTicketGrantingTicketDestroyedEvent;
import org.apereo.cas.ticket.ServiceTicket;
import org.apereo.cas.ticket.proxy.ProxyGrantingTicket;
import org.apereo.cas.ticket.proxy.ProxyTicket;
import org.apereo.cas.util.serialization.MessageSanitizationUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLoggingCasEventListener
implements LoggingCasEventListener {
    @Generated
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLoggingCasEventListener.class);
    private static final String GRANTED_TGT_MSG = "Established SSO session at [{}]\nTGT: [{}], With TimeToLive: [{}], TimeToIdle: [{}]\nFor principal: [{}]";
    private static final String AUTHN_TX_FAIL_MSG = "Authentication transaction failed for credential: [{}]\nFailure(s): [{}]";
    private static final String PRINCIPAL_RESOLVED_MSG = "Principal [{}] resolved\nWith attributes: [{}]";
    private static final String DESTROYED_TGT_MSG = "SSO session ended\nTGT creation time: [{}] TGT: [{}], With TimeToLive: [{}], TimeToIdle: [{}]\nFor principal: [{}]\nInitiator source: [{}]";
    private static final String GRANTED_PT_MSG = "Proxy ticket granted at: [{}]\nPT: [{}], With TimeToLive: [{}], TimeToIdle: [{}]\nBy PGT: [{}], For service: [{}]\nProxied by: [{}]\nFor principal: [{}]";
    private static final String CREATED_ST_MSG = "Service ticket created at [{}]\nST: [{}]\nFor service: [{}]\nFor principal: [{}]";
    private static final String VALIDATED_ST_MSG = "Service ticket validated at [{}]\nST: [{}]\nFor service: [{}]\nFor principal: [{}]\nWith released attributes: [{}]";

    @Override
    public void logTicketGrantingTicketCreatedEvent(CasTicketGrantingTicketCreatedEvent e) {
        String tgtId = MessageSanitizationUtils.sanitize((String)e.getId());
        LOGGER.debug(GRANTED_TGT_MSG, new Object[]{e.getCreationTime(), tgtId, e.getTimeToLive(), e.getTimeToIdle(), e.getPrincipalId()});
    }

    @Override
    public void logAuthenticationTransactionFailureEvent(CasAuthenticationTransactionFailureEvent e) {
        LOGGER.debug(AUTHN_TX_FAIL_MSG, (Object)e.getCredential(), (Object)e.getFailures());
    }

    @Override
    public void logAuthenticationPrincipalResolvedEvent(CasAuthenticationPrincipalResolvedEvent e) {
        LOGGER.debug(PRINCIPAL_RESOLVED_MSG, (Object)e.getPrincipal().getId(), (Object)e.getPrincipal().getAttributes());
    }

    @Override
    public void logTicketGrantingTicketDestroyedEvent(CasTicketGrantingTicketDestroyedEvent e) {
        String tgtId = MessageSanitizationUtils.sanitize((String)e.getId());
        LOGGER.debug(DESTROYED_TGT_MSG, new Object[]{e.getCreationTime(), tgtId, e.getTimeToLive(), e.getTimeToIdle(), e.getPrincipalId(), e.getSource().getClass().getName()});
    }

    @Override
    public void logProxyTicketGrantedEvent(CasProxyTicketGrantedEvent e) {
        ProxyGrantingTicket pgt = e.getProxyGrantingTicket();
        ProxyTicket pt = e.getProxyTicket();
        String pgtId = MessageSanitizationUtils.sanitize((String)pgt.getId());
        String ptId = MessageSanitizationUtils.sanitize((String)pt.getId());
        String principal = pgt.getAuthentication().getPrincipal().getId();
        LOGGER.debug(GRANTED_PT_MSG, new Object[]{pt.getCreationTime(), ptId, pt.getExpirationPolicy().getTimeToLive(), pt.getExpirationPolicy().getTimeToIdle(), pgtId, pt.getService().getId(), pgt.getProxiedBy().getId(), principal});
    }

    @Override
    public void logServiceTicketGrantedEvent(CasServiceTicketGrantedEvent e) {
        ServiceTicket serviceTicket = e.getServiceTicket();
        LOGGER.debug(CREATED_ST_MSG, new Object[]{serviceTicket.getCreationTime(), serviceTicket.getId(), serviceTicket.getService().getId(), e.getTicketGrantingTicket().getAuthentication().getPrincipal().getId()});
    }

    @Override
    public void logServiceTicketValidatedEvent(CasServiceTicketValidatedEvent e) {
        ServiceTicket serviceTicket = e.getServiceTicket();
        Principal principal = serviceTicket.getTicketGrantingTicket().getAuthentication().getPrincipal();
        LOGGER.debug(VALIDATED_ST_MSG, new Object[]{serviceTicket.getCreationTime(), serviceTicket.getId(), serviceTicket.getService().getId(), principal.getId(), principal.getAttributes()});
    }
}

